/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.mail.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.HussarBaseEntity;
import com.jxdinfo.hussar.msg.app.service.AppSceneConfigService;
import com.jxdinfo.hussar.msg.constant.enums.BizCodeEnum;
import com.jxdinfo.hussar.msg.constant.enums.OpenStatusEnum;
import com.jxdinfo.hussar.msg.constant.utils.BizCodeUtils;
import com.jxdinfo.hussar.msg.mail.dao.MsgMailChannelMapper;
import com.jxdinfo.hussar.msg.mail.dto.MailChannelCreateDto;
import com.jxdinfo.hussar.msg.mail.dto.MailChannelQueryVo;
import com.jxdinfo.hussar.msg.mail.dto.MailChannelUpdateDto;
import com.jxdinfo.hussar.msg.mail.dto.MsgMailChannelPageDto;
import com.jxdinfo.hussar.msg.mail.model.MsgMailChannel;
import com.jxdinfo.hussar.msg.mail.service.MsgMailChannelService;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class MsgMailChannelServiceImpl
extends HussarServiceImpl<MsgMailChannelMapper, MsgMailChannel>
implements MsgMailChannelService {
    @Autowired
    private AppSceneConfigService appSceneConfigService;

    public IPage<MsgMailChannel> listPage(Page page, MsgMailChannelPageDto pageDto) {
        if (StringUtils.isNotEmpty((CharSequence)pageDto.getChannelName())) {
            pageDto.setChannelName(pageDto.getChannelName().trim());
        }
        if (StringUtils.isNotEmpty((CharSequence)pageDto.getChannelNo())) {
            pageDto.setChannelNo(pageDto.getChannelNo().trim());
        }
        if (StringUtils.isNotEmpty((CharSequence)pageDto.getMailAddress())) {
            pageDto.setMailAddress(pageDto.getMailAddress().trim());
        }
        if (StringUtils.isNotEmpty((CharSequence)pageDto.getSenderName())) {
            pageDto.setSenderName(pageDto.getSenderName().trim());
        }
        IPage<MsgMailChannel> pageList = ((MsgMailChannelMapper)this.baseMapper).queryPage(page, pageDto);
        return pageList;
    }

    public List<MailChannelQueryVo> getChannelList() {
        QueryWrapper qw = new QueryWrapper();
        qw.lambda().eq(MsgMailChannel::getStatus, (Object)OpenStatusEnum.ENABLE.getCode());
        qw.lambda().orderByDesc(HussarBaseEntity::getCreateTime);
        List list = ((MsgMailChannelMapper)this.baseMapper).selectList((Wrapper)qw);
        return list.stream().map(this::entity2QueryVo).collect(Collectors.toList());
    }

    public MailChannelQueryVo findById(Long id) {
        MsgMailChannel entity = (MsgMailChannel)super.getById((Serializable)id);
        return this.entity2QueryVo(entity);
    }

    public boolean save(MailChannelCreateDto createDto) {
        MsgMailChannel entity = new MsgMailChannel();
        BeanUtils.copyProperties((Object)createDto, (Object)entity);
        entity.setChannelNo(BizCodeUtils.generalBizCode(BizCodeEnum.MAIL_CHANNEL));
        if (HussarUtils.equals((Object)"1", (Object)this.checkChannelUnique(entity))) {
            throw new HussarException("\u901a\u9053\u540d\u79f0'" + entity.getChannelName() + "'\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539\uff01");
        }
        return super.save((BaseEntity)entity);
    }

    public boolean updateById(MailChannelUpdateDto updateDto) {
        MsgMailChannel entity = new MsgMailChannel();
        BeanUtils.copyProperties((Object)updateDto, (Object)entity);
        if (HussarUtils.equals((Object)"1", (Object)this.checkChannelUnique(entity))) {
            throw new HussarException("\u901a\u9053\u540d\u79f0'" + entity.getChannelName() + "'\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539\uff01");
        }
        return super.updateById((BaseEntity)entity);
    }

    public boolean delete(Long id) {
        if (this.appSceneConfigService.isExistScene(((MsgMailChannel)super.getById((Serializable)id)).getChannelNo())) {
            throw new HussarException("\u5b58\u5728\u76f8\u5173\u573a\u666f\uff0c\u8bf7\u5148\u5220\u9664\u573a\u666f\uff01");
        }
        return super.removeById((Serializable)id);
    }

    public boolean deleteChannelByIds(Long[] ids) {
        if (this.appSceneConfigService.isExistSceneInBatch(super.listByIds(Arrays.asList(ids)).stream().map(MsgMailChannel::getChannelNo).collect(Collectors.toList()))) {
            throw new HussarException("\u5b58\u5728\u76f8\u5173\u573a\u666f\uff0c\u8bf7\u5148\u5220\u9664\u573a\u666f\uff01");
        }
        return super.removeByIds(Arrays.asList(ids));
    }

    public MsgMailChannel getChannelInfo(String channelNo) {
        return ((MsgMailChannelMapper)this.baseMapper).getChannelInfo(channelNo);
    }

    private MailChannelQueryVo entity2QueryVo(MsgMailChannel entity) {
        MailChannelQueryVo vo = new MailChannelQueryVo();
        if (entity != null) {
            BeanUtils.copyProperties((Object)entity, (Object)vo);
        }
        return vo;
    }

    private String checkChannelUnique(MsgMailChannel entity) {
        Long id = HussarUtils.isEmpty((Object)entity.getId()) ? -1L : entity.getId();
        QueryWrapper qw = new QueryWrapper();
        qw.lambda().eq(MsgMailChannel::getChannelName, (Object)entity.getChannelName());
        MsgMailChannel info = (MsgMailChannel)this.getOne((Wrapper)qw, false);
        if (HussarUtils.isNotEmpty((Object)info) && !HussarUtils.equals((Object)info.getId(), (Object)id)) {
            return "1";
        }
        return "0";
    }
}

