/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.mail.config.mq;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.msg.mail.mongodb.document.MailSendRecord;
import com.jxdinfo.hussar.msg.mail.third.service.MailPushService;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MailRabbitMqReceiver {
    private static final Logger logger = LoggerFactory.getLogger(MailRabbitMqReceiver.class);
    @Autowired
    private MailPushService mailPushService;

    @RabbitHandler
    @RabbitListener(queues={"#{mailQueue.name}"})
    public void handlePay(Message message) {
        try {
            String json = new String(message.getBody(), StandardCharsets.UTF_8);
            logger.info("msg_Mail json:{}", (Object)json);
            MailSendRecord record = (MailSendRecord)JSONObject.parseObject((String)json, MailSendRecord.class);
            if (record.getBath().booleanValue()) {
                this.mailPushService.bathSend(record);
            } else {
                this.mailPushService.send(record);
            }
        }
        catch (Exception e) {
            logger.error("\u90ae\u4ef6\u670d\u52a1\u6d88\u606f\u5904\u7406\u9519\u8bef", (Throwable)e);
        }
    }
}

