/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.job.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.msg.appim.mongodb.document.AppImSendRecord;
import com.jxdinfo.hussar.msg.appim.third.service.AppImPushService;
import com.jxdinfo.hussar.msg.apppush.mongodb.document.AppPushSendRecord;
import com.jxdinfo.hussar.msg.apppush.service.AppPushSendRecordService;
import com.jxdinfo.hussar.msg.config.MsgJobExecutionProperties;
import com.jxdinfo.hussar.msg.config.UnifiedMessageProperties;
import com.jxdinfo.hussar.msg.cp.mongodb.document.MsgCpSendRecord;
import com.jxdinfo.hussar.msg.cp.service.CpSendService;
import com.jxdinfo.hussar.msg.job.dto.JobParamsVo;
import com.jxdinfo.hussar.msg.job.enums.MsgJobEnum;
import com.jxdinfo.hussar.msg.job.service.MsgJobService;
import com.jxdinfo.hussar.msg.mail.mongodb.document.MailSendRecord;
import com.jxdinfo.hussar.msg.mail.third.service.MailPushService;
import com.jxdinfo.hussar.msg.mp.mongodb.document.MsgMpSendRecord;
import com.jxdinfo.hussar.msg.mp.service.MpSendRecordService;
import com.jxdinfo.hussar.msg.notice.model.Notice;
import com.jxdinfo.hussar.msg.notice.service.NoticeSendRecordService;
import com.jxdinfo.hussar.msg.sms.mongodb.document.MsgSmsSendRecord;
import com.jxdinfo.hussar.msg.sms.third.service.SmsPushService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.job.core.enums.ExecuteType;
import com.jxdinfo.hussar.support.job.core.enums.ProcessorType;
import com.jxdinfo.hussar.support.job.core.enums.TimeExpressionType;
import com.jxdinfo.hussar.support.job.core.request.http.SaveJobInfoRequest;
import com.jxdinfo.hussar.support.job.dispatch.api.service.JobServiceService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class MsgJobServiceImpl
implements MsgJobService {
    private static final Logger logger = LoggerFactory.getLogger(MsgJobServiceImpl.class);
    @Autowired(required=false)
    private JobServiceService jobServiceService;
    @Autowired
    private SmsPushService smsPushService;
    @Autowired
    private MpSendRecordService mpSendRecordService;
    @Autowired
    private AppImPushService appImPushService;
    @Autowired
    private MailPushService mailPushService;
    @Autowired
    private AppPushSendRecordService msgAppInfoService;
    @Autowired
    private NoticeSendRecordService noticeSendRecordService;
    @Autowired
    private UnifiedMessageProperties unifiedMessageProperties;
    @Autowired
    private MsgJobExecutionProperties msgJobExecutionProperties;
    @Autowired
    private CpSendService cpSendService;

    public ApiResponse saveMsgJob(Date triggerTime, String params, MsgJobEnum msgJobEnum) {
        logger.info("\u6253\u5305\u6d4b\u8bd5");
        if (this.msgJobExecutionProperties.isEnableSingleModel()) {
            if (!this.msgJobExecutionProperties.isEnableExecutor() || !this.msgJobExecutionProperties.isEnableServer()) {
                throw new HussarException("\u4efb\u52a1\u8c03\u5ea6\u672a\u5f00\u542f\uff0c\u65e0\u6cd5\u53d1\u9001\u5b9a\u65f6\u6d88\u606f\uff01");
            }
        } else if (!this.msgJobExecutionProperties.isEnableExecutor()) {
            throw new HussarException("\u6267\u884c\u5668\u672a\u5f00\u542f\uff0c\u65e0\u6cd5\u53d1\u9001\u5b9a\u65f6\u6d88\u606f\uff01");
        }
        if (HussarUtils.isEmpty((Object)triggerTime)) {
            throw new HussarException("\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u65f6\u95f4\u4e3a\u7a7a\uff01");
        }
        if (triggerTime.getTime() < System.currentTimeMillis() + 120000L) {
            throw new HussarException("\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u65f6\u95f42\u5206\u949f\u4ee5\u4e0a\uff01");
        }
        if (HussarUtils.isNotEmpty((Object)this.jobServiceService)) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("ss mm HH dd MM ? yyyy");
            String jobTime = dateFormat.format(triggerTime);
            JobParamsVo jobParamsVo = new JobParamsVo();
            jobParamsVo.setType(msgJobEnum.getCode());
            jobParamsVo.setJobParams(params);
            SaveJobInfoRequest saveJobInfoRequest = new SaveJobInfoRequest();
            saveJobInfoRequest.setJobName(msgJobEnum.getName());
            saveJobInfoRequest.setJobDescription(msgJobEnum.getName());
            saveJobInfoRequest.setTimeExpression(jobTime);
            saveJobInfoRequest.setJobParams(JSONObject.toJSONString((Object)jobParamsVo));
            saveJobInfoRequest.setAppId(this.unifiedMessageProperties.getJobAppId());
            saveJobInfoRequest.setTimeExpressionType(TimeExpressionType.CRON);
            saveJobInfoRequest.setExecuteType(ExecuteType.STANDALONE);
            saveJobInfoRequest.setProcessorType(ProcessorType.BUILT_IN);
            saveJobInfoRequest.setProcessorInfo("com.jxdinfo.hussar.msg.config.MsgJobProcessors");
            try {
                ApiResponse response = this.jobServiceService.saveJobApi(saveJobInfoRequest);
                if (response.getCode() != ResultCode.SUCCESS.getCode()) {
                    throw new HussarException(response.getMsg());
                }
                return response;
            }
            catch (ParseException e) {
                throw new HussarException(e.getMessage());
            }
        }
        return ApiResponse.fail((String)"\u65e0\u6cd5\u6ce8\u5165Bean jobServiceService");
    }

    public void deleteMsgJob(Long jobId) {
        this.jobServiceService.physicalDeleteJob(jobId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void sendMsg(JobParamsVo jobParamsVo, Long jobId) {
        MsgJobEnum msgJobEnum = MsgJobEnum.getByCode((String)jobParamsVo.getType());
        if (msgJobEnum == null) {
            return;
        }
        try {
            switch (msgJobEnum) {
                case MSG_SMS: {
                    this.smsPushService.jobSendMsg((MsgSmsSendRecord)JSONObject.parseObject((String)jobParamsVo.getJobParams(), MsgSmsSendRecord.class));
                    return;
                }
                case MSG_MP: {
                    this.mpSendRecordService.jobMsg((MsgMpSendRecord)JSONObject.parseObject((String)jobParamsVo.getJobParams(), MsgMpSendRecord.class));
                    return;
                }
                case MSG_APPIM_TEXT: {
                    this.appImPushService.jobSendTextMsg((AppImSendRecord)JSONObject.parseObject((String)jobParamsVo.getJobParams(), AppImSendRecord.class));
                    return;
                }
                case MSG_APPIM_ARTICLE: {
                    this.appImPushService.jobSendArticleMsg((AppImSendRecord)JSONObject.parseObject((String)jobParamsVo.getJobParams(), AppImSendRecord.class));
                    return;
                }
                case MSG_APPIM_IMG: {
                    this.appImPushService.jobSendImgMsg((AppImSendRecord)JSONObject.parseObject((String)jobParamsVo.getJobParams(), AppImSendRecord.class));
                    return;
                }
                case MSG_APPIM_FILE: {
                    this.appImPushService.jobSendFileMsg((AppImSendRecord)JSONObject.parseObject((String)jobParamsVo.getJobParams(), AppImSendRecord.class));
                    return;
                }
                case MSG_MAIL: {
                    this.mailPushService.jobSend((MailSendRecord)JSONObject.parseObject((String)jobParamsVo.getJobParams(), MailSendRecord.class));
                    return;
                }
                case MSG_MAIL_BATH: {
                    this.mailPushService.jobBathSend((MailSendRecord)JSONObject.parseObject((String)jobParamsVo.getJobParams(), MailSendRecord.class));
                    return;
                }
                case MSG_APPPUSH: {
                    this.msgAppInfoService.jobMsg((AppPushSendRecord)JSONObject.parseObject((String)jobParamsVo.getJobParams(), AppPushSendRecord.class));
                    return;
                }
                case MSG_NOTICE: {
                    this.noticeSendRecordService.jonSendNotice((Notice)JSONObject.parseObject((String)jobParamsVo.getJobParams(), Notice.class));
                    return;
                }
                case MSG_CP: {
                    this.cpSendService.jobMsg((MsgCpSendRecord)JSONObject.parseObject((String)jobParamsVo.getJobParams(), MsgCpSendRecord.class));
                    return;
                }
                default: {
                    logger.error("\u9519\u8bef\u7684\u6d88\u606f\u7c7b\u578b");
                    return;
                }
            }
        }
        catch (Exception e) {
            logger.error(JSON.toJSONString((Object)jobParamsVo), (Object)e.getMessage());
            throw new RuntimeException(e);
        }
        finally {
            this.deleteMsgJob(jobId);
        }
    }
}

