/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.dingtalk.third.service.impl;

import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.request.OapiGettokenRequest;
import com.dingtalk.api.request.OapiMessageCorpconversationAsyncsendV2Request;
import com.dingtalk.api.response.OapiGettokenResponse;
import com.dingtalk.api.response.OapiMessageCorpconversationAsyncsendV2Response;
import com.jxdinfo.hussar.msg.constant.enums.DingTalkMsgTypeEnum;
import com.jxdinfo.hussar.msg.dingtalk.third.config.DingTalkConfig;
import com.jxdinfo.hussar.msg.dingtalk.third.dto.DingTalkParamDto;
import com.jxdinfo.hussar.msg.dingtalk.third.service.DingTalkThirdService;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.taobao.api.ApiException;
import com.taobao.api.TaobaoRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class DingTalkThirdServiceImpl
implements DingTalkThirdService {
    @Autowired
    private DingTalkConfig dingTalkConfig;
    private static final Logger logger = LoggerFactory.getLogger(DingTalkThirdServiceImpl.class);

    public OapiMessageCorpconversationAsyncsendV2Response sendDingTalkMsg(DingTalkParamDto paramDto) {
        String token = this.getToken(paramDto);
        String msgUrl = this.dingTalkConfig.getMsgUrl();
        OapiMessageCorpconversationAsyncsendV2Response rsp = new OapiMessageCorpconversationAsyncsendV2Response();
        try {
            DefaultDingTalkClient client = new DefaultDingTalkClient(msgUrl);
            OapiMessageCorpconversationAsyncsendV2Request req = new OapiMessageCorpconversationAsyncsendV2Request();
            req.setAgentId(paramDto.getAgentId());
            req.setUseridList(paramDto.getUserList());
            OapiMessageCorpconversationAsyncsendV2Request.Msg msg = new OapiMessageCorpconversationAsyncsendV2Request.Msg();
            msg.setMsgtype(DingTalkMsgTypeEnum.TEXT.getType());
            OapiMessageCorpconversationAsyncsendV2Request.Text text = new OapiMessageCorpconversationAsyncsendV2Request.Text();
            text.setContent(paramDto.getContent());
            msg.setText(text);
            req.setMsg(msg);
            rsp = (OapiMessageCorpconversationAsyncsendV2Response)client.execute((TaobaoRequest)req, token);
        }
        catch (ApiException e) {
            logger.error("\u8c03\u7528\u9489\u9489\u53d1\u9001\u5de5\u4f5c\u901a\u77e5\u63a5\u53e3\u51fa\u73b0\u5f02\u5e38:" + (Object)((Object)e));
        }
        return rsp;
    }

    private String getToken(DingTalkParamDto paramDto) {
        String token = "";
        String tokenUrl = this.dingTalkConfig.getTokenUrl();
        try {
            DefaultDingTalkClient client = new DefaultDingTalkClient(tokenUrl);
            OapiGettokenRequest req = new OapiGettokenRequest();
            req.setAppkey(paramDto.getAppKey());
            req.setAppsecret(paramDto.getAppSecret());
            req.setHttpMethod("GET");
            OapiGettokenResponse rsp = (OapiGettokenResponse)client.execute((TaobaoRequest)req);
            token = rsp.getAccessToken();
        }
        catch (ApiException e) {
            logger.error("\u8c03\u7528\u9489\u9489\u83b7\u53d6token\u63a5\u53e3\u51fa\u73b0\u5f02\u5e38:" + (Object)((Object)e));
        }
        return token;
    }
}

