/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.dingtalk.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.dingtalk.api.response.OapiMessageCorpconversationAsyncsendV2Response;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.msg.constant.enums.AppEnum;
import com.jxdinfo.hussar.msg.constant.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.constant.utils.IdUtil;
import com.jxdinfo.hussar.msg.dingtalk.config.mongodb.repository.DingTalkSendRecordRepository;
import com.jxdinfo.hussar.msg.dingtalk.dto.DingTalkSendDto;
import com.jxdinfo.hussar.msg.dingtalk.dto.DingTalkSendRecordDto;
import com.jxdinfo.hussar.msg.dingtalk.model.DingTalkChannel;
import com.jxdinfo.hussar.msg.dingtalk.mongodb.document.DingTalkSendRecord;
import com.jxdinfo.hussar.msg.dingtalk.service.DingTalkChannelService;
import com.jxdinfo.hussar.msg.dingtalk.service.DingTalkSendService;
import com.jxdinfo.hussar.msg.dingtalk.third.dto.DingTalkParamDto;
import com.jxdinfo.hussar.msg.dingtalk.third.service.DingTalkThirdService;
import com.jxdinfo.hussar.msg.job.enums.MsgJobEnum;
import com.jxdinfo.hussar.msg.job.service.MsgJobService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class DingTalkSendServiceImpl
implements DingTalkSendService {
    @Autowired
    private DingTalkChannelService dingTalkChannelService;
    @Autowired
    private MsgJobService msgJobService;
    @Autowired
    private DingTalkSendRecordRepository recordRepository;
    @Autowired
    private DingTalkThirdService dingTalkThirdService;
    private static final Logger logger = LoggerFactory.getLogger(DingTalkSendServiceImpl.class);

    public boolean testSendMsg(DingTalkSendDto dto) {
        if (HussarUtils.isEmpty((Object)dto)) {
            throw new HussarException("\u4f20\u5165\u53c2\u6570\u4e3a\u7a7a");
        }
        DingTalkChannel channel = this.dingTalkChannelService.selectbyChannelNo(dto.getChannelNo());
        if (HussarUtils.isEmpty((Object)channel)) {
            throw new HussarException("\u6682\u672a\u67e5\u8be2\u5230\u901a\u9053\u4fe1\u606f");
        }
        DingTalkSendRecordDto info = new DingTalkSendRecordDto();
        info.setChannelId(channel.getId().toString());
        info.setChannelNo(channel.getChannelNo());
        info.setChannelName(channel.getChannelName());
        info.setAgentId(channel.getAgentId());
        info.setDingAppName(channel.getAppName());
        info.setCorpName(channel.getCorpName());
        info.setAppKey(channel.getAppKey());
        info.setDingAppSecret(channel.getAppSecret());
        info.setToUser(dto.getToUser());
        info.setContent(dto.getData());
        info.setStatus(SendStatusEnum.SENDING.getCode());
        info.setTim(dto.getTim());
        info.setJobTime(dto.getJobTime());
        info.setTenantCode(dto.getTenantCode());
        info.setAppId(AppEnum.TEST.getAppId());
        info.setAppName(AppEnum.TEST.getAppName());
        info.setAppSecret(AppEnum.TEST.getAppSecret());
        info.setSceneCode(AppEnum.TEST.getSceneCode());
        info.setSceneName(AppEnum.TEST.getSceneName());
        return this.sendDingTalkMsg(info);
    }

    public boolean sendDingTalkMsg(DingTalkSendRecordDto dto) {
        DingTalkSendRecord record = new DingTalkSendRecord();
        BeanUtils.copyProperties((Object)dto, (Object)((Object)record));
        if (null != record.getTim() && record.getTim().booleanValue()) {
            String msgId = IdUtil.fastSimpleUuid();
            record.setMsgId(msgId);
            this.msgJobService.saveMsgJob(record.getJobTime(), JSONObject.toJSONString((Object)((Object)record)), MsgJobEnum.MSG_DINGTALK);
            Date now = new Date();
            record.setCreateTime(now);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            record.setCreateDate(dateFormat.format(now));
            record.setSendTime(record.getJobTime());
            this.recordRepository.save((Object)record);
            return true;
        }
        return this.sendMsg(record);
    }

    public boolean jobSendMsg(DingTalkSendRecordDto dto) {
        DingTalkSendRecord record = new DingTalkSendRecord();
        BeanUtils.copyProperties((Object)dto, (Object)((Object)record));
        this.sendMsg(record);
        DingTalkSendRecord query = new DingTalkSendRecord();
        query.setMsgId(record.getMsgId());
        Example example = Example.of((Object)((Object)query));
        DingTalkSendRecord entity = (DingTalkSendRecord)((Object)this.recordRepository.findOne(example).get());
        if (HussarUtils.isNotEmpty((Object)entity.getId())) {
            entity.setStatus(record.getStatus());
            entity.setErrMsg(record.getErrMsg());
            this.recordRepository.save((Object)entity);
        }
        return true;
    }

    private boolean sendMsg(DingTalkSendRecord record) {
        boolean flag = true;
        Integer status = SendStatusEnum.SUCCESS.getCode();
        record.setErrMsg(null);
        DingTalkParamDto paramDto = new DingTalkParamDto();
        paramDto.setAppKey(record.getAppKey());
        paramDto.setAppSecret(record.getDingAppSecret());
        paramDto.setContent(record.getContent());
        paramDto.setUserList(record.getToUser());
        paramDto.setAgentId(Long.valueOf(Long.parseLong(record.getAgentId())));
        try {
            OapiMessageCorpconversationAsyncsendV2Response rsp = this.dingTalkThirdService.sendDingTalkMsg(paramDto);
            if (rsp.getErrcode() != 0L) {
                status = SendStatusEnum.FAIL.getCode();
                flag = false;
            }
            record.setErrMsg(rsp.getErrmsg());
        }
        catch (Exception e) {
            logger.error("\u9489\u9489\u6d88\u606f\u53d1\u9001\u5f02\u5e38\uff1a", (Throwable)e);
            status = SendStatusEnum.FAIL.getCode();
            record.setErrMsg(e.getMessage());
            flag = false;
        }
        record.setStatus(status);
        if (HussarUtils.isEmpty((Object)record.getMsgId())) {
            String msgId = IdUtil.fastSimpleUuid();
            Date now = new Date();
            record.setMsgId(msgId);
            record.setCreateTime(now);
            Date sendTime = new Date();
            record.setSendTime(sendTime);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            record.setCreateDate(dateFormat.format(now));
            this.recordRepository.save((Object)record);
        }
        return flag;
    }
}

