/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.dingtalk.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.msg.constant.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.constant.utils.Strings;
import com.jxdinfo.hussar.msg.constant.utils.TenantCodeUtils;
import com.jxdinfo.hussar.msg.dingtalk.config.mongodb.repository.DingTalkSendRecordRepository;
import com.jxdinfo.hussar.msg.dingtalk.dto.DingTalkChSendStatisticsVo;
import com.jxdinfo.hussar.msg.dingtalk.dto.DingTalkRecordDto;
import com.jxdinfo.hussar.msg.dingtalk.dto.DingTalkSendRecordDto;
import com.jxdinfo.hussar.msg.dingtalk.mongodb.document.DingTalkSendRecord;
import com.jxdinfo.hussar.msg.dingtalk.service.DingTalkSendRecordService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class DingTalkSendRecordServiceImpl
implements DingTalkSendRecordService {
    private static final Logger logger = LoggerFactory.getLogger(DingTalkSendRecordServiceImpl.class);
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private DingTalkSendRecordRepository recordRepository;

    public IPage<DingTalkSendRecordDto> listPage(Page page, DingTalkRecordDto pageDto) {
        Query query = new Query();
        Criteria criteria = new Criteria();
        if (pageDto.getBeginTime() != null && pageDto.getEndTime() != null) {
            Criteria fromTime = Criteria.where((String)"createTime").gt((Object)pageDto.getBeginTime());
            Criteria toTime = Criteria.where((String)"createTime").lt((Object)pageDto.getEndTime());
            criteria.andOperator(new Criteria[]{fromTime, toTime});
        }
        TenantCodeUtils.fillCriteriaTenantCode(criteria);
        if (pageDto.getToUser() != null) {
            criteria.and("toUser").is((Object)pageDto.getToUser());
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getAppName())) {
            criteria.and("appName").regex(Strings.format("%s%s%s", ".*", pageDto.getAppName(), ".*"));
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getChannelName())) {
            criteria.orOperator(new Criteria[]{Criteria.where((String)"channelName").regex(Strings.format("%s%s%s", ".*", pageDto.getChannelName(), ".*")), Criteria.where((String)"channelNo").regex(Strings.format("%s%s%s", ".*", pageDto.getChannelName(), ".*"))});
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getSceneCode())) {
            criteria.and("sceneCode").regex(Strings.format("%s%s%s", ".*", pageDto.getSceneCode(), ".*"));
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getSceneName())) {
            criteria.and("sceneName").regex(Strings.format("%s%s%s", ".*", pageDto.getSceneName(), ".*"));
        }
        if (pageDto.getStatus() != null) {
            criteria.and("status").is((Object)pageDto.getStatus());
        }
        if (pageDto.getContent() != null) {
            String reges = Strings.format("%s%s%s", "^.*", pageDto.getContent().trim(), ".*$");
            Pattern pattern = Pattern.compile(reges, 2);
            criteria.and("content").regex(pattern);
        }
        if (pageDto.getCorpName() != null) {
            criteria.and("corpName").regex(Strings.format("%s%s%s", ".*", pageDto.getCorpName(), ".*"));
        }
        if (pageDto.getDingAppName() != null) {
            criteria.and("dingAppName").regex(Strings.format("%s%s%s", ".*", pageDto.getDingAppName(), ".*"));
        }
        query.addCriteria((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"createTime")}));
        long total = this.mongoTemplate.count(query, DingTalkSendRecord.class);
        query.skip((page.getCurrent() - 1L) * page.getSize());
        query.limit((int)page.getSize());
        List list = this.mongoTemplate.find(query, DingTalkSendRecord.class);
        List pageList = list.stream().map(this::transferDto).collect(Collectors.toList());
        Page pages = new Page();
        pages.setCurrent(page.getCurrent());
        pages.setSize(page.getSize());
        pages.setTotal(total);
        pages.setRecords(pageList);
        return pages;
    }

    private DingTalkSendRecordDto transferDto(DingTalkSendRecord dingTalkSendRecord) {
        DingTalkRecordDto dingTalkSendRecordDto = new DingTalkRecordDto();
        BeanUtils.copyProperties((Object)((Object)dingTalkSendRecord), (Object)dingTalkSendRecordDto);
        return dingTalkSendRecordDto;
    }

    public List<DingTalkChSendStatisticsVo> sendStatistics(DingTalkRecordDto pageDto) {
        Criteria criteria = new Criteria();
        if (pageDto.getBeginTime() != null && pageDto.getEndTime() != null) {
            Criteria fromTime = Criteria.where((String)"createTime").gt((Object)pageDto.getBeginTime());
            Criteria toTime = Criteria.where((String)"createTime").lt((Object)pageDto.getEndTime());
            criteria.andOperator(new Criteria[]{fromTime, toTime});
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getChannelNo())) {
            criteria.and("channelNo").is((Object)pageDto.getChannelNo());
        }
        TenantCodeUtils.fillCriteriaTenantCode(criteria);
        Aggregation agg = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{"channelNo", "createDate", "status", "channelName"}).count().as("count")});
        AggregationResults aggregate = this.mongoTemplate.aggregate(agg, DingTalkSendRecord.class, SendRecordAgg.class);
        List mappedResults = aggregate.getMappedResults();
        Map<String, List<SendRecordAgg>> listMap = mappedResults.parallelStream().collect(Collectors.groupingBy(SendRecordAgg::getChannelNo));
        List createDateList = mappedResults.parallelStream().map(SendRecordAgg::getCreateDate).distinct().sorted().collect(Collectors.toList());
        ArrayList<DingTalkChSendStatisticsVo> result = new ArrayList<DingTalkChSendStatisticsVo>();
        listMap.forEach((channelNo, aggs) -> {
            DingTalkChSendStatisticsVo statisticsVo = new DingTalkChSendStatisticsVo();
            statisticsVo.setChannelNo(channelNo);
            statisticsVo.setChannelName(HussarUtils.isNotEmpty((Object)aggs) ? ((SendRecordAgg)aggs.get(0)).getChannelName() : null);
            statisticsVo.setCreateDate(createDateList);
            ArrayList aggVos = new ArrayList();
            Map<String, Map<Integer, List<SendRecordAgg>>> collect = aggs.parallelStream().collect(Collectors.groupingBy(SendRecordAgg::getCreateDate, Collectors.groupingBy(SendRecordAgg::getStatus)));
            collect.forEach((createTime, aggs1) -> {
                DingTalkChSendStatisticsVo.DingTalkChannelSendStatisticAgg aggVo = new DingTalkChSendStatisticsVo.DingTalkChannelSendStatisticAgg();
                aggVo.setSendDate(createTime);
                aggs1.forEach((status, aggs2) -> {
                    if (status.equals(SendStatusEnum.SUCCESS.getCode())) {
                        aggVo.setSuccessCount(((SendRecordAgg)aggs2.get(0)).count);
                    } else if (status.equals(SendStatusEnum.FAIL.getCode())) {
                        aggVo.setFailCount(((SendRecordAgg)aggs2.get(0)).count);
                    } else if (status.equals(SendStatusEnum.SENDING.getCode())) {
                        aggVo.setWillCount(((SendRecordAgg)aggs2.get(0)).count);
                    }
                });
                aggVos.add(aggVo);
            });
            statisticsVo.setAggs(aggVos);
            result.add(statisticsVo);
        });
        return result;
    }

    public static class SendRecordAgg {
        private String channelNo;
        private String channelName;
        private String createDate;
        private Integer status;
        private Long count;

        public String getChannelNo() {
            return this.channelNo;
        }

        public String getChannelName() {
            return this.channelName;
        }

        public void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        public void setChannelNo(String channelNo) {
            this.channelNo = channelNo;
        }

        public String getCreateDate() {
            return this.createDate;
        }

        public void setCreateDate(String createDate) {
            this.createDate = createDate;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public Long getCount() {
            return this.count;
        }

        public void setCount(Long count) {
            this.count = count;
        }
    }
}

