/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.dingtalk.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.HussarBaseEntity;
import com.jxdinfo.hussar.msg.app.service.AppSceneConfigService;
import com.jxdinfo.hussar.msg.constant.enums.BizCodeEnum;
import com.jxdinfo.hussar.msg.constant.enums.OpenStatusEnum;
import com.jxdinfo.hussar.msg.constant.utils.BizCodeUtils;
import com.jxdinfo.hussar.msg.dingtalk.dao.DingTalkChannelMapper;
import com.jxdinfo.hussar.msg.dingtalk.dto.DingTalkChCreateDto;
import com.jxdinfo.hussar.msg.dingtalk.dto.DingTalkChUpdateDto;
import com.jxdinfo.hussar.msg.dingtalk.dto.DingTalkChannelDto;
import com.jxdinfo.hussar.msg.dingtalk.model.DingTalkChannel;
import com.jxdinfo.hussar.msg.dingtalk.service.DingTalkChannelService;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class DingTalkChannelServiceImpl
extends HussarServiceImpl<DingTalkChannelMapper, DingTalkChannel>
implements DingTalkChannelService {
    @Autowired
    private AppSceneConfigService appSceneConfigService;

    public IPage<DingTalkChannel> listPage(Page page, DingTalkChannelDto dto) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dto.getChannelName()})) {
            dto.setChannelName("%" + dto.getChannelName().trim() + "%");
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dto.getChannelNo()})) {
            dto.setChannelNo("%" + dto.getChannelNo().trim() + "%");
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dto.getCorpName()})) {
            dto.setCorpName("%" + dto.getCorpName().trim() + "%");
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dto.getAppName()})) {
            dto.setAppName("%" + dto.getAppName().trim() + "%");
        }
        IPage<DingTalkChannel> pageList = ((DingTalkChannelMapper)this.baseMapper).queryPage(page, dto);
        return pageList;
    }

    public boolean save(DingTalkChCreateDto createDto) {
        DingTalkChannel dingTalkChannel = new DingTalkChannel();
        BeanUtils.copyProperties((Object)createDto, (Object)dingTalkChannel);
        long id = IdWorker.getId((Object)dingTalkChannel);
        dingTalkChannel.setId(Long.valueOf(id));
        dingTalkChannel.setChannelNo(BizCodeUtils.generalBizCode(BizCodeEnum.DINGTALK_CHANNEL));
        if (HussarUtils.equals((Object)"1", (Object)this.checkChannelUnique(dingTalkChannel))) {
            throw new HussarException("\u901a\u9053\u540d\u79f0'" + dingTalkChannel.getChannelName() + "'\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539\uff01");
        }
        return super.save((BaseEntity)dingTalkChannel);
    }

    public boolean update(DingTalkChUpdateDto updateDto) {
        if (null == updateDto) {
            updateDto = new DingTalkChUpdateDto();
        }
        QueryWrapper qw = new QueryWrapper();
        qw.lambda().eq(DingTalkChannel::getId, (Object)updateDto.getId());
        DingTalkChannel info = (DingTalkChannel)((DingTalkChannelMapper)this.baseMapper).selectOne((Wrapper)qw);
        if (HussarUtils.isEmpty((Object)info)) {
            throw new HussarException("\u8be5\u901a\u9053\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u8fdb\u884c\u4fee\u6539\uff01");
        }
        DingTalkChannel dingTalkChannel = new DingTalkChannel();
        BeanUtils.copyProperties((Object)updateDto, (Object)dingTalkChannel);
        return super.updateById((BaseEntity)dingTalkChannel);
    }

    public boolean delete(Long id) {
        DingTalkChannel dingTalkChannel = (DingTalkChannel)((DingTalkChannelMapper)this.baseMapper).selectById(id);
        if (HussarUtils.isEmpty((Object)dingTalkChannel)) {
            throw new HussarException("\u8be5\u901a\u9053\u4e0d\u5b58\u5728,\u65e0\u6cd5\u8fdb\u884c\u5220\u9664\uff01");
        }
        if (this.appSceneConfigService.isExistScene(dingTalkChannel.getChannelNo())) {
            throw new HussarException("\u5b58\u5728\u76f8\u5173\u573a\u666f\uff0c\u8bf7\u5148\u5220\u9664\u573a\u666f\uff01");
        }
        return super.removeById((Serializable)id);
    }

    public boolean deleteByIds(Long[] ids) {
        if (this.appSceneConfigService.isExistSceneInBatch(super.listByIds(Arrays.asList(ids)).stream().map(DingTalkChannel::getChannelNo).collect(Collectors.toList()))) {
            throw new HussarException("\u5b58\u5728\u76f8\u5173\u573a\u666f\uff0c\u8bf7\u5148\u5220\u9664\u573a\u666f\uff01");
        }
        return super.removeByIds(Arrays.asList(ids));
    }

    public List<DingTalkChannelDto> getChannelList() {
        QueryWrapper qw = new QueryWrapper();
        qw.lambda().eq(DingTalkChannel::getStatus, (Object)OpenStatusEnum.ENABLE.getCode());
        qw.lambda().orderByDesc(HussarBaseEntity::getCreateTime);
        List list = ((DingTalkChannelMapper)this.baseMapper).selectList((Wrapper)qw);
        return list.stream().map(this::transferDto).collect(Collectors.toList());
    }

    public DingTalkChannel selectbyChannelNo(String channelNo) {
        QueryWrapper qw = new QueryWrapper();
        qw.lambda().eq(DingTalkChannel::getStatus, (Object)OpenStatusEnum.ENABLE.getCode());
        qw.lambda().eq(DingTalkChannel::getChannelNo, (Object)channelNo);
        DingTalkChannel dingTalkChannel = (DingTalkChannel)((DingTalkChannelMapper)this.baseMapper).selectOne((Wrapper)qw);
        return dingTalkChannel;
    }

    private DingTalkChannelDto transferDto(DingTalkChannel dingTalkChannel) {
        DingTalkChannelDto dto = new DingTalkChannelDto();
        BeanUtils.copyProperties((Object)dingTalkChannel, (Object)dto);
        return dto;
    }

    private String checkChannelUnique(DingTalkChannel dingTalkChannel) {
        Long id = dingTalkChannel.getId();
        QueryWrapper qw = new QueryWrapper();
        qw.lambda().eq(DingTalkChannel::getChannelName, (Object)dingTalkChannel.getChannelName());
        DingTalkChannel channel = (DingTalkChannel)this.getOne((Wrapper)qw, false);
        if (HussarUtils.isNotEmpty((Object)channel) && HussarUtils.equals((Object)channel.getId(), (Object)id)) {
            return "1";
        }
        return "0";
    }
}

