/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.dingtalk.config.mq;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.msg.app.dto.ConfigJsonData;
import com.jxdinfo.hussar.msg.app.model.AppAccess;
import com.jxdinfo.hussar.msg.app.service.AppAccessService;
import com.jxdinfo.hussar.msg.app.service.AppSceneConfigService;
import com.jxdinfo.hussar.msg.constant.enums.QueueEnum;
import com.jxdinfo.hussar.msg.constant.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.constant.enums.ServiceTypeEnum;
import com.jxdinfo.hussar.msg.dingtalk.dto.DingTalkSendDto;
import com.jxdinfo.hussar.msg.dingtalk.dto.DingTalkSendRecordDto;
import com.jxdinfo.hussar.msg.dingtalk.model.DingTalkChannel;
import com.jxdinfo.hussar.msg.dingtalk.service.DingTalkChannelService;
import com.jxdinfo.hussar.support.exception.HussarException;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DingTalkRabbitMqSendService {
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private AppAccessService appAccessService;
    @Autowired
    private AppSceneConfigService appSceneConfigService;
    @Autowired
    private DingTalkChannelService dingTalkChannelService;

    public boolean send(DingTalkSendDto dto) {
        AppAccess appAccess = this.appAccessService.getAppAccess(dto.getAppId(), dto.getAppSecret());
        ConfigJsonData configData = this.appSceneConfigService.getConfigData(dto.getSceneCode(), appAccess.getId().toString(), ServiceTypeEnum.DINGTALK.getCode());
        dto.setChannelNo(configData.getChannelNo());
        DingTalkChannel channel = this.dingTalkChannelService.selectbyChannelNo(dto.getChannelNo());
        if (null == channel) {
            throw new HussarException("\u6682\u672a\u67e5\u8be2\u5230\u901a\u9053");
        }
        DingTalkSendRecordDto record = new DingTalkSendRecordDto();
        record.setChannelId(channel.getId().toString());
        record.setChannelNo(channel.getChannelNo());
        record.setChannelName(channel.getChannelName());
        record.setAppKey(channel.getAppKey());
        record.setDingAppSecret(channel.getAppSecret());
        record.setDingAppName(channel.getAppName());
        record.setAgentId(channel.getAgentId());
        record.setCorpName(channel.getCorpName());
        record.setToUser(dto.getToUser());
        record.setContent(dto.getData());
        record.setTim(dto.getTim());
        record.setJobTime(dto.getJobTime());
        record.setAppId(dto.getAppId());
        record.setAppName(appAccess.getAppName());
        record.setAppSecret(dto.getAppSecret());
        record.setStatus(SendStatusEnum.SENDING.getCode());
        record.setSceneCode(dto.getSceneCode());
        record.setSceneName(configData.getSceneName());
        record.setTenantCode(dto.getTenantCode());
        String s = JSONObject.toJSONString((Object)record);
        Message message = new Message(s.getBytes(), new MessageProperties());
        this.rabbitTemplate.convertAndSend(QueueEnum.QUEUE_MSG_DINGTALK.getExchange(), QueueEnum.QUEUE_MSG_DINGTALK.getRouteKey(), (Object)message);
        return true;
    }
}

