/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.dingtalk.config.mq;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.msg.dingtalk.dto.DingTalkSendRecordDto;
import com.jxdinfo.hussar.msg.dingtalk.service.DingTalkSendService;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DingTalkRabbitMqReceiver {
    private static final Logger logger = LoggerFactory.getLogger(DingTalkRabbitMqReceiver.class);
    @Autowired
    private DingTalkSendService dingTalkSendService;

    @RabbitHandler
    @RabbitListener(queues={"#{dingTalkQueue.name}"})
    public void handlePay(Message message) {
        try {
            String json = new String(message.getBody(), StandardCharsets.UTF_8);
            logger.info("msg dingtalk json:{}", (Object)json);
            DingTalkSendRecordDto info = (DingTalkSendRecordDto)JSONObject.parseObject((String)json, DingTalkSendRecordDto.class);
            boolean bl = this.dingTalkSendService.sendDingTalkMsg(info);
        }
        catch (Exception e) {
            logger.error("\u9489\u9489\u6d88\u606f\u5904\u7406\u9519\u8bef", (Throwable)e);
        }
    }
}

