/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.cp.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.msg.constant.enums.AppEnum;
import com.jxdinfo.hussar.msg.constant.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.constant.utils.IdUtil;
import com.jxdinfo.hussar.msg.cp.config.mongodb.repository.MsgCpSendRecordRepository;
import com.jxdinfo.hussar.msg.cp.dto.CpSendMsgCreateDto;
import com.jxdinfo.hussar.msg.cp.model.MsgCpChannel;
import com.jxdinfo.hussar.msg.cp.mongodb.document.MsgCpSendRecord;
import com.jxdinfo.hussar.msg.cp.service.CpChannelService;
import com.jxdinfo.hussar.msg.cp.service.CpSendService;
import com.jxdinfo.hussar.msg.cp.third.dto.CpSendMsgConfigDto;
import com.jxdinfo.hussar.msg.cp.third.service.MsgCpSendThirdService;
import com.jxdinfo.hussar.msg.job.enums.MsgJobEnum;
import com.jxdinfo.hussar.msg.job.service.MsgJobService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import me.chanjar.weixin.cp.bean.message.WxCpMessageSendResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Example;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class CpSendServiceImpl
implements CpSendService {
    @Autowired
    private MsgJobService msgJobService;
    @Autowired
    private MsgCpSendRecordRepository msgCpSendRecordRepository;
    @Autowired
    private MsgCpSendThirdService msgCpSendThirdService;
    @Autowired
    private CpChannelService cpChannelService;
    private static final Logger logger = LoggerFactory.getLogger(CpSendServiceImpl.class);

    public boolean testSendCpMsg(CpSendMsgCreateDto createDto) {
        MsgCpChannel channel = this.cpChannelService.selectChannel(createDto.getChannelId(), createDto.getChannelNo());
        MsgCpSendRecord info = new MsgCpSendRecord();
        info.setChannelId(channel.getId().toString());
        info.setChannelNo(channel.getChannelNo());
        info.setChannelName(channel.getChannelName());
        info.setCorpId(channel.getCorpID());
        info.setAgentId(channel.getAgentId());
        info.setAgentName(channel.getAgentName());
        info.setCorpName(channel.getCorpName());
        info.setAgentSecret(channel.getAgentSecret());
        info.setToUser(createDto.getToUser());
        info.setContent(createDto.getData());
        info.setStatus(SendStatusEnum.SENDING.getCode());
        info.setTim(createDto.getTim());
        info.setJobTime(createDto.getJobTime());
        info.setAppId(AppEnum.TEST.getAppId());
        info.setAppName(AppEnum.TEST.getAppName());
        info.setAppSecret(AppEnum.TEST.getAppSecret());
        info.setSceneCode(AppEnum.TEST.getSceneCode());
        info.setSceneName(AppEnum.TEST.getSceneName());
        return this.sendCpMsg(info);
    }

    public boolean sendCpMsg(MsgCpSendRecord info) {
        if (null != info.getTim() && info.getTim().booleanValue()) {
            String msgId = IdUtil.fastSimpleUuid();
            info.setMsgId(msgId);
            this.msgJobService.saveMsgJob(info.getJobTime(), JSONObject.toJSONString((Object)info), MsgJobEnum.MSG_CP);
            Date now = new Date();
            info.setCreateTime(now);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            info.setCreateDate(dateFormat.format(now));
            info.setSendTime(info.getJobTime());
            this.msgCpSendRecordRepository.save(info);
            return true;
        }
        return this.sendMsg(info);
    }

    public boolean jobMsg(MsgCpSendRecord info) {
        this.sendMsg(info);
        MsgCpSendRecord query = new MsgCpSendRecord();
        query.setMsgId(info.getMsgId());
        Example example = Example.of((Object)query);
        MsgCpSendRecord entity = (MsgCpSendRecord)this.msgCpSendRecordRepository.findOne(example).get();
        if (HussarUtils.isNotEmpty((Object)entity.getId())) {
            entity.setStatus(info.getStatus());
            entity.setErrMsg(info.getErrMsg());
            this.msgCpSendRecordRepository.save(entity);
        }
        return true;
    }

    private boolean sendMsg(MsgCpSendRecord info) {
        boolean flag = true;
        Integer status = SendStatusEnum.SUCCESS.getCode();
        info.setErrMsg(null);
        HashMap mpConfig = new HashMap();
        CpSendMsgConfigDto cpConfig = new CpSendMsgConfigDto();
        cpConfig.setToUser(info.getToUser().replace(",", "|"));
        cpConfig.setAgentId(Integer.valueOf(Integer.parseInt(info.getAgentId())));
        cpConfig.setContent(info.getContent());
        cpConfig.setAgentSecret(info.getAgentSecret());
        cpConfig.setCorpId(info.getCorpId());
        try {
            WxCpMessageSendResult wxCpMessageSendResult = this.msgCpSendThirdService.sendCpMsg(cpConfig);
            if (wxCpMessageSendResult.getErrCode() != 0) {
                status = SendStatusEnum.FAIL.getCode();
                info.setErrMsg(wxCpMessageSendResult.getErrMsg());
                flag = false;
            }
        }
        catch (Exception e) {
            logger.error("\u4f01\u4e1a\u5fae\u4fe1\u6d88\u606f\u53d1\u9001\u5f02\u5e38\uff1a", (Throwable)e);
            status = SendStatusEnum.FAIL.getCode();
            info.setErrMsg(e.getMessage());
            flag = false;
        }
        info.setStatus(status);
        if (HussarUtils.isEmpty((Object)info.getMsgId())) {
            String msgId = IdUtil.fastSimpleUuid();
            Date now = new Date();
            info.setMsgId(msgId);
            info.setCreateTime(now);
            Date sendTime = new Date();
            info.setSendTime(sendTime);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            info.setCreateDate(dateFormat.format(now));
            this.msgCpSendRecordRepository.save(info);
        }
        return flag;
    }
}

