/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.cp.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.msg.common.model.ChannelsVo;
import com.jxdinfo.hussar.msg.constant.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.constant.utils.Strings;
import com.jxdinfo.hussar.msg.cp.config.mongodb.repository.MsgCpSendRecordRepository;
import com.jxdinfo.hussar.msg.cp.dto.CpChannelSendStatisticsVo;
import com.jxdinfo.hussar.msg.cp.dto.CpSendRecordPageDto;
import com.jxdinfo.hussar.msg.cp.mongodb.document.MsgCpSendRecord;
import com.jxdinfo.hussar.msg.cp.service.CpSendRecordService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class CpSendRecordServiceImpl
implements CpSendRecordService {
    private static final Logger logger = LoggerFactory.getLogger(CpSendRecordServiceImpl.class);
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private MsgCpSendRecordRepository msgCpSendRecordRepository;

    public IPage<MsgCpSendRecord> listPage(Page pageable, CpSendRecordPageDto pageDto) {
        Query query = new Query();
        Criteria criteria = new Criteria();
        if (pageDto.getBeginTime() != null && pageDto.getEndTime() != null) {
            Criteria fromTime = Criteria.where((String)"createTime").gt((Object)pageDto.getBeginTime());
            Criteria toTime = Criteria.where((String)"createTime").lt((Object)pageDto.getEndTime());
            criteria.andOperator(new Criteria[]{fromTime, toTime});
        }
        if (pageDto.getToUser() != null) {
            criteria.and("toUser").is((Object)pageDto.getToUser());
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getAppName())) {
            criteria.and("appName").regex(Strings.format("%s%s%s", ".*", pageDto.getAppName(), ".*"));
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getChannelName())) {
            criteria.orOperator(new Criteria[]{Criteria.where((String)"channelName").regex(Strings.format("%s%s%s", ".*", pageDto.getChannelName(), ".*")), Criteria.where((String)"channelNo").regex(Strings.format("%s%s%s", ".*", pageDto.getChannelName(), ".*"))});
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getSceneCode())) {
            criteria.and("sceneCode").regex(Strings.format("%s%s%s", ".*", pageDto.getSceneCode(), ".*"));
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getSceneName())) {
            criteria.and("sceneName").regex(Strings.format("%s%s%s", ".*", pageDto.getSceneName(), ".*"));
        }
        if (pageDto.getStatus() != null) {
            criteria.and("status").is((Object)pageDto.getStatus());
        }
        if (pageDto.getContent() != null) {
            String reges = Strings.format("%s%s%s", "^.*", pageDto.getContent().trim(), ".*$");
            Pattern pattern = Pattern.compile(reges, 2);
            criteria.and("content").regex(pattern);
        }
        if (pageDto.getCorpName() != null) {
            criteria.and("corpName").regex(Strings.format("%s%s%s", ".*", pageDto.getCorpName(), ".*"));
        }
        if (pageDto.getAgentName() != null) {
            criteria.and("agentName").regex(Strings.format("%s%s%s", ".*", pageDto.getAgentName(), ".*"));
        }
        query.addCriteria((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"createTime")}));
        long total = this.mongoTemplate.count(query, MsgCpSendRecord.class);
        query.skip((pageable.getCurrent() - 1L) * pageable.getSize());
        query.limit((int)pageable.getSize());
        List list = this.mongoTemplate.find(query, MsgCpSendRecord.class);
        Page page = new Page();
        page.setCurrent(pageable.getCurrent());
        page.setSize(pageable.getSize());
        page.setTotal(total);
        page.setRecords(list);
        return page;
    }

    public MsgCpSendRecord findById(String id) {
        Optional entity = this.msgCpSendRecordRepository.findById(id);
        return entity.orElse(null);
    }

    public List<CpChannelSendStatisticsVo> sendStatistics(CpSendRecordPageDto pageDto) {
        Criteria criteria = new Criteria();
        if (pageDto.getBeginTime() != null && pageDto.getEndTime() != null) {
            Criteria fromTime = Criteria.where((String)"createTime").gt((Object)pageDto.getBeginTime());
            Criteria toTime = Criteria.where((String)"createTime").lt((Object)pageDto.getEndTime());
            criteria.andOperator(new Criteria[]{fromTime, toTime});
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getChannelNo())) {
            criteria.and("channelNo").is((Object)pageDto.getChannelNo());
        }
        Aggregation agg = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{"channelNo", "createDate", "status", "channelName"}).count().as("count")});
        AggregationResults aggregate = this.mongoTemplate.aggregate(agg, MsgCpSendRecord.class, SendRecordAgg.class);
        List mappedResults = aggregate.getMappedResults();
        Map<String, List<SendRecordAgg>> listMap = mappedResults.parallelStream().collect(Collectors.groupingBy(SendRecordAgg::getChannelNo));
        List createDateList = mappedResults.parallelStream().map(SendRecordAgg::getCreateDate).distinct().sorted().collect(Collectors.toList());
        ArrayList<CpChannelSendStatisticsVo> result = new ArrayList<CpChannelSendStatisticsVo>();
        listMap.forEach((channelNo, aggs) -> {
            CpChannelSendStatisticsVo statisticsVo = new CpChannelSendStatisticsVo();
            statisticsVo.setChannelNo(channelNo);
            statisticsVo.setChannelName(HussarUtils.isNotEmpty((Object)aggs) ? ((SendRecordAgg)aggs.get(0)).getChannelName() : null);
            statisticsVo.setCreateDate(createDateList);
            ArrayList aggVos = new ArrayList();
            Map<String, Map<Integer, List<SendRecordAgg>>> collect = aggs.parallelStream().collect(Collectors.groupingBy(SendRecordAgg::getCreateDate, Collectors.groupingBy(SendRecordAgg::getStatus)));
            collect.forEach((createTime, aggs1) -> {
                CpChannelSendStatisticsVo.CpChannelSendStatisticAgg aggVo = new CpChannelSendStatisticsVo.CpChannelSendStatisticAgg();
                aggVo.setSendDate(createTime);
                aggs1.forEach((status, aggs2) -> {
                    if (status.equals(SendStatusEnum.SUCCESS.getCode())) {
                        aggVo.setSuccessCount(((SendRecordAgg)aggs2.get(0)).count);
                    } else if (status.equals(SendStatusEnum.FAIL.getCode())) {
                        aggVo.setFailCount(((SendRecordAgg)aggs2.get(0)).count);
                    } else if (status.equals(SendStatusEnum.SENDING.getCode())) {
                        aggVo.setWillCount(((SendRecordAgg)aggs2.get(0)).count);
                    }
                });
                aggVos.add(aggVo);
            });
            statisticsVo.setAggs(aggVos);
            result.add(statisticsVo);
        });
        return result;
    }

    public List<ChannelsVo> getAllChannels() {
        Aggregation agg = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.group((String[])new String[]{"channelNo", "channelName"})});
        return this.mongoTemplate.aggregate(agg, MsgCpSendRecord.class, ChannelsVo.class).getMappedResults();
    }

    public static class SendRecordAgg {
        private String channelNo;
        private String channelName;
        private String createDate;
        private Integer status;
        private Long count;

        public String getChannelNo() {
            return this.channelNo;
        }

        public String getChannelName() {
            return this.channelName;
        }

        public void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        public void setChannelNo(String channelNo) {
            this.channelNo = channelNo;
        }

        public String getCreateDate() {
            return this.createDate;
        }

        public void setCreateDate(String createDate) {
            this.createDate = createDate;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public Long getCount() {
            return this.count;
        }

        public void setCount(Long count) {
            this.count = count;
        }
    }
}

