/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.cp.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.HussarBaseEntity;
import com.jxdinfo.hussar.msg.app.service.AppSceneConfigService;
import com.jxdinfo.hussar.msg.constant.enums.BizCodeEnum;
import com.jxdinfo.hussar.msg.constant.enums.OpenStatusEnum;
import com.jxdinfo.hussar.msg.constant.utils.BizCodeUtils;
import com.jxdinfo.hussar.msg.cp.dao.MsgCpChannelMapper;
import com.jxdinfo.hussar.msg.cp.dto.CpChannelCreateDto;
import com.jxdinfo.hussar.msg.cp.dto.CpChannelPageDto;
import com.jxdinfo.hussar.msg.cp.dto.CpChannelQueryVo;
import com.jxdinfo.hussar.msg.cp.dto.CpChannelUpdateDto;
import com.jxdinfo.hussar.msg.cp.model.MsgCpChannel;
import com.jxdinfo.hussar.msg.cp.service.CpChannelService;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class CpChannelServiceImpl
extends HussarServiceImpl<MsgCpChannelMapper, MsgCpChannel>
implements CpChannelService {
    @Autowired
    private AppSceneConfigService appSceneConfigService;

    public IPage<MsgCpChannel> listPage(Page page, CpChannelPageDto pageDto) {
        if (StringUtils.isNotEmpty((CharSequence)pageDto.getChannelName())) {
            pageDto.setChannelName(pageDto.getChannelName().trim());
        }
        if (StringUtils.isNotEmpty((CharSequence)pageDto.getChannelNo())) {
            pageDto.setChannelNo(pageDto.getChannelNo().trim());
        }
        if (StringUtils.isNotEmpty((CharSequence)pageDto.getCorpName())) {
            pageDto.setCorpName(pageDto.getCorpName().trim());
        }
        if (StringUtils.isNotEmpty((CharSequence)pageDto.getAgentName())) {
            pageDto.setAgentName(pageDto.getAgentName().trim());
        }
        IPage<MsgCpChannel> pageList = ((MsgCpChannelMapper)this.baseMapper).queryPage(page, pageDto);
        return pageList;
    }

    public boolean save(CpChannelCreateDto createDto) {
        MsgCpChannel entity = new MsgCpChannel();
        BeanUtils.copyProperties((Object)createDto, (Object)entity);
        Long id = IdWorker.getId((Object)entity);
        entity.setId(id);
        entity.setChannelNo(BizCodeUtils.generalBizCode(BizCodeEnum.CP_CHANNEL));
        if (HussarUtils.equals((Object)"1", (Object)this.checkChannelUnique(entity))) {
            throw new HussarException("\u901a\u9053\u540d\u79f0'" + entity.getChannelName() + "'\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539\uff01");
        }
        return super.save((BaseEntity)entity);
    }

    public boolean update(CpChannelUpdateDto updateDto) {
        MsgCpChannel entity = new MsgCpChannel();
        BeanUtils.copyProperties((Object)updateDto, (Object)entity);
        QueryWrapper qw = new QueryWrapper();
        qw.lambda().eq(MsgCpChannel::getId, (Object)updateDto.getId());
        MsgCpChannel info = (MsgCpChannel)((MsgCpChannelMapper)this.baseMapper).selectOne((Wrapper)qw);
        if (HussarUtils.isEmpty((Object)info)) {
            throw new HussarException("\u8be5\u901a\u9053\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u8fdb\u884c\u4fee\u6539\uff01");
        }
        return super.updateById((BaseEntity)entity);
    }

    public boolean delete(Long id) {
        MsgCpChannel msgCpChannel = (MsgCpChannel)((MsgCpChannelMapper)this.baseMapper).selectById(id);
        if (this.appSceneConfigService.isExistScene(msgCpChannel.getChannelNo())) {
            throw new HussarException("\u5b58\u5728\u76f8\u5173\u573a\u666f\uff0c\u8bf7\u5148\u5220\u9664\u573a\u666f\uff01");
        }
        QueryWrapper qw = new QueryWrapper();
        qw.lambda().eq(MsgCpChannel::getId, (Object)id);
        MsgCpChannel info = (MsgCpChannel)((MsgCpChannelMapper)this.baseMapper).selectOne((Wrapper)qw);
        if (HussarUtils.isEmpty((Object)info)) {
            throw new HussarException("\u8be5\u901a\u9053\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u8fdb\u884c\u5220\u9664\uff01");
        }
        return super.removeById((Serializable)id);
    }

    public boolean deleteChannelByIds(Long[] ids) {
        if (this.appSceneConfigService.isExistSceneInBatch(super.listByIds(Arrays.asList(ids)).stream().map(MsgCpChannel::getChannelNo).collect(Collectors.toList()))) {
            throw new HussarException("\u5b58\u5728\u76f8\u5173\u573a\u666f\uff0c\u8bf7\u5148\u5220\u9664\u573a\u666f\uff01");
        }
        return super.removeByIds(Arrays.asList(ids));
    }

    private CpChannelQueryVo entity2QueryVo(MsgCpChannel entity) {
        CpChannelQueryVo vo = new CpChannelQueryVo();
        BeanUtils.copyProperties((Object)entity, (Object)vo);
        return vo;
    }

    public List<CpChannelQueryVo> getChannelList() {
        QueryWrapper qw = new QueryWrapper();
        qw.lambda().eq(MsgCpChannel::getStatus, (Object)OpenStatusEnum.ENABLE.getCode());
        qw.lambda().orderByDesc(HussarBaseEntity::getCreateTime);
        List list = ((MsgCpChannelMapper)this.baseMapper).selectList((Wrapper)qw);
        return list.stream().map(this::entity2QueryVo).collect(Collectors.toList());
    }

    public MsgCpChannel selectChannel(Long id, String channelNo) {
        MsgCpChannel channel;
        QueryWrapper qw = new QueryWrapper();
        if (id != null) {
            qw.lambda().eq(MsgCpChannel::getId, (Object)id);
        }
        if ((channel = (MsgCpChannel)((MsgCpChannelMapper)this.baseMapper).selectOne((Wrapper)qw)) == null) {
            throw new HussarException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u901a\u9053");
        }
        if (channel.getStatus() == null || !channel.getStatus().equals(OpenStatusEnum.ENABLE.getCode())) {
            throw new HussarException("\u901a\u9053\u672a\u542f\u7528");
        }
        return channel;
    }

    private String checkChannelUnique(MsgCpChannel entity) {
        Long id = HussarUtils.isEmpty((Object)entity.getId()) ? -1L : entity.getId();
        QueryWrapper qw = new QueryWrapper();
        qw.lambda().eq(MsgCpChannel::getChannelName, (Object)entity.getChannelName());
        MsgCpChannel info = (MsgCpChannel)this.getOne((Wrapper)qw, false);
        if (HussarUtils.isNotEmpty((Object)info) && HussarUtils.equals((Object)info.getId(), (Object)id)) {
            return "1";
        }
        return "0";
    }
}

