/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.cp.config.mq;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.msg.app.dto.ConfigJsonData;
import com.jxdinfo.hussar.msg.app.model.AppAccess;
import com.jxdinfo.hussar.msg.app.service.AppAccessService;
import com.jxdinfo.hussar.msg.app.service.AppSceneConfigService;
import com.jxdinfo.hussar.msg.constant.enums.OpenStatusEnum;
import com.jxdinfo.hussar.msg.constant.enums.QueueEnum;
import com.jxdinfo.hussar.msg.constant.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.constant.enums.ServiceTypeEnum;
import com.jxdinfo.hussar.msg.cp.dto.CpSendMsgCreateDto;
import com.jxdinfo.hussar.msg.cp.model.MsgCpChannel;
import com.jxdinfo.hussar.msg.cp.mongodb.document.MsgCpSendRecord;
import com.jxdinfo.hussar.msg.cp.service.CpChannelService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CpRabbitMqSendService {
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private CpChannelService cpChannelService;
    @Autowired
    private AppAccessService appAccessService;
    @Autowired
    private AppSceneConfigService appSceneConfigService;

    public boolean sendCpMsgMq(CpSendMsgCreateDto createDto) {
        AppAccess appAccess = this.appAccessService.getAppAccess(createDto.getAppId(), createDto.getAppSecret());
        ConfigJsonData configJsonData = this.appSceneConfigService.getConfigData(createDto.getSceneCode(), appAccess.getId().toString(), ServiceTypeEnum.CP.getCode());
        createDto.setChannelNo(configJsonData.getChannelNo());
        MsgCpChannel channel = this.getCpChannel(createDto.getChannelId(), createDto.getChannelNo());
        MsgCpSendRecord record = new MsgCpSendRecord();
        record.setChannelId(channel.getId().toString());
        record.setChannelNo(channel.getChannelNo());
        record.setChannelName(channel.getChannelName());
        record.setAgentSecret(channel.getAgentSecret());
        record.setAgentName(channel.getAgentName());
        record.setAgentId(channel.getAgentId());
        record.setCorpId(channel.getCorpID());
        record.setCorpName(channel.getCorpName());
        record.setToUser(createDto.getToUser());
        record.setContent(createDto.getData());
        record.setTim(createDto.getTim());
        record.setJobTime(createDto.getJobTime());
        record.setAppId(createDto.getAppId());
        record.setAppName(appAccess.getAppName());
        record.setAppSecret(createDto.getAppSecret());
        record.setStatus(SendStatusEnum.SENDING.getCode());
        record.setSceneCode(createDto.getSceneCode());
        record.setSceneName(configJsonData.getSceneName());
        String s = JSONObject.toJSONString((Object)record);
        Message message = new Message(s.getBytes(), new MessageProperties());
        this.rabbitTemplate.convertAndSend(QueueEnum.QUEUE_MSG_CP.getExchange(), QueueEnum.QUEUE_MSG_CP.getRouteKey(), (Object)message);
        return true;
    }

    private MsgCpChannel getCpChannel(Long channelId, String channelNo) {
        MsgCpChannel channel;
        QueryWrapper qw = new QueryWrapper();
        if (channelId != null) {
            qw.lambda().eq(MsgCpChannel::getId, (Object)channelId);
        }
        if (HussarUtils.isNotEmpty((Object)channelNo)) {
            qw.lambda().eq(MsgCpChannel::getChannelNo, (Object)channelNo);
        }
        if ((channel = (MsgCpChannel)this.cpChannelService.getOne((Wrapper)qw)) == null) {
            throw new HussarException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u901a\u9053");
        }
        if (channel.getStatus() == null || !channel.getStatus().equals(OpenStatusEnum.ENABLE.getCode())) {
            throw new HussarException("\u901a\u9053\u672a\u542f\u7528");
        }
        return channel;
    }
}

