/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.constant.enums;

import com.jxdinfo.hussar.msg.config.UnifiedMessageProperties;
import java.util.EnumSet;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

public enum QueueEnum {
    QUEUE_MSG_SMS("msg.sms.direct", "msg.sms", "msg.sms"),
    QUEUE_MSG_MP("msg.mp.direct", "msg.mp", "msg.mp"),
    QUEUE_MSG_APPIM("msg.appim.direct", "msg.appim", "msg.appim"),
    QUEUE_MSG_MAIL("msg.mail.direct", "msg.mail", "msg.mail"),
    QUEUE_MSG_APPPUSH("msg.app.direct", "msg.app", "msg.app"),
    QUEUE_MSG_NOTICE("msg.notice.direct", "msg.notice", "msg.notice"),
    QUEUE_MSG_CP("msg.cp.direct", "msg.cp", "msg.cp"),
    QUEUE_MSG_DINGTALK("msg.dingtalk.direct", "msg.dingtalk", "msg.dingtalk");

    private String exchange;
    private String name;
    private String routeKey;
    private String queuePrefix;
    private UnifiedMessageProperties unifiedMessageProperties;

    private QueueEnum(String exchange, String name, String routeKey) {
        this.exchange = exchange;
        this.name = name;
        this.routeKey = routeKey;
    }

    public void setUnifiedMessageProperties(UnifiedMessageProperties unifiedMessageProperties) {
        this.unifiedMessageProperties = unifiedMessageProperties;
        this.queuePrefix = this.unifiedMessageProperties.getQueuePrefix();
    }

    public String getExchange() {
        return this.queuePrefix + this.exchange;
    }

    public void setExchange(String exchange) {
        this.exchange = exchange;
    }

    public String getName() {
        return this.queuePrefix + this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRouteKey() {
        return this.queuePrefix + this.routeKey;
    }

    public void setRouteKey(String routeKey) {
        this.routeKey = routeKey;
    }

    @Component
    public static class PropertiesServiceInjector {
        @Autowired
        protected UnifiedMessageProperties unifiedMessageProperties;

        @PostConstruct
        public void postConstruct() {
            for (QueueEnum queueEnum : EnumSet.allOf(QueueEnum.class)) {
                queueEnum.setUnifiedMessageProperties(this.unifiedMessageProperties);
            }
        }
    }
}

