/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.apppush.thrid.service.impl;

import com.jxdinfo.hussar.msg.apppush.mongodb.document.AppPushSendRecord;
import com.jxdinfo.hussar.msg.apppush.third.service.AppPushService;
import com.jxdinfo.hussar.msg.constant.enums.ActionTypeEnum;
import com.jxdinfo.hussar.msg.constant.enums.AudienceTypeEnum;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.push.model.Response;
import com.jxdinfo.push.model.message.Action;
import com.jxdinfo.push.model.message.ApnsMessage;
import com.jxdinfo.push.model.message.HwMessage;
import com.jxdinfo.push.model.message.Message;
import com.jxdinfo.push.service.PushService;
import java.util.Arrays;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class AppPushServiceImpl
implements AppPushService {
    public Response<Boolean> appSendMsg(AppPushSendRecord appPushSendRecord) {
        PushService push = PushService.builder().appId(appPushSendRecord.getAppId()).accessId(appPushSendRecord.getAssessId()).secretKey(appPushSendRecord.getSecretKey()).audienceType(appPushSendRecord.getAudienceType()).platform(appPushSendRecord.getPlatform()).environment(Integer.valueOf(1)).messageType(Integer.valueOf(0)).build();
        if (appPushSendRecord.getAudienceType().equals(AudienceTypeEnum.TOKEN.getCode())) {
            push.setTokenList(Arrays.asList(appPushSendRecord.getTokenList().split(",")));
        }
        Message message = this.createMessage(appPushSendRecord);
        Response response = push.sendMessage(message);
        return response;
    }

    private Message createMessage(AppPushSendRecord appPushSendRecord) {
        if (appPushSendRecord.getActionType() == null) {
            appPushSendRecord.setActionType(Integer.valueOf(0));
        }
        Action action = new Action();
        action.setType(appPushSendRecord.getActionType());
        if (appPushSendRecord.getActionType().equals(ActionTypeEnum.OPEN_ACTIVITY.getCode())) {
            action.setActivity(appPushSendRecord.getActionAddress());
        } else if (appPushSendRecord.getActionType().equals(ActionTypeEnum.OPEN_BROWSER.getCode())) {
            action.setUrl(appPushSendRecord.getActionAddress());
        } else if (appPushSendRecord.getActionType().equals(ActionTypeEnum.OPEN_INTENT.getCode())) {
            action.setIntent(appPushSendRecord.getActionAddress());
        }
        HwMessage hwMessage = new HwMessage();
        hwMessage.setAutoCancel(Boolean.valueOf(true));
        ApnsMessage apnsMessage = new ApnsMessage();
        apnsMessage.setContentAvailable(1);
        Message message = Message.builder().title(appPushSendRecord.getTitle()).content(appPushSendRecord.getContent()).badge(appPushSendRecord.getAngleMark()).vibrate(Integer.valueOf(1)).expireTime(Integer.valueOf(1000)).lights(Integer.valueOf(1)).ring(Integer.valueOf(1)).action(action).hwMessage(hwMessage).apnsMessage(apnsMessage).build();
        return message;
    }
}

