/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.apppush.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.msg.apppush.config.mongodb.repository.AppPushSendRecordRepository;
import com.jxdinfo.hussar.msg.apppush.dto.AppPushChannelSendStatisticsVo;
import com.jxdinfo.hussar.msg.apppush.dto.AppPushSendRecordCreateDto;
import com.jxdinfo.hussar.msg.apppush.dto.AppPushSendRecordPageDto;
import com.jxdinfo.hussar.msg.apppush.dto.AppPushSendRecordQueryDto;
import com.jxdinfo.hussar.msg.apppush.dto.AppPushSendRecordQueryVo;
import com.jxdinfo.hussar.msg.apppush.model.AppPushChannel;
import com.jxdinfo.hussar.msg.apppush.mongodb.document.AppPushSendRecord;
import com.jxdinfo.hussar.msg.apppush.service.AppPushChannelService;
import com.jxdinfo.hussar.msg.apppush.service.AppPushSendRecordService;
import com.jxdinfo.hussar.msg.apppush.third.service.AppPushService;
import com.jxdinfo.hussar.msg.common.model.ChannelsVo;
import com.jxdinfo.hussar.msg.constant.enums.AppEnum;
import com.jxdinfo.hussar.msg.constant.enums.AudienceTypeEnum;
import com.jxdinfo.hussar.msg.constant.enums.OpenStatusEnum;
import com.jxdinfo.hussar.msg.constant.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.constant.utils.IdUtil;
import com.jxdinfo.hussar.msg.constant.utils.Strings;
import com.jxdinfo.hussar.msg.job.enums.MsgJobEnum;
import com.jxdinfo.hussar.msg.job.service.MsgJobService;
import com.jxdinfo.hussar.platform.core.utils.DateUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.push.model.Response;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class AppPushSendRecordServiceImpl
implements AppPushSendRecordService {
    private static final Logger logger = LoggerFactory.getLogger(AppPushSendRecordServiceImpl.class);
    @Autowired
    private AppPushChannelService msgAppChannelService;
    @Autowired
    private AppPushSendRecordRepository msgAppInfoRepository;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private AppPushService appPushService;
    @Autowired
    private MsgJobService msgJobService;

    public IPage<AppPushSendRecord> listPage(Page pageable, AppPushSendRecordPageDto pageDto) {
        Query query = new Query();
        Criteria criteria = new Criteria();
        if (pageDto.getBeginTime() != null && pageDto.getEndTime() != null) {
            Criteria fromTime = Criteria.where((String)"createTime").gt((Object)pageDto.getBeginTime());
            Criteria toTime = Criteria.where((String)"createTime").lt((Object)pageDto.getEndTime());
            criteria.andOperator(new Criteria[]{fromTime, toTime});
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getMsgAppName())) {
            criteria.and("msgAppName").regex(Strings.format("%s%s%s", ".*", pageDto.getMsgAppName(), ".*"));
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getChannelName())) {
            criteria.and("channelName").regex(Strings.format("%s%s%s", ".*", pageDto.getChannelName(), ".*"));
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getChannelNo())) {
            criteria.and("channelNo").regex(Strings.format("%s%s%s", ".*", pageDto.getChannelNo(), ".*"));
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getTitle())) {
            criteria.and("title").regex(Strings.format("%s%s%s", ".*", pageDto.getTitle(), ".*"));
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getContent())) {
            criteria.and("content").regex(Strings.format("%s%s%s", ".*", pageDto.getContent(), ".*"));
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getSceneCode())) {
            criteria.and("sceneCode").regex(Strings.format("%s%s%s", ".*", pageDto.getSceneCode(), ".*"));
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getSceneName())) {
            criteria.and("sceneName").regex(Strings.format("%s%s%s", ".*", pageDto.getSceneName(), ".*"));
        }
        if (pageDto.getStatus() != null) {
            criteria.and("status").is((Object)pageDto.getStatus());
        }
        query.addCriteria((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"createTime")}));
        long total = this.mongoTemplate.count(query, AppPushSendRecord.class);
        query.skip((pageable.getCurrent() - 1L) * pageable.getSize());
        query.limit((int)pageable.getSize());
        List list = this.mongoTemplate.find(query, AppPushSendRecord.class);
        Page page = new Page();
        page.setCurrent(pageable.getCurrent());
        page.setSize(pageable.getSize());
        page.setTotal(total);
        page.setRecords(list);
        return page;
    }

    public AppPushSendRecordQueryVo findById(String id) {
        Optional entity = this.msgAppInfoRepository.findById(id);
        return entity.map(this::entity2QueryVo).orElse(null);
    }

    public List<ChannelsVo> getAllChannels() {
        Aggregation agg = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.group((String[])new String[]{"channelNo", "channelName"})});
        return this.mongoTemplate.aggregate(agg, AppPushSendRecord.class, ChannelsVo.class).getMappedResults();
    }

    public List<AppPushChannelSendStatisticsVo> sendStatistics(AppPushSendRecordQueryDto queryDto) {
        Criteria criteria = new Criteria();
        if (queryDto.getBeginTime() != null && queryDto.getEndTime() != null) {
            Criteria fromTime = Criteria.where((String)"createTime").gt((Object)queryDto.getBeginTime());
            Criteria toTime = Criteria.where((String)"createTime").lt((Object)queryDto.getEndTime());
            criteria.andOperator(new Criteria[]{fromTime, toTime});
        }
        if (HussarUtils.isNotEmpty((Object)queryDto.getChannelNo())) {
            criteria.and("channelNo").is((Object)queryDto.getChannelNo());
        } else {
            criteria.and("channelNo").ne((Object)"").ne(null);
        }
        Aggregation agg = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{"channelNo", "createTime", "status", "channelName"}).count().as("count")});
        AggregationResults aggregate = this.mongoTemplate.aggregate(agg, AppPushSendRecord.class, SendRecordAgg.class);
        List mappedResults = aggregate.getMappedResults();
        Map<String, List<SendRecordAgg>> listMap = mappedResults.parallelStream().collect(Collectors.groupingBy(SendRecordAgg::getChannelNo));
        LinkedList<String> createDateList = new LinkedList<String>();
        List dates = mappedResults.parallelStream().map(SendRecordAgg::getCreateTime).distinct().sorted().collect(Collectors.toList());
        for (Date date : dates) {
            createDateList.add(DateUtil.format((Date)date, (String)"yyyy-MM-dd"));
        }
        ArrayList<AppPushChannelSendStatisticsVo> result = new ArrayList<AppPushChannelSendStatisticsVo>();
        listMap.forEach((channelNo, aggs) -> {
            for (SendRecordAgg sendRecordAgg : aggs) {
                sendRecordAgg.setCreateDate(DateUtil.format((Date)sendRecordAgg.getCreateTime(), (String)"yyyy-MM-dd"));
            }
            AppPushChannelSendStatisticsVo statisticsVo = new AppPushChannelSendStatisticsVo();
            statisticsVo.setChannelNo(channelNo);
            statisticsVo.setChannelName(HussarUtils.isNotEmpty((Object)aggs) ? ((SendRecordAgg)aggs.get(0)).channelName : null);
            statisticsVo.setCreateDate(createDateList.stream().distinct().collect(Collectors.toList()));
            aggs.parallelStream().collect(Collectors.groupingBy(SendRecordAgg::getChannelNo));
            ArrayList aggVos = new ArrayList();
            Map<String, Map<Integer, List<SendRecordAgg>>> collect = aggs.parallelStream().collect(Collectors.groupingBy(SendRecordAgg::getCreateDate, Collectors.groupingBy(SendRecordAgg::getStatus)));
            collect.forEach((createDate, aggs1) -> {
                AppPushChannelSendStatisticsVo.AppPushChannelSendStatisticAgg aggVo = new AppPushChannelSendStatisticsVo.AppPushChannelSendStatisticAgg();
                aggVo.setSendDate(createDate);
                aggs1.forEach((status, aggs2) -> {
                    Long num = Long.parseLong("0");
                    for (SendRecordAgg sendRecordAgg : aggs2) {
                        num = num + sendRecordAgg.getCount();
                    }
                    if (status.equals(SendStatusEnum.SUCCESS.getCode())) {
                        aggVo.setSuccessCount(num);
                    } else if (status.equals(SendStatusEnum.FAIL.getCode())) {
                        aggVo.setFailCount(num);
                    } else if (status.equals(SendStatusEnum.SENDING.getCode())) {
                        aggVo.setWillCount(num);
                    }
                });
                aggVos.add(aggVo);
            });
            statisticsVo.setAggs(aggVos);
            result.add(statisticsVo);
        });
        return result;
    }

    public boolean sendPushMsg(AppPushSendRecord appPushSendRecord) {
        boolean flag = true;
        if (appPushSendRecord.getTim() != null && appPushSendRecord.getTim().booleanValue()) {
            String id = IdUtil.fastSimpleUuid();
            appPushSendRecord.setId(id);
            this.msgJobService.saveMsgJob(appPushSendRecord.getJobTime(), JSONObject.toJSONString((Object)appPushSendRecord), MsgJobEnum.MSG_APPPUSH);
            appPushSendRecord.setStatus(SendStatusEnum.SENDING.getCode());
            Date now = new Date();
            appPushSendRecord.setSendTime(appPushSendRecord.getJobTime());
            appPushSendRecord.setCreateTime(now);
            appPushSendRecord.setCreateDate(DateUtil.format((Date)now, (String)"yyyy-MM-dd"));
            this.msgAppInfoRepository.save(appPushSendRecord);
        } else if (appPushSendRecord.getAudienceType().equals(AudienceTypeEnum.ALL.getCode())) {
            try {
                Response response = this.appPushService.appSendMsg(appPushSendRecord);
                if (response.getSuccess().booleanValue()) {
                    appPushSendRecord.setStatus(SendStatusEnum.SUCCESS.getCode());
                } else {
                    flag = false;
                    appPushSendRecord.setStatus(SendStatusEnum.FAIL.getCode());
                    appPushSendRecord.setErrMsg(String.format("code:%s,mag:%s", response.getRespCode(), response.getMsg()));
                }
            }
            catch (Exception e) {
                logger.error("app\u63a8\u9001\u53d1\u9001\u6d88\u606f\u5f02\u5e38\uff1a", (Throwable)e);
                appPushSendRecord.setStatus(SendStatusEnum.FAIL.getCode());
                flag = false;
                appPushSendRecord.setErrMsg(e.getMessage());
            }
            Date now = new Date();
            String id = IdUtil.fastSimpleUuid();
            appPushSendRecord.setSendTime(now);
            appPushSendRecord.setCreateTime(now);
            appPushSendRecord.setId(id);
            appPushSendRecord.setCreateDate(DateUtil.format((Date)now, (String)"yyyy-MM-dd"));
            this.msgAppInfoRepository.save(appPushSendRecord);
        } else {
            for (String token : appPushSendRecord.getTokenList().split(",")) {
                appPushSendRecord.setTokenList(token);
                try {
                    Response response = this.appPushService.appSendMsg(appPushSendRecord);
                    if (response.getSuccess().booleanValue()) {
                        appPushSendRecord.setStatus(SendStatusEnum.SUCCESS.getCode());
                    } else {
                        flag = false;
                        appPushSendRecord.setStatus(SendStatusEnum.FAIL.getCode());
                        appPushSendRecord.setErrMsg(String.format("code:%s,mag:%s", response.getRespCode(), response.getMsg()));
                    }
                }
                catch (Exception e) {
                    logger.error("app\u63a8\u9001\u53d1\u9001\u6d88\u606f\u5f02\u5e38\uff1a", (Throwable)e);
                    appPushSendRecord.setStatus(SendStatusEnum.FAIL.getCode());
                    flag = false;
                    appPushSendRecord.setErrMsg(e.getMessage());
                }
                Date now = new Date();
                String id = IdUtil.fastSimpleUuid();
                appPushSendRecord.setSendTime(now);
                appPushSendRecord.setCreateTime(now);
                appPushSendRecord.setId(id);
                appPushSendRecord.setCreateDate(DateUtil.format((Date)now, (String)"yyyy-MM-dd"));
                this.msgAppInfoRepository.save(appPushSendRecord);
            }
        }
        return flag;
    }

    public boolean testSend(AppPushSendRecordCreateDto createDto) {
        AppPushChannel appPushChannel = this.getAppChannel(createDto.getChannelId(), createDto.getChannelNo());
        AppPushSendRecord appPushSendRecord = new AppPushSendRecord();
        appPushSendRecord.setChannelId(createDto.getChannelId());
        appPushSendRecord.setChannelNo(appPushChannel.getChannelNo());
        appPushSendRecord.setChannelName(appPushChannel.getChannelName());
        appPushSendRecord.setTitle(createDto.getTitle());
        appPushSendRecord.setAudienceType(createDto.getAudienceType());
        appPushSendRecord.setPlatform(createDto.getPlatform());
        appPushSendRecord.setContent(createDto.getContent());
        appPushSendRecord.setAngleMark(createDto.getAngleMark());
        appPushSendRecord.setActionType(createDto.getActionType());
        appPushSendRecord.setActivity(createDto.getActivity());
        appPushSendRecord.setActionAddress(createDto.getActionAddress());
        appPushSendRecord.setUrl(createDto.getUrl());
        appPushSendRecord.setIntent(createDto.getIntent());
        if (createDto.getTokenList() != null && createDto.getTokenList().size() > 0) {
            appPushSendRecord.setTokenList(String.join((CharSequence)",", createDto.getTokenList()));
        }
        appPushSendRecord.setAppId(appPushChannel.getAppId());
        appPushSendRecord.setAssessId(appPushChannel.getAssessId());
        appPushSendRecord.setSecretKey(appPushChannel.getSecretKey());
        appPushSendRecord.setTim(createDto.getTim());
        appPushSendRecord.setJobTime(createDto.getJobTime());
        appPushSendRecord.setMsgAppId(AppEnum.TEST.getAppId());
        appPushSendRecord.setMsgAppName(AppEnum.TEST.getAppName());
        appPushSendRecord.setMsgAppSecret(AppEnum.TEST.getAppSecret());
        appPushSendRecord.setSceneName(AppEnum.TEST.getSceneName());
        appPushSendRecord.setSceneCode(AppEnum.TEST.getSceneCode());
        return this.sendPushMsg(appPushSendRecord);
    }

    public boolean jobMsg(AppPushSendRecord appPushSendRecord) {
        Optional optional = this.msgAppInfoRepository.findById(appPushSendRecord.getId());
        AppPushSendRecord entity = optional.orElse(new AppPushSendRecord());
        if (HussarUtils.isNotEmpty((Object)entity.getId())) {
            try {
                Response response = this.appPushService.appSendMsg(entity);
                if (response.getSuccess().booleanValue()) {
                    entity.setStatus(SendStatusEnum.SUCCESS.getCode());
                } else {
                    entity.setErrMsg(String.format("code:%s,mag:%s", response.getRespCode(), response.getMsg()));
                    entity.setStatus(SendStatusEnum.FAIL.getCode());
                }
            }
            catch (Exception e) {
                logger.error("app\u63a8\u9001\u53d1\u9001\u5b9a\u65f6\u6d88\u606f\u5f02\u5e38\uff1a", (Throwable)e);
                entity.setErrMsg(e.getMessage());
                entity.setStatus(SendStatusEnum.FAIL.getCode());
            }
            entity.setSendTime(new Date());
            this.msgAppInfoRepository.save(entity);
        }
        return true;
    }

    private AppPushChannel getAppChannel(Long channelId, String channelNo) {
        AppPushChannel channel;
        QueryWrapper qw = new QueryWrapper();
        if (channelId != null) {
            qw.lambda().eq(AppPushChannel::getId, (Object)channelId);
        }
        if (HussarUtils.isNotEmpty((Object)channelNo)) {
            qw.lambda().eq(AppPushChannel::getChannelNo, (Object)channelNo);
        }
        if ((channel = (AppPushChannel)this.msgAppChannelService.getOne((Wrapper)qw)) == null) {
            throw new HussarException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u901a\u9053");
        }
        if (channel.getStatus() == null || !channel.getStatus().equals(OpenStatusEnum.ENABLE.getCode())) {
            throw new HussarException("\u901a\u9053\u672a\u542f\u7528");
        }
        return channel;
    }

    private AppPushSendRecordQueryVo entity2QueryVo(AppPushSendRecord entity) {
        AppPushSendRecordQueryVo vo = new AppPushSendRecordQueryVo();
        BeanUtils.copyProperties((Object)entity, (Object)vo);
        return vo;
    }

    public static class SendRecordAgg {
        private String channelNo;
        private String channelName;
        private String createDate;
        private Date createTime;
        private Integer status;
        private Long count;

        public Date getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(Date createTime) {
            this.createTime = createTime;
        }

        public String getChannelNo() {
            return this.channelNo;
        }

        public void setChannelNo(String channelNo) {
            this.channelNo = channelNo;
        }

        public String getCreateDate() {
            return this.createDate;
        }

        public void setCreateDate(String createDate) {
            this.createDate = createDate;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public Long getCount() {
            return this.count;
        }

        public void setCount(Long count) {
            this.count = count;
        }

        public String getChannelName() {
            return this.channelName;
        }

        public void setChannelName(String channelName) {
            this.channelName = channelName;
        }
    }
}

