/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.apppush.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.msg.app.service.AppSceneConfigService;
import com.jxdinfo.hussar.msg.apppush.dao.AppPushChannelMapper;
import com.jxdinfo.hussar.msg.apppush.dto.AppPushChannelCreateDto;
import com.jxdinfo.hussar.msg.apppush.dto.AppPushChannelPageDto;
import com.jxdinfo.hussar.msg.apppush.dto.AppPushChannelQueryVo;
import com.jxdinfo.hussar.msg.apppush.dto.AppPushChannelUpdateDto;
import com.jxdinfo.hussar.msg.apppush.model.AppPushChannel;
import com.jxdinfo.hussar.msg.apppush.service.AppPushChannelService;
import com.jxdinfo.hussar.msg.constant.enums.BizCodeEnum;
import com.jxdinfo.hussar.msg.constant.utils.BizCodeUtils;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class AppPushChannelServiceImpl
extends HussarServiceImpl<AppPushChannelMapper, AppPushChannel>
implements AppPushChannelService {
    @Autowired
    private AppSceneConfigService appSceneConfigService;

    public IPage<AppPushChannel> listPage(Page page, AppPushChannelPageDto pageDto) {
        IPage<AppPushChannel> pageList = ((AppPushChannelMapper)this.baseMapper).queryPage(page, pageDto);
        return pageList;
    }

    public AppPushChannelQueryVo findById(long id) {
        AppPushChannel entity = (AppPushChannel)super.getById((Serializable)Long.valueOf(id));
        return this.entity2QueryVo(entity);
    }

    public boolean save(AppPushChannelCreateDto createDto) {
        AppPushChannel entity = new AppPushChannel();
        BeanUtils.copyProperties((Object)createDto, (Object)entity);
        entity.setChannelNo(BizCodeUtils.generalBizCode(BizCodeEnum.APP_PUSH_CHANNEL));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(AppPushChannel::getChannelName, (Object)entity.getChannelName());
        long count = ((AppPushChannelMapper)this.baseMapper).selectCount((Wrapper)queryWrapper);
        if (count > 0L) {
            throw new HussarException("\u901a\u9053\u540d\u79f0'" + entity.getChannelName() + "'\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539\uff01");
        }
        return super.save((BaseEntity)entity);
    }

    public boolean updateById(AppPushChannelUpdateDto updateDto) {
        AppPushChannel entity = new AppPushChannel();
        BeanUtils.copyProperties((Object)updateDto, (Object)entity);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(AppPushChannel::getChannelName, (Object)entity.getChannelName());
        queryWrapper.lambda().ne(AppPushChannel::getId, (Object)entity.getId());
        long count = ((AppPushChannelMapper)this.baseMapper).selectCount((Wrapper)queryWrapper);
        if (count > 0L) {
            throw new HussarException("\u901a\u9053\u540d\u79f0'" + entity.getChannelName() + "'\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539\uff01");
        }
        return super.updateById((BaseEntity)entity);
    }

    public boolean delete(Long id) {
        if (this.appSceneConfigService.isExistScene(((AppPushChannel)super.getById((Serializable)id)).getChannelNo())) {
            throw new HussarException("\u5b58\u5728\u76f8\u5173\u573a\u666f\uff0c\u8bf7\u5148\u5220\u9664\u573a\u666f\uff01");
        }
        return super.removeById((Serializable)id);
    }

    public boolean deleteChannelByIds(Long[] ids) {
        if (this.appSceneConfigService.isExistSceneInBatch(super.listByIds(Arrays.asList(ids)).stream().map(AppPushChannel::getChannelNo).collect(Collectors.toList()))) {
            throw new HussarException("\u5b58\u5728\u76f8\u5173\u573a\u666f\uff0c\u8bf7\u5148\u5220\u9664\u573a\u666f\uff01");
        }
        return super.removeByIds(Arrays.asList(ids));
    }

    public List<AppPushChannelQueryVo> getChannelList() {
        QueryWrapper qw = new QueryWrapper();
        List list = ((AppPushChannelMapper)this.baseMapper).selectList((Wrapper)qw);
        return list.stream().map(this::entity2QueryVo).collect(Collectors.toList());
    }

    private AppPushChannelQueryVo entity2QueryVo(AppPushChannel entity) {
        AppPushChannelQueryVo vo = new AppPushChannelQueryVo();
        if (entity != null) {
            BeanUtils.copyProperties((Object)entity, (Object)vo);
        }
        return vo;
    }
}

