/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.apppush.config.mq;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.msg.app.dto.ConfigJsonData;
import com.jxdinfo.hussar.msg.app.model.AppAccess;
import com.jxdinfo.hussar.msg.app.service.AppAccessService;
import com.jxdinfo.hussar.msg.app.service.AppSceneConfigService;
import com.jxdinfo.hussar.msg.apppush.dto.AppPushSendRecordCreateDto;
import com.jxdinfo.hussar.msg.apppush.model.AppPushChannel;
import com.jxdinfo.hussar.msg.apppush.mongodb.document.AppPushSendRecord;
import com.jxdinfo.hussar.msg.apppush.service.AppPushChannelService;
import com.jxdinfo.hussar.msg.constant.enums.OpenStatusEnum;
import com.jxdinfo.hussar.msg.constant.enums.QueueEnum;
import com.jxdinfo.hussar.msg.constant.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.constant.enums.ServiceTypeEnum;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppRabbitMqSendService {
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private AppPushChannelService msgAppChannelService;
    @Autowired
    private AppAccessService appAccessService;
    @Autowired
    private AppSceneConfigService appSceneConfigService;

    public boolean sendMsgAppMq(AppPushSendRecordCreateDto createDto) {
        AppAccess appAccess = this.appAccessService.getAppAccess(createDto.getAppId(), createDto.getAppSecret());
        ConfigJsonData configJsonData = this.appSceneConfigService.getConfigData(createDto.getSceneCode(), appAccess.getId().toString(), ServiceTypeEnum.APP_PUSH.getCode());
        AppPushChannel appPushChannel = this.getAppChannel(createDto.getChannelId(), configJsonData.getChannelNo());
        AppPushSendRecord appPushSendRecord = new AppPushSendRecord();
        appPushSendRecord.setChannelId(createDto.getChannelId());
        appPushSendRecord.setChannelNo(createDto.getChannelNo());
        appPushSendRecord.setSceneCode(createDto.getSceneCode());
        appPushSendRecord.setSceneName(configJsonData.getSceneName());
        appPushSendRecord.setChannelName(appPushChannel.getChannelName());
        appPushSendRecord.setTitle(createDto.getTitle());
        appPushSendRecord.setAudienceType(createDto.getAudienceType());
        appPushSendRecord.setPlatform(createDto.getPlatform());
        appPushSendRecord.setContent(createDto.getContent());
        appPushSendRecord.setAngleMark(createDto.getAngleMark());
        appPushSendRecord.setActionType(createDto.getActionType());
        appPushSendRecord.setActivity(createDto.getActivity());
        appPushSendRecord.setActionAddress(createDto.getActionAddress());
        appPushSendRecord.setUrl(createDto.getUrl());
        appPushSendRecord.setIntent(createDto.getIntent());
        if (createDto.getTokenList() != null && createDto.getTokenList().size() > 0) {
            appPushSendRecord.setTokenList(String.join((CharSequence)",", createDto.getTokenList()));
        }
        appPushSendRecord.setAppId(appPushChannel.getAppId());
        appPushSendRecord.setAssessId(appPushChannel.getAssessId());
        appPushSendRecord.setSecretKey(appPushChannel.getSecretKey());
        appPushSendRecord.setTim(createDto.getTim());
        appPushSendRecord.setJobTime(createDto.getJobTime());
        appPushSendRecord.setStatus(SendStatusEnum.SENDING.getCode());
        appPushSendRecord.setMsgAppId(createDto.getAppId());
        appPushSendRecord.setMsgAppName(appAccess.getAppName());
        appPushSendRecord.setMsgAppSecret(createDto.getAppSecret());
        String s = JSONObject.toJSONString((Object)appPushSendRecord);
        Message message = new Message(s.getBytes(), new MessageProperties());
        this.rabbitTemplate.convertAndSend(QueueEnum.QUEUE_MSG_APPPUSH.getExchange(), QueueEnum.QUEUE_MSG_APPPUSH.getRouteKey(), (Object)message);
        return true;
    }

    private AppPushChannel getAppChannel(Long channelId, String channelNo) {
        AppPushChannel channel;
        QueryWrapper qw = new QueryWrapper();
        if (channelId != null) {
            qw.lambda().eq(AppPushChannel::getId, (Object)channelId);
        }
        if (HussarUtils.isNotEmpty((Object)channelNo)) {
            qw.lambda().eq(AppPushChannel::getChannelNo, (Object)channelNo);
        }
        if ((channel = (AppPushChannel)this.msgAppChannelService.getOne((Wrapper)qw)) == null) {
            throw new HussarException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u901a\u9053");
        }
        if (channel.getStatus() == null || !channel.getStatus().equals(OpenStatusEnum.ENABLE.getCode())) {
            throw new HussarException("\u901a\u9053\u672a\u542f\u7528");
        }
        return channel;
    }
}

