/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.apppush.config.mq;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.msg.apppush.mongodb.document.AppPushSendRecord;
import com.jxdinfo.hussar.msg.apppush.service.AppPushSendRecordService;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AppRabbitMqReceiver {
    private static final Logger logger = LoggerFactory.getLogger(AppRabbitMqReceiver.class);
    @Autowired
    private AppPushSendRecordService msgAppInfoService;

    @RabbitHandler
    @RabbitListener(queues={"#{appPushQueue.name}"})
    public void handlePay(Message message) {
        try {
            String json = new String(message.getBody(), StandardCharsets.UTF_8);
            logger.info("msg apppush json:{}", (Object)json);
            AppPushSendRecord appPushSendRecord = (AppPushSendRecord)JSONObject.parseObject((String)json, AppPushSendRecord.class);
            boolean b = this.msgAppInfoService.sendPushMsg(appPushSendRecord);
            logger.info("msg apppush res:{}", (Object)b);
        }
        catch (Exception e) {
            logger.error("app\u63a8\u9001\u6d88\u606f\u5904\u7406\u9519\u8bef", (Throwable)e);
        }
    }
}

