/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.appim.thrid.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.base.Joiner;
import com.jxdinfo.hussar.msg.appim.config.mongodb.repository.AppImSendRecordRepository;
import com.jxdinfo.hussar.msg.appim.dto.AppImSendArticleCreateDto;
import com.jxdinfo.hussar.msg.appim.dto.AppImSendFileCreateDto;
import com.jxdinfo.hussar.msg.appim.dto.AppImSendImgCreateDto;
import com.jxdinfo.hussar.msg.appim.dto.AppImSendTextCreateDto;
import com.jxdinfo.hussar.msg.appim.model.AppImChannel;
import com.jxdinfo.hussar.msg.appim.mongodb.document.AppImSendRecord;
import com.jxdinfo.hussar.msg.appim.service.AppImChannelService;
import com.jxdinfo.hussar.msg.appim.third.service.AppImPushService;
import com.jxdinfo.hussar.msg.constant.enums.AppEnum;
import com.jxdinfo.hussar.msg.constant.enums.AppImMsgTypeEnum;
import com.jxdinfo.hussar.msg.constant.enums.OpenStatusEnum;
import com.jxdinfo.hussar.msg.constant.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.constant.utils.IdUtil;
import com.jxdinfo.hussar.msg.job.enums.MsgJobEnum;
import com.jxdinfo.hussar.msg.job.service.MsgJobService;
import com.jxdinfo.hussar.platform.core.utils.DateUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.oss.core.support.entity.AttachmentManagerModel;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import com.jxdinfo.mp.im.model.ArticleBean;
import com.jxdinfo.mp.im.model.BaseMsgBean;
import com.jxdinfo.mp.im.model.FileMsgBean;
import com.jxdinfo.mp.im.model.ImgMsgBean;
import com.jxdinfo.mp.push.service.PushService;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@HussarTokenDs
@Service
public class AppImPushServiceImpl
implements AppImPushService {
    private static final Logger logger = LoggerFactory.getLogger(AppImPushServiceImpl.class);
    private PushService pushService = new PushService();
    @Autowired
    private AttachmentManagerService attachmentManagerService;
    @Autowired
    private AppImChannelService appImChannelService;
    @Autowired
    private AppImSendRecordRepository appImSendRecordRepository;
    @Autowired
    private MsgJobService msgJobService;

    public boolean testSendTextMsg(AppImSendTextCreateDto dto) {
        AppImChannel channel = this.getAppImChannel(dto.getChannelId(), dto.getChannelNo());
        AppImSendRecord record = new AppImSendRecord();
        BeanUtils.copyProperties((Object)channel, (Object)record);
        record.setId(IdUtil.fastSimpleUuid());
        record.setChannelId(channel.getId());
        record.setType(AppImMsgTypeEnum.TEXT.getCode());
        record.setContent(dto.getText());
        record.setStatus(Integer.valueOf(1));
        record.setTim(dto.getTim());
        record.setJobTime(dto.getJobTime());
        if (CollectionUtils.isEmpty((Collection)dto.getUserIds())) {
            record.setUserIds(null);
        } else {
            record.setUserIds(Joiner.on((String)",").join((Iterable)dto.getUserIds()));
        }
        record.setAppId(AppEnum.TEST.getAppId());
        record.setAppName(AppEnum.TEST.getAppName());
        record.setAppSecret(AppEnum.TEST.getAppSecret());
        record.setSceneCode(AppEnum.TEST.getSceneCode());
        record.setSceneName(AppEnum.TEST.getSceneName());
        return this.sendTextMsg(record);
    }

    public boolean testSendArticleMsg(AppImSendArticleCreateDto dto) {
        AppImChannel channel = this.getAppImChannel(dto.getChannelId(), dto.getChannelNo());
        AppImSendRecord record = new AppImSendRecord();
        BeanUtils.copyProperties((Object)channel, (Object)record);
        record.setId(IdUtil.fastSimpleUuid());
        record.setChannelId(channel.getId());
        record.setType(AppImMsgTypeEnum.ARTICLE.getCode());
        record.setTim(dto.getTim());
        record.setJobTime(dto.getJobTime());
        JSONObject object = new JSONObject();
        object.put("title", (Object)dto.getTitle());
        object.put("subTitle", (Object)dto.getSubTitle());
        object.put("filePath", (Object)this.getAttachmentUrlPath(dto.getFileIds()));
        object.put("linkType", (Object)dto.getLinkType());
        object.put("url", (Object)dto.getUrl());
        record.setContent(object.toJSONString());
        record.setFileNames(dto.getFileNames());
        record.setStatus(SendStatusEnum.SENDING.getCode());
        if (CollectionUtils.isEmpty((Collection)dto.getUserIds())) {
            record.setUserIds(null);
        } else {
            record.setUserIds(Joiner.on((String)",").join((Iterable)dto.getUserIds()));
        }
        record.setAppId(AppEnum.TEST.getAppId());
        record.setAppName(AppEnum.TEST.getAppName());
        record.setAppSecret(AppEnum.TEST.getAppSecret());
        record.setSceneCode(AppEnum.TEST.getSceneCode());
        record.setSceneName(AppEnum.TEST.getSceneName());
        return this.sendArticleMsg(record);
    }

    public boolean testSendImgMsg(AppImSendImgCreateDto dto) {
        AppImChannel channel = this.getAppImChannel(dto.getChannelId(), dto.getChannelNo());
        AppImSendRecord record = new AppImSendRecord();
        BeanUtils.copyProperties((Object)channel, (Object)record);
        record.setId(IdUtil.fastSimpleUuid());
        record.setChannelId(channel.getId());
        record.setType(AppImMsgTypeEnum.IMG.getCode());
        record.setTim(dto.getTim());
        record.setJobTime(dto.getJobTime());
        JSONObject object = new JSONObject();
        object.put("filePath", (Object)this.getAttachmentUrlPath(dto.getFileIds()));
        record.setContent(object.toJSONString());
        record.setFileNames(dto.getFileNames());
        record.setStatus(SendStatusEnum.SENDING.getCode());
        if (CollectionUtils.isEmpty((Collection)dto.getUserIds())) {
            record.setUserIds(null);
        } else {
            record.setUserIds(Joiner.on((String)",").join((Iterable)dto.getUserIds()));
        }
        record.setAppId(AppEnum.TEST.getAppId());
        record.setAppName(AppEnum.TEST.getAppName());
        record.setAppSecret(AppEnum.TEST.getAppSecret());
        record.setSceneCode(AppEnum.TEST.getSceneCode());
        record.setSceneName(AppEnum.TEST.getSceneName());
        return this.sendImgMsg(record);
    }

    public boolean testSendFileMsg(AppImSendFileCreateDto dto) {
        AppImChannel channel = this.getAppImChannel(dto.getChannelId(), dto.getChannelNo());
        AppImSendRecord record = new AppImSendRecord();
        BeanUtils.copyProperties((Object)channel, (Object)record);
        record.setId(IdUtil.fastSimpleUuid());
        record.setChannelId(channel.getId());
        record.setType(AppImMsgTypeEnum.FILE.getCode());
        record.setTim(dto.getTim());
        record.setJobTime(dto.getJobTime());
        JSONObject object = new JSONObject();
        object.put("filePath", (Object)this.getAttachmentUrlPath(dto.getFileIds()));
        record.setContent(object.toJSONString());
        record.setFileNames(dto.getFileNames());
        record.setStatus(SendStatusEnum.SENDING.getCode());
        if (CollectionUtils.isEmpty((Collection)dto.getUserIds())) {
            record.setUserIds(null);
        } else {
            record.setUserIds(Joiner.on((String)",").join((Iterable)dto.getUserIds()));
        }
        record.setAppId(AppEnum.TEST.getAppId());
        record.setAppName(AppEnum.TEST.getAppName());
        record.setAppSecret(AppEnum.TEST.getAppSecret());
        record.setSceneCode(AppEnum.TEST.getSceneCode());
        record.setSceneName(AppEnum.TEST.getSceneName());
        return this.sendFileMsg(record);
    }

    public boolean sendTextMsg(AppImSendRecord record) {
        List<Object> userIds = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)record.getUserIds())) {
            userIds = Arrays.asList(record.getUserIds().split(","));
        }
        boolean flag = true;
        if (record.getTim() != null && record.getTim().booleanValue()) {
            String msgId = IdUtil.fastSimpleUuid();
            record.setId(msgId);
            this.msgJobService.saveMsgJob(record.getJobTime(), JSONObject.toJSONString((Object)record), MsgJobEnum.MSG_APPIM_TEXT);
            record.setStatus(SendStatusEnum.SENDING.getCode());
            Date date = new Date();
            record.setId(msgId);
            record.setSendTime(record.getJobTime());
            record.setCreateTime(date);
            record.setCreateDate(DateUtil.format((Date)date, (String)"yyyy-MM-dd"));
            this.appImSendRecordRepository.save(record);
        } else if (HussarUtils.isNotEmpty(userIds)) {
            for (String string : userIds) {
                String msgId = IdUtil.fastSimpleUuid();
                if (!this.sendText(record, Collections.singletonList(string))) {
                    flag = false;
                }
                record.setUserIds(string);
                Date now = new Date();
                record.setId(msgId);
                record.setSendTime(now);
                record.setCreateTime(now);
                record.setCreateDate(DateUtil.format((Date)now, (String)"yyyy-MM-dd"));
                this.appImSendRecordRepository.save(record);
            }
        } else {
            String msgId = IdUtil.fastSimpleUuid();
            if (!this.sendText(record, userIds)) {
                flag = false;
            }
            Date date = new Date();
            record.setId(msgId);
            record.setSendTime(date);
            record.setCreateTime(date);
            record.setCreateDate(DateUtil.format((Date)date, (String)"yyyy-MM-dd"));
            this.appImSendRecordRepository.save(record);
        }
        return flag;
    }

    public void jobSendTextMsg(AppImSendRecord record) {
        Optional optional = this.appImSendRecordRepository.findById(record.getId());
        AppImSendRecord appImSendRecord = optional.orElse(new AppImSendRecord());
        if (HussarUtils.isNotEmpty((Object)appImSendRecord.getId())) {
            List<String> userIds = new ArrayList<String>();
            if (HussarUtils.isNotEmpty((Object)appImSendRecord.getUserIds())) {
                userIds = Arrays.asList(appImSendRecord.getUserIds().split(","));
            }
            this.sendText(appImSendRecord, userIds);
            appImSendRecord.setSendTime(new Date());
            this.appImSendRecordRepository.save(appImSendRecord);
        }
    }

    private boolean sendText(AppImSendRecord appImSendRecord, List<String> userIds) {
        boolean flag = true;
        try {
            flag = this.pushService.postMessage((BaseMsgBean)this.pushService.buildTextMsgBean(appImSendRecord.getContent(), BaseMsgBean.Mode.PUBPLAT, appImSendRecord.getPubId(), appImSendRecord.getPubName()), userIds, appImSendRecord.getPubId(), appImSendRecord.getPubPassword(), appImSendRecord.getCompanyId(), appImSendRecord.getCompanyName(), appImSendRecord.getServer());
            if (flag) {
                appImSendRecord.setStatus(SendStatusEnum.SUCCESS.getCode());
            } else {
                appImSendRecord.setStatus(SendStatusEnum.FAIL.getCode());
            }
        }
        catch (Exception e) {
            logger.error("AppIm\u6587\u672c\u6d88\u606f\u53d1\u9001\u5f02\u5e38\uff1a", (Throwable)e);
            appImSendRecord.setStatus(SendStatusEnum.FAIL.getCode());
            flag = false;
            appImSendRecord.setErrMsg(e.getMessage());
        }
        return flag;
    }

    public boolean sendArticleMsg(AppImSendRecord record) {
        boolean flag = true;
        if (record.getTim() != null && record.getTim().booleanValue()) {
            String msgId = IdUtil.fastSimpleUuid();
            record.setId(msgId);
            this.msgJobService.saveMsgJob(record.getJobTime(), JSONObject.toJSONString((Object)record), MsgJobEnum.MSG_APPIM_ARTICLE);
            record.setStatus(SendStatusEnum.SENDING.getCode());
            Date now = new Date();
            record.setId(msgId);
            record.setSendTime(record.getJobTime());
            record.setCreateTime(now);
            record.setCreateDate(DateUtil.format((Date)now, (String)"yyyy-MM-dd"));
            this.appImSendRecordRepository.save(record);
        } else {
            JSONObject jsonObject = JSONObject.parseObject((String)record.getContent());
            ArrayList<String> userIds = new ArrayList();
            if (HussarUtils.isNotEmpty((Object)record.getUserIds())) {
                userIds = Arrays.asList(record.getUserIds().split(","));
            }
            if (HussarUtils.isNotEmpty(userIds)) {
                for (String userId : userIds) {
                    String msgId = IdUtil.fastSimpleUuid();
                    if (!this.sendArticle(record, jsonObject, Collections.singletonList(userId))) {
                        flag = false;
                    }
                    Date now = new Date();
                    record.setUserIds(userId);
                    record.setId(msgId);
                    record.setCreateTime(now);
                    record.setSendTime(now);
                    record.setCreateDate(DateUtil.format((Date)now, (String)"yyyy-MM-dd"));
                    this.appImSendRecordRepository.save(record);
                }
            } else {
                String msgId = IdUtil.fastSimpleUuid();
                if (!this.sendArticle(record, jsonObject, userIds)) {
                    flag = false;
                }
                Date now = new Date();
                record.setId(msgId);
                record.setCreateTime(now);
                record.setSendTime(now);
                record.setCreateDate(DateUtil.format((Date)now, (String)"yyyy-MM-dd"));
                this.appImSendRecordRepository.save(record);
            }
        }
        return flag;
    }

    public void jobSendArticleMsg(AppImSendRecord record) {
        Optional optional = this.appImSendRecordRepository.findById(record.getId());
        AppImSendRecord appImSendRecord = optional.orElse(new AppImSendRecord());
        if (HussarUtils.isNotEmpty((Object)appImSendRecord.getId())) {
            JSONObject jsonObject = JSONObject.parseObject((String)appImSendRecord.getContent());
            List<String> userIds = null;
            if (HussarUtils.isNotEmpty((Object)appImSendRecord.getUserIds())) {
                userIds = Arrays.asList(appImSendRecord.getUserIds().split(","));
            }
            this.sendArticle(appImSendRecord, jsonObject, userIds);
            appImSendRecord.setSendTime(new Date());
            this.appImSendRecordRepository.save(appImSendRecord);
        }
    }

    private boolean sendArticle(AppImSendRecord appImSendRecord, JSONObject jsonObject, List<String> userIds) {
        String title = jsonObject.getString("title");
        String subTitle = jsonObject.getString("subTitle");
        String filePath = jsonObject.getString("filePath");
        Integer linkType = jsonObject.getInteger("linkType");
        String url = jsonObject.getString("url");
        ArticleBean.LinkType type = null;
        boolean flag = true;
        type = ArticleBean.LinkType.HYBRID;
        try {
            ArticleBean articleBean = this.pushService.buildArticle(title, subTitle, new File(filePath), url, type, null, null);
            flag = this.pushService.postMessage((BaseMsgBean)this.pushService.buildArticleMsgBean(Collections.singletonList(articleBean), BaseMsgBean.Mode.PUBPLAT, appImSendRecord.getPubId(), appImSendRecord.getPubName()), userIds, appImSendRecord.getPubId(), appImSendRecord.getPubPassword(), appImSendRecord.getCompanyId(), appImSendRecord.getCompanyName(), appImSendRecord.getServer());
            if (flag) {
                appImSendRecord.setStatus(SendStatusEnum.SUCCESS.getCode());
            } else {
                appImSendRecord.setStatus(SendStatusEnum.FAIL.getCode());
            }
        }
        catch (Exception e) {
            logger.error("AppIm\u56fe\u6587\u6d88\u606f\u53d1\u9001\u5f02\u5e38\uff1a", (Throwable)e);
            appImSendRecord.setStatus(SendStatusEnum.FAIL.getCode());
            flag = false;
            appImSendRecord.setErrMsg(e.getMessage());
        }
        return flag;
    }

    public boolean sendImgMsg(AppImSendRecord record) {
        boolean flag = true;
        if (record.getTim() != null && record.getTim().booleanValue()) {
            String msgId = IdUtil.fastSimpleUuid();
            record.setId(msgId);
            this.msgJobService.saveMsgJob(record.getJobTime(), JSONObject.toJSONString((Object)record), MsgJobEnum.MSG_APPIM_IMG);
            record.setStatus(SendStatusEnum.SENDING.getCode());
            Date now = new Date();
            record.setId(msgId);
            record.setSendTime(record.getJobTime());
            record.setCreateTime(now);
            record.setCreateDate(DateUtil.format((Date)now, (String)"yyyy-MM-dd"));
            this.appImSendRecordRepository.save(record);
        } else {
            List<Object> userIds = new ArrayList();
            if (HussarUtils.isNotEmpty((Object)record.getUserIds())) {
                userIds = Arrays.asList(record.getUserIds().split(","));
            }
            JSONObject jsonObject = JSONObject.parseObject((String)record.getContent());
            String filePath = jsonObject.getString("filePath");
            if (HussarUtils.isNotEmpty(userIds)) {
                for (String string : userIds) {
                    String msgId = IdUtil.fastSimpleUuid();
                    if (!this.sendImg(record, filePath, Collections.singletonList(string))) {
                        flag = false;
                    }
                    Date now = new Date();
                    record.setUserIds(string);
                    record.setId(msgId);
                    record.setCreateTime(now);
                    record.setSendTime(now);
                    record.setCreateDate(DateUtil.format((Date)now, (String)"yyyy-MM-dd"));
                    this.appImSendRecordRepository.save(record);
                }
            } else {
                String msgId = IdUtil.fastSimpleUuid();
                if (!this.sendImg(record, filePath, userIds)) {
                    flag = false;
                }
                Date date = new Date();
                record.setId(msgId);
                record.setCreateTime(date);
                record.setSendTime(date);
                record.setCreateDate(DateUtil.format((Date)date, (String)"yyyy-MM-dd"));
                this.appImSendRecordRepository.save(record);
            }
        }
        return flag;
    }

    public void jobSendImgMsg(AppImSendRecord record) {
        Optional optional = this.appImSendRecordRepository.findById(record.getId());
        AppImSendRecord appImSendRecord = optional.orElse(new AppImSendRecord());
        if (HussarUtils.isNotEmpty((Object)appImSendRecord.getId())) {
            List<String> userIds = null;
            if (HussarUtils.isNotEmpty((Object)appImSendRecord.getUserIds())) {
                userIds = Arrays.asList(appImSendRecord.getUserIds().split(","));
            }
            JSONObject jsonObject = JSONObject.parseObject((String)appImSendRecord.getContent());
            String filePath = jsonObject.getString("filePath");
            this.sendImg(appImSendRecord, filePath, userIds);
            appImSendRecord.setSendTime(new Date());
            this.appImSendRecordRepository.save(appImSendRecord);
        }
    }

    private boolean sendImg(AppImSendRecord appImSendRecord, String filePath, List<String> userIds) {
        boolean flag = true;
        try {
            ImgMsgBean articleBean = this.pushService.buildImgMsgBean(new File(filePath), BaseMsgBean.Mode.PUBPLAT, appImSendRecord.getPubId(), appImSendRecord.getPubName());
            flag = this.pushService.postMessage((BaseMsgBean)articleBean, userIds, appImSendRecord.getPubId(), appImSendRecord.getPubPassword(), appImSendRecord.getCompanyId(), appImSendRecord.getCompanyName(), appImSendRecord.getServer());
            if (flag) {
                appImSendRecord.setStatus(SendStatusEnum.SUCCESS.getCode());
            } else {
                appImSendRecord.setStatus(SendStatusEnum.FAIL.getCode());
            }
        }
        catch (Exception e) {
            logger.error("AppIm\u56fe\u7247\u6d88\u606f\u53d1\u9001\u5f02\u5e38\uff1a", (Throwable)e);
            appImSendRecord.setStatus(SendStatusEnum.FAIL.getCode());
            flag = false;
            appImSendRecord.setErrMsg(e.getMessage());
        }
        return flag;
    }

    public boolean sendFileMsg(AppImSendRecord record) {
        boolean flag = true;
        if (record.getTim() != null && record.getTim().booleanValue()) {
            String msgId = IdUtil.fastSimpleUuid();
            record.setId(msgId);
            this.msgJobService.saveMsgJob(record.getJobTime(), JSONObject.toJSONString((Object)record), MsgJobEnum.MSG_APPIM_FILE);
            record.setStatus(SendStatusEnum.SENDING.getCode());
            Date now = new Date();
            record.setId(msgId);
            record.setSendTime(record.getJobTime());
            record.setCreateTime(now);
            record.setCreateDate(DateUtil.format((Date)now, (String)"yyyy-MM-dd"));
            this.appImSendRecordRepository.save(record);
        } else {
            List<Object> userIds = new ArrayList();
            if (HussarUtils.isNotEmpty((Object)record.getUserIds())) {
                userIds = Arrays.asList(record.getUserIds().split(","));
            }
            JSONObject jsonObject = JSONObject.parseObject((String)record.getContent());
            String filePath = jsonObject.getString("filePath");
            if (HussarUtils.isNotEmpty(userIds)) {
                for (String string : userIds) {
                    String msgId = IdUtil.fastSimpleUuid();
                    if (!this.sendFile(record, filePath, Collections.singletonList(string))) {
                        flag = false;
                    }
                    record.setUserIds(string);
                    Date now = new Date();
                    record.setId(msgId);
                    record.setCreateTime(now);
                    record.setSendTime(now);
                    record.setCreateDate(DateUtil.format((Date)now, (String)"yyyy-MM-dd"));
                    this.appImSendRecordRepository.save(record);
                }
            } else {
                String msgId = IdUtil.fastSimpleUuid();
                if (!this.sendFile(record, filePath, userIds)) {
                    flag = false;
                }
                Date date = new Date();
                record.setId(msgId);
                record.setCreateTime(date);
                record.setSendTime(date);
                record.setCreateDate(DateUtil.format((Date)date, (String)"yyyy-MM-dd"));
                this.appImSendRecordRepository.save(record);
            }
        }
        return flag;
    }

    public void jobSendFileMsg(AppImSendRecord record) {
        Optional optional = this.appImSendRecordRepository.findById(record.getId());
        AppImSendRecord appImSendRecord = optional.orElse(new AppImSendRecord());
        if (HussarUtils.isNotEmpty((Object)appImSendRecord.getId())) {
            List<String> userIds = null;
            if (HussarUtils.isNotEmpty((Object)appImSendRecord.getUserIds())) {
                userIds = Arrays.asList(appImSendRecord.getUserIds().split(","));
            }
            JSONObject jsonObject = JSONObject.parseObject((String)appImSendRecord.getContent());
            String filePath = jsonObject.getString("filePath");
            this.sendFile(appImSendRecord, filePath, userIds);
            appImSendRecord.setSendTime(new Date());
            this.appImSendRecordRepository.save(appImSendRecord);
        }
    }

    private boolean sendFile(AppImSendRecord appImSendRecord, String filePath, List<String> userIds) {
        boolean flag = true;
        try {
            FileMsgBean articleBean = this.pushService.buildFileMsgBean(new File(filePath), BaseMsgBean.Mode.PUBPLAT, appImSendRecord.getPubId(), appImSendRecord.getPubName());
            flag = this.pushService.postMessage((BaseMsgBean)articleBean, userIds, appImSendRecord.getPubId(), appImSendRecord.getPubPassword(), appImSendRecord.getCompanyId(), appImSendRecord.getCompanyName(), appImSendRecord.getServer());
            if (flag) {
                appImSendRecord.setStatus(SendStatusEnum.SUCCESS.getCode());
            } else {
                appImSendRecord.setStatus(SendStatusEnum.FAIL.getCode());
            }
        }
        catch (Exception e) {
            logger.error("AppIm\u6587\u4ef6\u6d88\u606f\u53d1\u9001\u5f02\u5e38\uff1a", (Throwable)e);
            appImSendRecord.setStatus(SendStatusEnum.FAIL.getCode());
            flag = false;
            appImSendRecord.setErrMsg(e.getMessage());
        }
        return flag;
    }

    private AppImChannel getAppImChannel(Long channelId, String channelNo) {
        AppImChannel channel;
        QueryWrapper qw = new QueryWrapper();
        if (channelId != null) {
            qw.lambda().eq(AppImChannel::getId, (Object)channelId);
        }
        if (HussarUtils.isNotEmpty((Object)channelNo)) {
            qw.lambda().eq(AppImChannel::getChannelNo, (Object)channelNo);
        }
        if ((channel = (AppImChannel)this.appImChannelService.getOne((Wrapper)qw)) == null) {
            throw new HussarException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u901a\u9053");
        }
        if (channel.getOpenStatus() == null || !channel.getOpenStatus().equals(OpenStatusEnum.ENABLE.getCode())) {
            throw new HussarException("\u901a\u9053\u672a\u542f\u7528");
        }
        return channel;
    }

    private String getAttachmentUrlPath(String fileIds) {
        String path = "";
        if (HussarUtils.isEmpty((Object)fileIds)) {
            return path;
        }
        List<String> fileIdList = Arrays.asList(fileIds.split(","));
        List attachList = this.attachmentManagerService.listByIds(fileIdList);
        if (HussarUtils.isNotEmpty((Object)attachList)) {
            for (AttachmentManagerModel attach : attachList) {
                Long fileId = attach.getId();
                String fileName = attach.getAttachmentName();
                String suffix = fileName.substring(fileName.lastIndexOf("."));
                path = attach.getAttachmentDir().replace("\\", "/") + fileId + suffix;
            }
        }
        return path;
    }
}

