/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.appim.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.base.Joiner;
import com.jxdinfo.hussar.msg.app.dto.ConfigJsonData;
import com.jxdinfo.hussar.msg.app.model.AppAccess;
import com.jxdinfo.hussar.msg.app.service.AppAccessService;
import com.jxdinfo.hussar.msg.app.service.AppSceneConfigService;
import com.jxdinfo.hussar.msg.appim.config.mongodb.repository.AppImSendRecordRepository;
import com.jxdinfo.hussar.msg.appim.dto.AppImChannelSendStatisticsVo;
import com.jxdinfo.hussar.msg.appim.dto.AppImSendArticleCreateDto;
import com.jxdinfo.hussar.msg.appim.dto.AppImSendFileCreateDto;
import com.jxdinfo.hussar.msg.appim.dto.AppImSendImgCreateDto;
import com.jxdinfo.hussar.msg.appim.dto.AppImSendRecordQueryDto;
import com.jxdinfo.hussar.msg.appim.dto.AppImSendTextCreateDto;
import com.jxdinfo.hussar.msg.appim.model.AppImChannel;
import com.jxdinfo.hussar.msg.appim.mongodb.document.AppImSendRecord;
import com.jxdinfo.hussar.msg.appim.service.AppImChannelService;
import com.jxdinfo.hussar.msg.appim.service.AppImSendRecordService;
import com.jxdinfo.hussar.msg.common.model.ChannelsVo;
import com.jxdinfo.hussar.msg.constant.enums.AppImMsgTypeEnum;
import com.jxdinfo.hussar.msg.constant.enums.OpenStatusEnum;
import com.jxdinfo.hussar.msg.constant.enums.QueueEnum;
import com.jxdinfo.hussar.msg.constant.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.constant.enums.ServiceTypeEnum;
import com.jxdinfo.hussar.msg.constant.utils.IdUtil;
import com.jxdinfo.hussar.msg.constant.utils.Strings;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.oss.core.support.entity.AttachmentManagerModel;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@HussarTokenDs
@Service
public class AppImSendRecordServiceImpl
implements AppImSendRecordService {
    @Autowired
    private AppImChannelService appImChannelService;
    @Autowired
    private AttachmentManagerService attachmentManagerService;
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired(required=false)
    private AppImSendRecordRepository appImSendRecordRepository;
    @Autowired(required=false)
    private MongoTemplate mongoTemplate;
    @Autowired
    private AppAccessService appAccessService;
    @Autowired
    private AppSceneConfigService appSceneConfigService;

    public boolean sendTextMsg(AppImSendTextCreateDto dto) {
        AppAccess appAccess = this.appAccessService.getAppAccess(dto.getAppId(), dto.getAppSecret());
        ConfigJsonData configJsonData = this.appSceneConfigService.getConfigData(dto.getSceneCode(), appAccess.getId().toString(), ServiceTypeEnum.APP_IM.getCode());
        AppImChannel channel = this.getAppImChannel(dto.getChannelId(), configJsonData.getChannelNo());
        AppImSendRecord record = new AppImSendRecord();
        BeanUtils.copyProperties((Object)channel, (Object)record);
        record.setId(IdUtil.fastSimpleUuid());
        record.setSceneCode(dto.getSceneCode());
        record.setSceneName(configJsonData.getSceneName());
        record.setChannelId(channel.getId());
        record.setType(AppImMsgTypeEnum.TEXT.getCode());
        record.setContent(dto.getText());
        record.setTim(dto.getTim());
        record.setJobTime(dto.getJobTime());
        record.setStatus(SendStatusEnum.SENDING.getCode());
        record.setAppId(dto.getAppId());
        record.setAppName(appAccess.getAppName());
        record.setAppSecret(dto.getAppSecret());
        if (CollectionUtils.isEmpty((Collection)dto.getUserIds())) {
            record.setUserIds(null);
        } else {
            record.setUserIds(Joiner.on((String)",").join((Iterable)dto.getUserIds()));
        }
        String s = JSONObject.toJSONString((Object)record);
        Message message = new Message(s.getBytes(), new MessageProperties());
        this.rabbitTemplate.convertAndSend(QueueEnum.QUEUE_MSG_APPIM.getExchange(), QueueEnum.QUEUE_MSG_APPIM.getRouteKey(), (Object)message);
        return true;
    }

    public boolean sendArticleMsg(AppImSendArticleCreateDto dto) {
        AppAccess appAccess = this.appAccessService.getAppAccess(dto.getAppId(), dto.getAppSecret());
        ConfigJsonData configJsonData = this.appSceneConfigService.getConfigData(dto.getSceneCode(), appAccess.getId().toString(), ServiceTypeEnum.APP_IM.getCode());
        AppImChannel channel = this.getAppImChannel(dto.getChannelId(), configJsonData.getChannelNo());
        AppImSendRecord record = new AppImSendRecord();
        BeanUtils.copyProperties((Object)channel, (Object)record);
        record.setId(IdUtil.fastSimpleUuid());
        record.setChannelId(channel.getId());
        record.setSceneCode(dto.getSceneCode());
        record.setSceneName(configJsonData.getSceneName());
        record.setType(AppImMsgTypeEnum.ARTICLE.getCode());
        record.setTim(dto.getTim());
        record.setJobTime(dto.getJobTime());
        JSONObject object = new JSONObject();
        object.put("title", (Object)dto.getTitle());
        object.put("subTitle", (Object)dto.getSubTitle());
        object.put("filePath", (Object)this.getAttachmentUrlPath(dto.getFileIds()));
        object.put("linkType", (Object)dto.getLinkType());
        object.put("url", (Object)dto.getUrl());
        record.setContent(object.toJSONString());
        record.setStatus(SendStatusEnum.SENDING.getCode());
        record.setAppId(dto.getAppId());
        record.setAppName(appAccess.getAppName());
        record.setAppSecret(dto.getAppSecret());
        if (CollectionUtils.isEmpty((Collection)dto.getUserIds())) {
            record.setUserIds(null);
        } else {
            record.setUserIds(Joiner.on((String)",").join((Iterable)dto.getUserIds()));
        }
        String s = JSONObject.toJSONString((Object)record);
        Message message = new Message(s.getBytes(), new MessageProperties());
        this.rabbitTemplate.convertAndSend(QueueEnum.QUEUE_MSG_APPIM.getExchange(), QueueEnum.QUEUE_MSG_APPIM.getRouteKey(), (Object)message);
        return true;
    }

    public boolean sendImgMsg(AppImSendImgCreateDto dto) {
        AppAccess appAccess = this.appAccessService.getAppAccess(dto.getAppId(), dto.getAppSecret());
        ConfigJsonData configJsonData = this.appSceneConfigService.getConfigData(dto.getSceneCode(), appAccess.getId().toString(), ServiceTypeEnum.APP_IM.getCode());
        AppImChannel channel = this.getAppImChannel(dto.getChannelId(), configJsonData.getChannelNo());
        AppImSendRecord record = new AppImSendRecord();
        BeanUtils.copyProperties((Object)channel, (Object)record);
        record.setId(IdUtil.fastSimpleUuid());
        record.setSceneCode(dto.getSceneCode());
        record.setSceneName(configJsonData.getSceneName());
        record.setChannelId(channel.getId());
        record.setType(AppImMsgTypeEnum.IMG.getCode());
        record.setTim(dto.getTim());
        record.setJobTime(dto.getJobTime());
        JSONObject object = new JSONObject();
        object.put("filePath", (Object)this.getAttachmentUrlPath(dto.getFileIds()));
        record.setContent(object.toJSONString());
        record.setStatus(SendStatusEnum.SENDING.getCode());
        record.setAppId(dto.getAppId());
        record.setAppName(appAccess.getAppName());
        record.setAppSecret(dto.getAppSecret());
        if (CollectionUtils.isEmpty((Collection)dto.getUserIds())) {
            record.setUserIds(null);
        } else {
            record.setUserIds(Joiner.on((String)",").join((Iterable)dto.getUserIds()));
        }
        String s = JSONObject.toJSONString((Object)record);
        Message message = new Message(s.getBytes(), new MessageProperties());
        this.rabbitTemplate.convertAndSend(QueueEnum.QUEUE_MSG_APPIM.getExchange(), QueueEnum.QUEUE_MSG_APPIM.getRouteKey(), (Object)message);
        return true;
    }

    public boolean sendFileMsg(AppImSendFileCreateDto dto) {
        AppAccess appAccess = this.appAccessService.getAppAccess(dto.getAppId(), dto.getAppSecret());
        ConfigJsonData configJsonData = this.appSceneConfigService.getConfigData(dto.getSceneCode(), appAccess.getId().toString(), ServiceTypeEnum.APP_IM.getCode());
        AppImChannel channel = this.getAppImChannel(dto.getChannelId(), configJsonData.getChannelNo());
        AppImSendRecord record = new AppImSendRecord();
        BeanUtils.copyProperties((Object)channel, (Object)record);
        record.setId(IdUtil.fastSimpleUuid());
        record.setSceneCode(dto.getSceneCode());
        record.setSceneName(configJsonData.getSceneName());
        record.setChannelId(channel.getId());
        record.setType(AppImMsgTypeEnum.FILE.getCode());
        record.setTim(dto.getTim());
        record.setJobTime(dto.getJobTime());
        JSONObject object = new JSONObject();
        object.put("filePath", (Object)this.getAttachmentUrlPath(dto.getFileIds()));
        record.setContent(object.toJSONString());
        record.setStatus(SendStatusEnum.SENDING.getCode());
        record.setAppId(dto.getAppId());
        record.setAppName(appAccess.getAppName());
        record.setAppSecret(dto.getAppSecret());
        if (CollectionUtils.isEmpty((Collection)dto.getUserIds())) {
            record.setUserIds(null);
        } else {
            record.setUserIds(Joiner.on((String)",").join((Iterable)dto.getUserIds()));
        }
        String s = JSONObject.toJSONString((Object)record);
        Message message = new Message(s.getBytes(), new MessageProperties());
        this.rabbitTemplate.convertAndSend(QueueEnum.QUEUE_MSG_APPIM.getExchange(), QueueEnum.QUEUE_MSG_APPIM.getRouteKey(), (Object)message);
        return true;
    }

    public IPage<AppImSendRecord> listPage(Page<AppImSendRecord> pageable, AppImSendRecordQueryDto queryDto) {
        Query query = new Query();
        Criteria criteria = new Criteria();
        if (queryDto.getBeginTime() != null && queryDto.getEndTime() != null) {
            Criteria fromTime = Criteria.where((String)"createTime").gt((Object)queryDto.getBeginTime());
            Criteria toTime = Criteria.where((String)"createTime").lt((Object)queryDto.getEndTime());
            criteria.andOperator(new Criteria[]{fromTime, toTime});
        }
        if (HussarUtils.isNotEmpty((Object)queryDto.getAppName())) {
            criteria.and("appName").regex(Strings.format("%s%s%s", ".*", queryDto.getAppName(), ".*"));
        }
        if (HussarUtils.isNotEmpty((Object)queryDto.getChannelName())) {
            criteria.orOperator(new Criteria[]{Criteria.where((String)"channelName").regex(Strings.format("%s%s%s", ".*", queryDto.getChannelName().trim(), ".*")), Criteria.where((String)"channelNo").regex(Strings.format("%s%s%s", ".*", queryDto.getChannelName().trim(), ".*"))});
        }
        if (HussarUtils.isNotEmpty((Object)queryDto.getChannelNo())) {
            criteria.and("channelNo").regex(Strings.format("%s%s%s", ".*", queryDto.getChannelNo(), ".*"));
        }
        if (HussarUtils.isNotEmpty((Object)queryDto.getSceneCode())) {
            criteria.and("sceneCode").regex(Strings.format("%s%s%s", ".*", queryDto.getSceneCode(), ".*"));
        }
        if (HussarUtils.isNotEmpty((Object)queryDto.getSceneName())) {
            criteria.and("sceneName").regex(Strings.format("%s%s%s", ".*", queryDto.getSceneName(), ".*"));
        }
        if (queryDto.getStatus() != null) {
            criteria.and("status").is((Object)queryDto.getStatus());
        }
        if (queryDto.getType() != null) {
            criteria.and("type").is((Object)queryDto.getType());
        }
        query.addCriteria((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"createTime")}));
        long total = this.mongoTemplate.count(query, AppImSendRecord.class);
        query.skip((pageable.getCurrent() - 1L) * pageable.getSize());
        query.limit((int)pageable.getSize());
        List list = this.mongoTemplate.find(query, AppImSendRecord.class);
        Page page = new Page();
        page.setCurrent(pageable.getCurrent());
        page.setSize(pageable.getSize());
        page.setTotal(total);
        page.setRecords(list);
        return page;
    }

    public AppImSendRecord findById(String id) {
        Optional entity = this.appImSendRecordRepository.findById(id);
        return (AppImSendRecord)entity.get();
    }

    public List<ChannelsVo> getAllChannels() {
        Aggregation agg = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.group((String[])new String[]{"channelNo", "channelName"})});
        return this.mongoTemplate.aggregate(agg, AppImSendRecord.class, ChannelsVo.class).getMappedResults();
    }

    public List<AppImChannelSendStatisticsVo> sendStatistics(AppImSendRecordQueryDto queryDto) {
        Criteria criteria = new Criteria();
        if (queryDto.getBeginTime() != null && queryDto.getEndTime() != null) {
            Criteria fromTime = Criteria.where((String)"createTime").gt((Object)queryDto.getBeginTime());
            Criteria toTime = Criteria.where((String)"createTime").lt((Object)queryDto.getEndTime());
            criteria.andOperator(new Criteria[]{fromTime, toTime});
        }
        if (HussarUtils.isNotEmpty((Object)queryDto.getChannelNo())) {
            criteria.and("channelNo").is((Object)queryDto.getChannelNo());
        }
        Aggregation agg = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{"channelNo", "createDate", "status", "channelName"}).count().as("count")});
        AggregationResults aggregate = this.mongoTemplate.aggregate(agg, AppImSendRecord.class, SendRecordAgg.class);
        List mappedResults = aggregate.getMappedResults();
        Map<String, List<SendRecordAgg>> listMap = mappedResults.parallelStream().collect(Collectors.groupingBy(SendRecordAgg::getChannelNo));
        List createDateList = mappedResults.parallelStream().map(SendRecordAgg::getCreateDate).distinct().sorted().collect(Collectors.toList());
        ArrayList<AppImChannelSendStatisticsVo> result = new ArrayList<AppImChannelSendStatisticsVo>();
        listMap.forEach((channelNo, aggs) -> {
            AppImChannelSendStatisticsVo statisticsVo = new AppImChannelSendStatisticsVo();
            statisticsVo.setChannelNo(channelNo);
            statisticsVo.setChannelName(HussarUtils.isNotEmpty((Object)aggs) ? ((SendRecordAgg)aggs.get(0)).getChannelName() : null);
            statisticsVo.setCreateDate(createDateList);
            ArrayList aggVos = new ArrayList();
            Map<String, Map<Integer, List<SendRecordAgg>>> collect = aggs.parallelStream().collect(Collectors.groupingBy(SendRecordAgg::getCreateDate, Collectors.groupingBy(SendRecordAgg::getStatus)));
            collect.forEach((createDate, aggs1) -> {
                AppImChannelSendStatisticsVo.AppImChannelSendStatisticAgg aggVo = new AppImChannelSendStatisticsVo.AppImChannelSendStatisticAgg();
                aggVo.setSendDate(createDate);
                aggs1.forEach((status, aggs2) -> {
                    if (status.equals(SendStatusEnum.SUCCESS.getCode())) {
                        aggVo.setSuccessCount(((SendRecordAgg)aggs2.get(0)).count);
                    } else if (status.equals(SendStatusEnum.FAIL.getCode())) {
                        aggVo.setFailCount(((SendRecordAgg)aggs2.get(0)).count);
                    } else if (status.equals(SendStatusEnum.SENDING.getCode())) {
                        aggVo.setWillCount(((SendRecordAgg)aggs2.get(0)).count);
                    }
                });
                aggVos.add(aggVo);
            });
            statisticsVo.setAggs(aggVos);
            result.add(statisticsVo);
        });
        return result;
    }

    private String getAttachmentUrlPath(String fileIds) {
        String path = "";
        if (HussarUtils.isEmpty((Object)fileIds)) {
            return path;
        }
        List<String> fileIdList = Arrays.asList(fileIds.split(","));
        List attachList = this.attachmentManagerService.listByIds(fileIdList);
        if (HussarUtils.isNotEmpty((Object)attachList)) {
            for (AttachmentManagerModel attach : attachList) {
                Long fileId = attach.getId();
                String fileName = attach.getAttachmentName();
                String suffix = fileName.substring(fileName.lastIndexOf("."));
                path = attach.getAttachmentDir().replace("\\", "/") + fileId + suffix;
            }
        }
        return path;
    }

    private AppImChannel getAppImChannel(Long channelId, String channelNo) {
        AppImChannel channel;
        QueryWrapper qw = new QueryWrapper();
        if (channelId != null) {
            qw.lambda().eq(AppImChannel::getId, (Object)channelId);
        }
        if (HussarUtils.isNotEmpty((Object)channelNo)) {
            qw.lambda().eq(AppImChannel::getChannelNo, (Object)channelNo);
        }
        if ((channel = (AppImChannel)this.appImChannelService.getOne((Wrapper)qw)) == null) {
            throw new HussarException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u901a\u9053");
        }
        if (channel.getOpenStatus() == null || !channel.getOpenStatus().equals(OpenStatusEnum.ENABLE.getCode())) {
            throw new HussarException("\u901a\u9053\u672a\u542f\u7528");
        }
        return channel;
    }

    public boolean saveRecord(AppImSendRecord appImSendRecord) {
        return HussarUtils.isNotEmpty((Object)this.appImSendRecordRepository.save(appImSendRecord));
    }

    public static class SendRecordAgg {
        private String channelNo;
        private String channelName;
        private String createDate;
        private Integer status;
        private Long count;

        public String getChannelName() {
            return this.channelName;
        }

        public void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        public String getChannelNo() {
            return this.channelNo;
        }

        public void setChannelNo(String channelNo) {
            this.channelNo = channelNo;
        }

        public String getCreateDate() {
            return this.createDate;
        }

        public void setCreateDate(String createDate) {
            this.createDate = createDate;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public Long getCount() {
            return this.count;
        }

        public void setCount(Long count) {
            this.count = count;
        }
    }
}

