/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.appim.config.mq;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.msg.appim.mongodb.document.AppImSendRecord;
import com.jxdinfo.hussar.msg.appim.third.service.AppImPushService;
import com.jxdinfo.hussar.msg.constant.enums.AppImMsgTypeEnum;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AppImRabbitMqReceiver {
    private static final Logger logger = LoggerFactory.getLogger(AppImRabbitMqReceiver.class);
    @Autowired
    private AppImPushService appImPushService;

    @RabbitHandler
    @RabbitListener(queues={"#{appImQueue.name}"})
    public void handlePay(Message message) {
        try {
            logger.info(String.valueOf(message));
            String json = new String(message.getBody(), StandardCharsets.UTF_8);
            logger.info("msg app im json:{}", (Object)json);
            AppImSendRecord record = (AppImSendRecord)JSONObject.parseObject((String)json, AppImSendRecord.class);
            switch (AppImMsgTypeEnum.getByCode(record.getType())) {
                case TEXT: {
                    this.appImPushService.sendTextMsg(record);
                    break;
                }
                case ARTICLE: {
                    this.appImPushService.sendArticleMsg(record);
                    break;
                }
                case IMG: {
                    this.appImPushService.sendImgMsg(record);
                    break;
                }
                case FILE: {
                    this.appImPushService.sendFileMsg(record);
                    break;
                }
                default: {
                    logger.error("\u9519\u8bef\u7684app_im\u6d88\u606f\u7c7b\u578b");
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error("app_im\u6d88\u606f\u5904\u7406\u9519\u8bef", (Throwable)e);
        }
    }
}

