/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.app.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.msg.app.dao.AppAccessMapper;
import com.jxdinfo.hussar.msg.app.dto.AppAccessCreateDto;
import com.jxdinfo.hussar.msg.app.dto.AppAccessPageDto;
import com.jxdinfo.hussar.msg.app.dto.AppAccessQueryVo;
import com.jxdinfo.hussar.msg.app.dto.AppAccessUpdateDto;
import com.jxdinfo.hussar.msg.app.dto.ConfigJsonData;
import com.jxdinfo.hussar.msg.app.model.AppAccess;
import com.jxdinfo.hussar.msg.app.model.AppSceneConfig;
import com.jxdinfo.hussar.msg.app.service.AppAccessService;
import com.jxdinfo.hussar.msg.app.service.AppSceneConfigService;
import com.jxdinfo.hussar.msg.constant.enums.ServiceTypeEnum;
import com.jxdinfo.hussar.msg.constant.utils.IdUtil;
import com.jxdinfo.hussar.msg.mail.model.MsgMailTemplate;
import com.jxdinfo.hussar.msg.mail.service.MsgMailTemplateService;
import com.jxdinfo.hussar.msg.mp.model.MsgMpTemplate;
import com.jxdinfo.hussar.msg.mp.service.MpTemplateService;
import com.jxdinfo.hussar.msg.push.dto.AppSceneVo;
import com.jxdinfo.hussar.msg.push.dto.AppServiceDto;
import com.jxdinfo.hussar.msg.push.dto.TemplateData;
import com.jxdinfo.hussar.msg.sms.model.MsgSmsTemplate;
import com.jxdinfo.hussar.msg.sms.service.SmsTemplateService;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppAccessServiceImpl
extends HussarServiceImpl<AppAccessMapper, AppAccess>
implements AppAccessService {
    @Autowired
    private AppSceneConfigService appSceneConfigService;
    @Autowired
    private SmsTemplateService smsTemplateService;
    @Autowired
    private MsgMailTemplateService mailTemplateService;
    @Autowired
    private MpTemplateService mpTemplateService;

    public IPage<AppAccess> listPage(Page page, AppAccessPageDto pageDto) {
        Map<String, String> serviceMap = ServiceTypeEnum.getServiceMap();
        IPage<AppAccess> pageList = ((AppAccessMapper)this.baseMapper).queryPage(page, pageDto);
        pageList.getRecords().forEach(o -> o.setServiceTypeData(Arrays.stream(o.getServiceType().split(",")).map(serviceMap::get).collect(Collectors.joining(","))));
        return pageList;
    }

    public AppAccessQueryVo findById(long id) {
        AppAccess entity = (AppAccess)super.getById((Serializable)Long.valueOf(id));
        return this.entity2QueryVo(entity);
    }

    public boolean save(AppAccessCreateDto createDto) {
        QueryWrapper nameQw = new QueryWrapper();
        nameQw.lambda().eq(AppAccess::getAppName, (Object)createDto.getAppName());
        if (this.count((Wrapper)nameQw) > 0L) {
            throw new HussarException("\u5e94\u7528\u540d\u79f0'" + createDto.getAppName() + "'\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539\uff01");
        }
        QueryWrapper idQw = new QueryWrapper();
        idQw.lambda().eq(AppAccess::getAppId, (Object)createDto.getAppId());
        if (this.count((Wrapper)idQw) > 0L) {
            throw new HussarException("\u5e94\u7528\u6807\u8bc6'" + createDto.getAppId() + "'\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539\uff01");
        }
        String appId = createDto.getAppId();
        String appSecret = IdUtil.getAppSecret(appId);
        createDto.setAppSecret(appSecret);
        AppAccess entity = new AppAccess();
        BeanUtils.copyProperties((Object)createDto, (Object)entity);
        return super.save((BaseEntity)entity);
    }

    public boolean updateById(AppAccessUpdateDto updateDto) {
        AppAccess entity = new AppAccess();
        BeanUtils.copyProperties((Object)updateDto, (Object)entity);
        QueryWrapper nameQw = new QueryWrapper();
        nameQw.lambda().eq(AppAccess::getAppName, (Object)entity.getAppName());
        nameQw.lambda().ne(AppAccess::getId, (Object)entity.getId());
        if (this.count((Wrapper)nameQw) > 0L) {
            throw new HussarException("\u5e94\u7528\u540d\u79f0'" + updateDto.getAppName() + "'\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539\uff01");
        }
        QueryWrapper idQw = new QueryWrapper();
        idQw.lambda().eq(AppAccess::getAppId, (Object)entity.getAppId());
        idQw.lambda().ne(AppAccess::getId, (Object)entity.getId());
        if (this.count((Wrapper)idQw) > 0L) {
            throw new HussarException("\u5e94\u7528\u6807\u8bc6'" + entity.getAppId() + "'\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539\uff01");
        }
        return super.updateById((BaseEntity)entity);
    }

    public boolean delete(Long id) {
        if (HussarUtils.isNotEmpty((Object)this.appSceneConfigService.list((Wrapper)new LambdaQueryWrapper().eq(AppSceneConfig::getAppPkId, (Object)id)))) {
            throw new HussarException("\u5b58\u5728\u76f8\u5173\u573a\u666f\uff0c\u8bf7\u5148\u5220\u9664\u573a\u666f\uff01");
        }
        return super.removeById((Serializable)id);
    }

    public boolean deleteAccessByIds(Long[] ids) {
        if (HussarUtils.isNotEmpty((Object)this.appSceneConfigService.listByIds(Arrays.asList(ids)))) {
            throw new HussarException("\u5b58\u5728\u76f8\u5173\u573a\u666f\uff0c\u8bf7\u5148\u5220\u9664\u573a\u666f\uff01");
        }
        return super.removeByIds(Arrays.asList(ids));
    }

    public AppAccess getAppAccess(String appId, String appSecret) {
        if (HussarUtils.isEmpty((Object)appId)) {
            throw new HussarException("appId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (HussarUtils.isEmpty((Object)appSecret)) {
            throw new HussarException("appSecret\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryWrapper qw = new QueryWrapper();
        qw.lambda().eq(AppAccess::getAppId, (Object)appId);
        qw.lambda().eq(AppAccess::getAppSecret, (Object)appSecret);
        AppAccess appAccess = (AppAccess)this.getOne((Wrapper)qw);
        if (appAccess == null) {
            throw new HussarException("\u672a\u67e5\u5230\u6388\u6743\u4fe1\u606f");
        }
        if (appAccess.getStatus() == null || appAccess.getStatus() != 1) {
            throw new HussarException("\u6388\u6743\u672a\u542f\u7528");
        }
        return appAccess;
    }

    public List<AppSceneVo> getAppService(AppServiceDto appServiceDto) {
        if (HussarUtils.isEmpty((Object)appServiceDto.getAppId())) {
            throw new HussarException("appId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (HussarUtils.isEmpty((Object)appServiceDto.getAppSecret())) {
            throw new HussarException("appSecret\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryWrapper qw = new QueryWrapper();
        qw.lambda().eq(AppAccess::getAppId, (Object)appServiceDto.getAppId());
        qw.lambda().eq(AppAccess::getAppSecret, (Object)appServiceDto.getAppSecret());
        qw.lambda().eq(AppAccess::getStatus, (Object)1);
        return this.getAppSceneTemplate((AppAccess)this.getOne((Wrapper)qw));
    }

    public List<AppSceneVo> getAppService2(AppServiceDto appServiceDto) {
        if (HussarUtils.isEmpty((Object)appServiceDto.getAppId())) {
            throw new HussarException("appId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (HussarUtils.isEmpty((Object)appServiceDto.getAppSecret())) {
            throw new HussarException("appSecret\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryWrapper qw = new QueryWrapper();
        qw.lambda().eq(AppAccess::getAppId, (Object)appServiceDto.getAppId());
        qw.lambda().eq(AppAccess::getAppSecret, (Object)appServiceDto.getAppSecret());
        qw.lambda().eq(AppAccess::getStatus, (Object)1);
        return this.convertServiceMap((AppAccess)this.getOne((Wrapper)qw));
    }

    public List<AppSceneVo> getAppService(Long id) {
        if (HussarUtils.isEmpty((Object)id)) {
            throw new HussarException("\u67e5\u8be2\u670d\u52a1\u7c7b\u578b\u5931\u8d25\uff0c\u5e94\u7528\u4e3b\u952e\u4e3a\u7a7a\uff01");
        }
        return this.convertServiceMap((AppAccess)this.getById(id));
    }

    public List<AppSceneVo> convertServiceMap(AppAccess appAccess) {
        ArrayList<AppSceneVo> list = new ArrayList<AppSceneVo>();
        Map<String, String> serviceMap = ServiceTypeEnum.getServiceMap();
        if (HussarUtils.isNotEmpty((Object)appAccess) && HussarUtils.isNotEmpty((Object)appAccess.getServiceType())) {
            for (String service : appAccess.getServiceType().split(",")) {
                AppSceneVo appSceneVo = new AppSceneVo();
                appSceneVo.setId(service);
                appSceneVo.setName(serviceMap.get(service));
                list.add(appSceneVo);
            }
        }
        return list;
    }

    private AppAccessQueryVo entity2QueryVo(AppAccess entity) {
        AppAccessQueryVo vo = new AppAccessQueryVo();
        if (entity != null) {
            BeanUtils.copyProperties((Object)entity, (Object)vo);
        }
        return vo;
    }

    private List<AppSceneVo> getAppSceneTemplate(AppAccess appAccess) {
        List<AppSceneVo> serviceList = new ArrayList<AppSceneVo>();
        if (HussarUtils.isEmpty((Object)appAccess) || HussarUtils.isEmpty((Object)appAccess.getId())) {
            return serviceList;
        }
        List configJsonDataList = this.appSceneConfigService.getConfigDataTemplate(appAccess.getId());
        serviceList = this.convertServiceMap(appAccess);
        if (HussarUtils.isNotEmpty(serviceList) && HussarUtils.isNotEmpty((Object)configJsonDataList)) {
            block10: for (AppSceneVo appSceneVo : serviceList) {
                switch (appSceneVo.getId()) {
                    case "sms": {
                        appSceneVo.setTemplates(this.getSmsTemplates(appSceneVo.getId(), configJsonDataList));
                        continue block10;
                    }
                    case "mail": {
                        appSceneVo.setTemplates(this.getMailTemplates(appSceneVo.getId(), configJsonDataList));
                        continue block10;
                    }
                    case "wx_account": {
                        appSceneVo.setTemplates(this.getMpTemplates(appSceneVo.getId(), configJsonDataList));
                        continue block10;
                    }
                }
            }
        }
        return serviceList;
    }

    private List<TemplateData> getSmsTemplates(String serviceType, List<ConfigJsonData> configJsonDataList) {
        ArrayList<TemplateData> smsTemplateDatas = new ArrayList<TemplateData>();
        List templateNo = configJsonDataList.stream().filter(o -> serviceType.equals(o.getChannelType())).map(ConfigJsonData::getTemplateNo).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(templateNo)) {
            List smsTemplates = this.smsTemplateService.list((Wrapper)new LambdaQueryWrapper().in(MsgSmsTemplate::getTemplateNo, templateNo));
            for (ConfigJsonData configJsonData : configJsonDataList) {
                if (!serviceType.equals(configJsonData.getChannelType())) continue;
                for (MsgSmsTemplate msgSmsTemplate : smsTemplates) {
                    if (!configJsonData.getTemplateNo().equals(msgSmsTemplate.getTemplateNo())) continue;
                    TemplateData templateData = new TemplateData();
                    templateData.setSceneName(configJsonData.getSceneName());
                    templateData.setTemplate(msgSmsTemplate.getTemplateContent());
                    smsTemplateDatas.add(templateData);
                }
            }
        }
        return smsTemplateDatas;
    }

    private List<TemplateData> getMailTemplates(String serviceType, List<ConfigJsonData> configJsonDataList) {
        ArrayList<TemplateData> mailTemplateDatas = new ArrayList<TemplateData>();
        List templateNo = configJsonDataList.stream().filter(o -> serviceType.equals(o.getChannelType())).map(ConfigJsonData::getTemplateNo).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(templateNo)) {
            List mailTemplates = this.mailTemplateService.list((Wrapper)new LambdaQueryWrapper().in(MsgMailTemplate::getTemplateNo, templateNo));
            for (ConfigJsonData configJsonData : configJsonDataList) {
                if (!serviceType.equals(configJsonData.getChannelType())) continue;
                for (MsgMailTemplate msgMailTemplate : mailTemplates) {
                    if (!configJsonData.getTemplateNo().equals(msgMailTemplate.getTemplateNo())) continue;
                    TemplateData templateData = new TemplateData();
                    templateData.setSceneName(configJsonData.getSceneName());
                    templateData.setTemplate(msgMailTemplate.getTemplateContent());
                    mailTemplateDatas.add(templateData);
                }
            }
        }
        return mailTemplateDatas;
    }

    private List<TemplateData> getMpTemplates(String serviceType, List<ConfigJsonData> configJsonDataList) {
        ArrayList<TemplateData> mpTemplateDatas = new ArrayList<TemplateData>();
        List templateNo = configJsonDataList.stream().filter(o -> serviceType.equals(o.getChannelType())).map(ConfigJsonData::getTemplateNo).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(templateNo)) {
            List mpTemplates = this.mpTemplateService.list((Wrapper)new LambdaQueryWrapper().in(MsgMpTemplate::getTemplateNo, templateNo));
            for (ConfigJsonData configJsonData : configJsonDataList) {
                if (!serviceType.equals(configJsonData.getChannelType())) continue;
                for (MsgMpTemplate mpTemplate : mpTemplates) {
                    if (!configJsonData.getTemplateNo().equals(mpTemplate.getTemplateNo())) continue;
                    TemplateData templateData = new TemplateData();
                    templateData.setSceneName(configJsonData.getSceneName());
                    templateData.setTemplate(mpTemplate.getContent());
                    mpTemplateDatas.add(templateData);
                }
            }
        }
        return mpTemplateDatas;
    }
}

