/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.async.redis.consumer;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.msg.async.redis.condition.RedisCondition;
import com.jxdinfo.hussar.msg.async.redis.util.RedisReceiverUtil;
import com.jxdinfo.hussar.msg.send.dto.MsgUnitySendDto;
import com.jxdinfo.hussar.msg.send.service.MsgUnitySendFrameService;
import com.jxdinfo.hussar.msg.sms.dto.SmsSendRecordDto;
import com.jxdinfo.hussar.msg.sms.third.service.SmsPushService;
import com.jxdinfo.hussar.support.mq.annotation.HussarMQMessageHandler;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={RedisCondition.class})
public class SmsConsumer {
    @Autowired
    private SmsPushService smsPushService;
    @Autowired
    private MsgUnitySendFrameService smsUnitySendServiceImpl;
    private static final Logger logger = LoggerFactory.getLogger(SmsConsumer.class);

    @HussarMQMessageHandler(key="sms_message")
    public void onMessage(String message) {
        try {
            logger.info("appImConsumer of redis receive message\uff1a{}", (Object)message);
            RedisReceiverUtil.preHandle(message);
            String dtoName = Optional.ofNullable(JSON.parseObject((String)message).getString("dtoName")).orElse("");
            if ("MsgUnitySendDto".equals(dtoName)) {
                MsgUnitySendDto msgUnitySendDto = (MsgUnitySendDto)JSON.parseObject((String)message, MsgUnitySendDto.class);
                this.smsUnitySendServiceImpl.msgUnitySendBefore(msgUnitySendDto);
            } else {
                SmsSendRecordDto record = (SmsSendRecordDto)JSON.parseObject((String)message, SmsSendRecordDto.class);
                boolean b = this.smsPushService.sendMsg(record);
                logger.info("msg sms res:{}", (Object)b);
            }
        }
        catch (Exception e) {
            logger.error("\u77ed\u4fe1\u6d88\u606f\u5904\u7406\u9519\u8bef", (Throwable)e);
        }
    }
}

