/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.async.redis.consumer;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.msg.async.redis.condition.RedisCondition;
import com.jxdinfo.hussar.msg.async.redis.util.RedisReceiverUtil;
import com.jxdinfo.hussar.msg.mp.dto.MpSendRecordDto;
import com.jxdinfo.hussar.msg.mp.third.service.MpSendMsgThirdService;
import com.jxdinfo.hussar.msg.send.dto.MsgUnitySendDto;
import com.jxdinfo.hussar.msg.send.service.MsgUnitySendFrameService;
import com.jxdinfo.hussar.support.mq.annotation.HussarMQMessageHandler;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={RedisCondition.class})
public class MpConsumer {
    @Autowired(required=false)
    private MpSendMsgThirdService mpSendMsgThirdService;
    @Autowired
    private MsgUnitySendFrameService mpUnitySendServiceImpl;
    private static final Logger logger = LoggerFactory.getLogger(MpConsumer.class);

    @HussarMQMessageHandler(key="mp_message")
    public void onMessage(String message) {
        try {
            logger.info("MpConsumer of redis receive message\uff1a{}", (Object)message);
            RedisReceiverUtil.preHandle(message);
            String dtoName = Optional.ofNullable(JSON.parseObject((String)message).getString("dtoName")).orElse("");
            if ("MsgUnitySendDto".equals(dtoName)) {
                MsgUnitySendDto msgUnitySendDto = (MsgUnitySendDto)JSON.parseObject((String)message, MsgUnitySendDto.class);
                this.mpUnitySendServiceImpl.msgUnitySendBefore(msgUnitySendDto);
            } else {
                MpSendRecordDto info = (MpSendRecordDto)JSON.parseObject((String)message, MpSendRecordDto.class);
                this.mpSendMsgThirdService.sendMpTimMsg(info);
            }
        }
        catch (Exception e) {
            logger.error("\u516c\u4f17\u53f7\u6d88\u606f\u5904\u7406\u9519\u8bef", (Throwable)e);
        }
    }
}

