/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.async.redis.consumer;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.msg.appim.dto.AppImSendRecordDto;
import com.jxdinfo.hussar.msg.appim.third.service.AppImPushThirdService;
import com.jxdinfo.hussar.msg.async.redis.condition.RedisCondition;
import com.jxdinfo.hussar.msg.async.redis.util.RedisReceiverUtil;
import com.jxdinfo.hussar.msg.common.enums.AppImMsgTypeEnum;
import com.jxdinfo.hussar.msg.send.dto.MsgUnitySendDto;
import com.jxdinfo.hussar.msg.send.service.MsgUnitySendFrameService;
import com.jxdinfo.hussar.support.mq.annotation.HussarMQMessageHandler;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={RedisCondition.class})
public class AppImConsumer {
    @Autowired
    private MsgUnitySendFrameService appImUnitySendServiceImpl;
    @Autowired(required=false)
    private AppImPushThirdService appImPushThirdService;
    private static final Logger logger = LoggerFactory.getLogger(AppImConsumer.class);

    @HussarMQMessageHandler(key="app_im_message")
    public void onMessage(String message) {
        try {
            logger.info("appImConsumer of redis receive message\uff1a{}", (Object)message);
            RedisReceiverUtil.preHandle(message);
            String dtoName = Optional.ofNullable(JSON.parseObject((String)message).getString("dtoName")).orElse("");
            if ("MsgUnitySendDto".equals(dtoName)) {
                MsgUnitySendDto msgUnitySendDto = (MsgUnitySendDto)JSON.parseObject((String)message, MsgUnitySendDto.class);
                this.appImUnitySendServiceImpl.msgUnitySendBefore(msgUnitySendDto);
            } else {
                AppImSendRecordDto record = (AppImSendRecordDto)JSON.parseObject((String)message, AppImSendRecordDto.class);
                switch (AppImMsgTypeEnum.getByCode((Integer)record.getType())) {
                    case TEXT: {
                        this.appImPushThirdService.sendTextTimMsg(record);
                        break;
                    }
                    case ARTICLE: {
                        this.appImPushThirdService.sendArticleTimMsg(record);
                        break;
                    }
                    case IMG: {
                        this.appImPushThirdService.sendImgTimMsg(record);
                        break;
                    }
                    case FILE: {
                        this.appImPushThirdService.sendFileTimMsg(record);
                        break;
                    }
                    default: {
                        logger.error("\u9519\u8bef\u7684app_im\u6d88\u606f\u7c7b\u578b");
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("app_im\u6d88\u606f\u5904\u7406\u9519\u8bef", (Throwable)e);
        }
    }
}

