/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.async.redis.consumer;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.msg.async.redis.condition.RedisCondition;
import com.jxdinfo.hussar.msg.async.redis.util.RedisReceiverUtil;
import com.jxdinfo.hussar.msg.mail.dto.MailSendRecordDto;
import com.jxdinfo.hussar.msg.mail.third.service.MailPushThirdService;
import com.jxdinfo.hussar.msg.send.dto.MsgUnitySendDto;
import com.jxdinfo.hussar.msg.send.service.MsgUnitySendFrameService;
import com.jxdinfo.hussar.support.mq.annotation.HussarMQMessageHandler;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={RedisCondition.class})
public class MailConsumer {
    @Autowired
    private MailPushThirdService mailPushThirdService;
    @Autowired
    private MsgUnitySendFrameService mailUnitySendServiceImpl;
    private static final Logger logger = LoggerFactory.getLogger(MailConsumer.class);

    @HussarMQMessageHandler(key="mail_message")
    public void onMessage(String message) {
        try {
            logger.info("MailConsumer of redis receive message\uff1a{}", (Object)message);
            RedisReceiverUtil.preHandle(message);
            String dtoName = Optional.ofNullable(JSON.parseObject((String)message).getString("dtoName")).orElse("");
            if ("MsgUnitySendDto".equals(dtoName)) {
                MsgUnitySendDto msgUnitySendDto = (MsgUnitySendDto)JSON.parseObject((String)message, MsgUnitySendDto.class);
                this.mailUnitySendServiceImpl.msgUnitySendBefore(msgUnitySendDto);
            } else {
                MailSendRecordDto record = (MailSendRecordDto)JSON.parseObject((String)message, MailSendRecordDto.class);
                if (record.getBath().booleanValue()) {
                    this.mailPushThirdService.bathSend(record);
                } else {
                    this.mailPushThirdService.send(record);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u90ae\u4ef6\u670d\u52a1\u6d88\u606f\u5904\u7406\u9519\u8bef", (Throwable)e);
        }
    }
}

