/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.async.redis.consumer;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.msg.async.redis.condition.RedisCondition;
import com.jxdinfo.hussar.msg.async.redis.util.RedisReceiverUtil;
import com.jxdinfo.hussar.msg.dingtalk.dto.DingTalkSendRecordDto;
import com.jxdinfo.hussar.msg.dingtalk.third.service.DingTalkThirdService;
import com.jxdinfo.hussar.msg.send.dto.MsgUnitySendDto;
import com.jxdinfo.hussar.msg.send.service.MsgUnitySendFrameService;
import com.jxdinfo.hussar.support.mq.annotation.HussarMQMessageHandler;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={RedisCondition.class})
public class DingTalkConsumer {
    @Autowired(required=false)
    private DingTalkThirdService dingTalkThirdService;
    @Autowired
    private MsgUnitySendFrameService dingTalkUnitySendServiceImpl;
    private static final Logger logger = LoggerFactory.getLogger(DingTalkConsumer.class);

    @HussarMQMessageHandler(key="ding_talk_message")
    public void onMessage(String message) {
        try {
            logger.info("DingTalkConsumer of redis receive message\uff1a{}", (Object)message);
            RedisReceiverUtil.preHandle(message);
            String dtoName = Optional.ofNullable(JSON.parseObject((String)message).getString("dtoName")).orElse("");
            if ("MsgUnitySendDto".equals(dtoName)) {
                MsgUnitySendDto msgUnitySendDto = (MsgUnitySendDto)JSON.parseObject((String)message, MsgUnitySendDto.class);
                this.dingTalkUnitySendServiceImpl.msgUnitySendBefore(msgUnitySendDto);
            } else {
                DingTalkSendRecordDto info = (DingTalkSendRecordDto)JSON.parseObject((String)message, DingTalkSendRecordDto.class);
                this.dingTalkThirdService.sendDingTalkTimMsg(info);
            }
        }
        catch (Exception e) {
            logger.error("\u9489\u9489\u6d88\u606f\u5904\u7406\u9519\u8bef", (Throwable)e);
        }
    }
}

