/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.async.redis.consumer;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.msg.apppush.dto.AppPushSendRecordDto;
import com.jxdinfo.hussar.msg.apppush.third.service.AppPushThirdService;
import com.jxdinfo.hussar.msg.async.redis.condition.RedisCondition;
import com.jxdinfo.hussar.msg.async.redis.util.RedisReceiverUtil;
import com.jxdinfo.hussar.msg.send.dto.MsgUnitySendDto;
import com.jxdinfo.hussar.msg.send.service.MsgUnitySendFrameService;
import com.jxdinfo.hussar.support.mq.annotation.HussarMQMessageHandler;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={RedisCondition.class})
public class AppPushConsumer {
    @Autowired(required=false)
    private AppPushThirdService appPushThirdService;
    @Autowired
    private MsgUnitySendFrameService appPushUnitySendServiceImpl;
    private static final Logger logger = LoggerFactory.getLogger(AppPushConsumer.class);

    @HussarMQMessageHandler(key="app_push_message")
    public void onMessage(String message) {
        try {
            logger.info("AppPushConsumer of redis receive message\uff1a{}", (Object)message);
            RedisReceiverUtil.preHandle(message);
            String dtoName = Optional.ofNullable(JSON.parseObject((String)message).getString("dtoName")).orElse("");
            if ("MsgUnitySendDto".equals(dtoName)) {
                MsgUnitySendDto msgUnitySendDto = (MsgUnitySendDto)JSON.parseObject((String)message, MsgUnitySendDto.class);
                this.appPushUnitySendServiceImpl.msgUnitySendBefore(msgUnitySendDto);
            } else {
                AppPushSendRecordDto appPushSendRecord = (AppPushSendRecordDto)JSON.parseObject((String)message, AppPushSendRecordDto.class);
                boolean b = this.appPushThirdService.sendPushTimMsg(appPushSendRecord);
                logger.info("msg apppush res:{}", (Object)b);
            }
        }
        catch (Exception e) {
            logger.error("app\u63a8\u9001\u6d88\u606f\u5904\u7406\u9519\u8bef", (Throwable)e);
        }
    }
}

