/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.async.redis.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.platform.core.http.HussarHttpServletRequest;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import java.util.Locale;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class RedisReceiverUtil {
    public static void preHandle(String message) {
        JSONObject msgObj = JSON.parseObject((String)message);
        String tcode = Optional.ofNullable(msgObj.getString("tenantCode")).orElse("");
        HussarContextHolder.setTenant((String)"1", (String)tcode);
        String language = msgObj.getString("language");
        if (HussarUtils.isNotEmpty((Object)language)) {
            String[] split = language.split("-");
            Locale defaultLocale = new Locale(split[0], split[1]);
            Locale.setDefault(defaultLocale);
        }
        HussarHttpServletRequest hussarHttpServletRequest = new HussarHttpServletRequest();
        hussarHttpServletRequest.addHeader("Accept-Language", language);
        hussarHttpServletRequest.addHeader("tcode", tcode);
        RequestContextHolder.setRequestAttributes((RequestAttributes)new ServletRequestAttributes((HttpServletRequest)hussarHttpServletRequest));
    }
}

