/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.async.redis.consumer;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.msg.async.redis.condition.RedisCondition;
import com.jxdinfo.hussar.msg.async.redis.util.RedisReceiverUtil;
import com.jxdinfo.hussar.msg.send.dto.MsgUnitySendDto;
import com.jxdinfo.hussar.msg.send.service.MsgUnitySendFrameService;
import com.jxdinfo.hussar.support.mq.annotation.HussarMQMessageHandler;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={RedisCondition.class})
public class StationConsumer {
    @Resource(name="com.jxdinfo.hussar.msg.station.impl.StationMsgUnitySendFrameServiceImpl")
    private MsgUnitySendFrameService msgUnitySendFrameService;
    private static final Logger logger = LoggerFactory.getLogger(StationConsumer.class);

    @HussarMQMessageHandler(key="station_message")
    public void onMessage(String message) {
        try {
            logger.info("StationConsumer of redis receive message\uff1a{}", (Object)message);
            RedisReceiverUtil.preHandle(message);
            MsgUnitySendDto msgUnitySendDto = (MsgUnitySendDto)JSON.parseObject((String)message, MsgUnitySendDto.class);
            this.msgUnitySendFrameService.msgUnitySendBefore(msgUnitySendDto);
        }
        catch (Exception e) {
            logger.error("\u7ad9\u5185\u4fe1\u6d88\u606f\u5904\u7406\u9519\u8bef", (Throwable)e);
        }
    }
}

