/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.async.redis.consumer;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.msg.async.redis.condition.RedisCondition;
import com.jxdinfo.hussar.msg.async.redis.util.RedisReceiverUtil;
import com.jxdinfo.hussar.msg.cp.dto.CpSendRecordDto;
import com.jxdinfo.hussar.msg.cp.third.service.MsgCpSendThirdService;
import com.jxdinfo.hussar.msg.send.dto.MsgUnitySendDto;
import com.jxdinfo.hussar.msg.send.service.MsgUnitySendFrameService;
import com.jxdinfo.hussar.support.mq.annotation.HussarMQMessageHandler;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={RedisCondition.class})
public class CpConsumer {
    @Autowired(required=false)
    private MsgCpSendThirdService cpSendThirdService;
    @Autowired
    private MsgUnitySendFrameService cpUnitySendServiceImpl;
    private static final Logger logger = LoggerFactory.getLogger(CpConsumer.class);

    @HussarMQMessageHandler(key="cp_message")
    public void onMessage(String message) {
        try {
            logger.info("CpConsumer of redis receive message\uff1a{}", (Object)message);
            RedisReceiverUtil.preHandle(message);
            String dtoName = Optional.ofNullable(JSON.parseObject((String)message).getString("dtoName")).orElse("");
            if ("MsgUnitySendDto".equals(dtoName)) {
                MsgUnitySendDto msgUnitySendDto = (MsgUnitySendDto)JSON.parseObject((String)message, MsgUnitySendDto.class);
                this.cpUnitySendServiceImpl.msgUnitySendBefore(msgUnitySendDto);
            } else {
                CpSendRecordDto info = (CpSendRecordDto)JSON.parseObject((String)message, CpSendRecordDto.class);
                this.cpSendThirdService.sendCpTimMsg(info);
            }
        }
        catch (Exception e) {
            logger.error("\u4f01\u4e1a\u5fae\u4fe1\u6d88\u606f\u5904\u7406\u9519\u8bef", (Throwable)e);
        }
    }
}

