/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.send.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.msg.common.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.common.model.ChannelsVo;
import com.jxdinfo.hussar.msg.common.utils.Strings;
import com.jxdinfo.hussar.msg.common.utils.TenantCodeUtils;
import com.jxdinfo.hussar.msg.factory.MsgSendExecutorFactory;
import com.jxdinfo.hussar.msg.send.decument.MsgSendRecordDocument;
import com.jxdinfo.hussar.msg.send.dto.MsgSendRecordQueryDto;
import com.jxdinfo.hussar.msg.send.dto.MsgSendStatisticsVo;
import com.jxdinfo.hussar.msg.send.model.MsgSendRecord;
import com.jxdinfo.hussar.msg.send.repository.MsgSendRecordRepository;
import com.jxdinfo.hussar.msg.send.service.MsgSendExecutor;
import com.jxdinfo.hussar.msg.send.service.MsgSendRecordService;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class MongoMsgSendRecordServiceImpl
implements MsgSendRecordService {
    @Autowired
    private MsgSendRecordRepository msgSendRecordRepository;
    @Autowired
    private MongoTemplate mongoTemplate;

    public void saveRecord(MsgSendRecord sendRecord) {
        MsgSendRecordDocument document = (MsgSendRecordDocument)((Object)BeanUtil.copy((Object)sendRecord, MsgSendRecordDocument.class));
        document.setTenantCode(HussarContextHolder.getHussarTenant().getTenantCode());
        this.msgSendRecordRepository.save((Object)document);
    }

    public Page<MsgSendRecord> listPage(Page<MsgSendRecord> page, MsgSendRecordQueryDto queryDto) {
        Query query = new Query();
        Criteria criteria = new Criteria();
        if (queryDto.getBeginTime() != null && queryDto.getEndTime() != null) {
            Criteria fromTime = Criteria.where((String)"createTime").gt((Object)queryDto.getBeginTime());
            Criteria toTime = Criteria.where((String)"createTime").lt((Object)queryDto.getEndTime());
            criteria.andOperator(new Criteria[]{fromTime, toTime});
        }
        TenantCodeUtils.fillCriteriaTenantCode((Criteria)criteria);
        if (HussarUtils.isNotEmpty((Object)queryDto.getAppName())) {
            criteria.and("appName").regex(Strings.format((String)"%s%s%s", (String)".*", (String)queryDto.getAppName(), (String)".*"));
        }
        if (HussarUtils.isNotEmpty((Object)queryDto.getChannelName())) {
            criteria.and("channelName").regex(Strings.format((String)"%s%s%s", (String)".*", (String)queryDto.getChannelName(), (String)".*"));
        }
        if (HussarUtils.isNotEmpty((Object)queryDto.getSceneName())) {
            criteria.and("sceneName").regex(Strings.format((String)"%s%s%s", (String)".*", (String)queryDto.getSceneName(), (String)".*"));
        }
        if (queryDto.getStatus() != null) {
            criteria.and("status").is((Object)queryDto.getStatus());
        }
        if (queryDto.getBusinessId() != null) {
            criteria.and("businessId").is((Object)queryDto.getBusinessId());
        }
        if (queryDto.getTitle() != null) {
            criteria.and("title").regex(Strings.format((String)"%s%s%s", (String)".*", (String)queryDto.getTitle(), (String)".*"));
        }
        if (queryDto.getContent() != null) {
            criteria.and("content").regex(Strings.format((String)"%s%s%s", (String)".*", (String)queryDto.getContent(), (String)".*"));
        }
        query.addCriteria((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"createTime")}));
        long total = this.mongoTemplate.count(query, MsgSendRecordDocument.class);
        query.skip((page.getCurrent() - 1L) * page.getSize());
        query.limit((int)page.getSize());
        List list = this.mongoTemplate.find(query, MsgSendRecordDocument.class);
        List msgSendRecords = BeanUtil.copyProperties((Collection)list, MsgSendRecord.class);
        Page pages = new Page();
        pages.setCurrent(page.getCurrent());
        pages.setSize(page.getSize());
        pages.setTotal(total);
        pages.setRecords(msgSendRecords);
        return pages;
    }

    public List<MsgSendStatisticsVo> sendStatistics(MsgSendRecordQueryDto queryDto) {
        ArrayList<MsgSendStatisticsVo> result = new ArrayList<MsgSendStatisticsVo>();
        Criteria criteria = new Criteria();
        if (queryDto.getBeginTime() != null && queryDto.getEndTime() != null) {
            Criteria fromTime = Criteria.where((String)"createTime").gt((Object)queryDto.getBeginTime());
            Criteria toTime = Criteria.where((String)"createTime").lt((Object)queryDto.getEndTime());
            criteria.andOperator(new Criteria[]{fromTime, toTime});
        }
        if (HussarUtils.isNotEmpty((Object)queryDto.getChannelNo())) {
            criteria.and("channelNo").is((Object)queryDto.getChannelNo());
        }
        TenantCodeUtils.fillCriteriaTenantCode((Criteria)criteria);
        Aggregation agg = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{"channelNo", "createDate", "status"}).count().as("count"), Aggregation.project((String[])new String[]{"channelNo", "createDate", "status", "count"})});
        AggregationResults aggregate = this.mongoTemplate.aggregate(agg, MsgSendRecordDocument.class, SendRecordAgg.class);
        List mappedResults = aggregate.getMappedResults();
        Map<String, String> channelNoAndName = this.getChannelNoAndName(queryDto.getSendType());
        channelNoAndName.put("00000000", "\u65e0\u901a\u9053\u6d88\u606f");
        for (SendRecordAgg mappedResult : mappedResults) {
            if (!HussarUtils.isEmpty((Object)mappedResult.getChannelNo())) continue;
            mappedResult.setChannelNo("00000000");
        }
        Map<String, List<SendRecordAgg>> listMap = mappedResults.parallelStream().collect(Collectors.groupingBy(SendRecordAgg::getChannelNo));
        List createDateList = mappedResults.parallelStream().map(SendRecordAgg::getCreateDate).distinct().sorted().collect(Collectors.toList());
        listMap.forEach((channelNo, aggs) -> {
            MsgSendStatisticsVo statisticsVo = new MsgSendStatisticsVo();
            statisticsVo.setChannelNo(channelNo);
            statisticsVo.setChannelName((String)channelNoAndName.get(channelNo));
            statisticsVo.setCreateDate(createDateList);
            ArrayList aggVos = new ArrayList();
            Map<String, Map<Integer, List<SendRecordAgg>>> collect = aggs.parallelStream().collect(Collectors.groupingBy(SendRecordAgg::getCreateDate, Collectors.groupingBy(SendRecordAgg::getStatus)));
            collect.forEach((createDate, aggs1) -> {
                MsgSendStatisticsVo.MsgUnifiedChannelSendStatisticAgg aggVo = new MsgSendStatisticsVo.MsgUnifiedChannelSendStatisticAgg();
                aggVo.setSendDate(createDate);
                aggs1.forEach((status, aggs2) -> {
                    if (status.equals(SendStatusEnum.SUCCESS.getCode())) {
                        aggVo.setSuccessCount(((SendRecordAgg)aggs2.get(0)).count);
                    } else if (status.equals(SendStatusEnum.FAIL.getCode())) {
                        aggVo.setFailCount(((SendRecordAgg)aggs2.get(0)).count);
                    } else if (status.equals(SendStatusEnum.SENDING.getCode())) {
                        aggVo.setWillCount(((SendRecordAgg)aggs2.get(0)).count);
                    }
                });
                aggVos.add(aggVo);
            });
            statisticsVo.setAggs(aggVos);
            result.add(statisticsVo);
        });
        return result;
    }

    private Map<String, String> getChannelNoAndName(String sendType) {
        MsgSendExecutor msgUnitySendService = MsgSendExecutorFactory.getSendExecutor((String)sendType);
        ArrayList allChannels = msgUnitySendService.getAllChannels();
        if (allChannels == null) {
            allChannels = new ArrayList();
        }
        return allChannels.stream().collect(Collectors.toMap(ChannelsVo::getChannelNo, ChannelsVo::getChannelName));
    }

    private static class SendRecordAgg {
        private String channelNo;
        private String createDate;
        private String channelName;
        private Integer status;
        private Long count;

        private SendRecordAgg() {
        }

        public String getChannelNo() {
            return this.channelNo;
        }

        public void setChannelNo(String channelNo) {
            this.channelNo = channelNo;
        }

        public String getCreateDate() {
            return this.createDate;
        }

        public void setCreateDate(String createDate) {
            this.createDate = createDate;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public Long getCount() {
            return this.count;
        }

        public void setCount(Long count) {
            this.count = count;
        }

        public String getChannelName() {
            return this.channelName;
        }

        public void setChannelName(String channelName) {
            this.channelName = channelName;
        }
    }
}

