/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.notice.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.msg.common.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.common.utils.Strings;
import com.jxdinfo.hussar.msg.common.utils.TenantCodeUtils;
import com.jxdinfo.hussar.msg.notice.config.mongodb.repository.NoticeSendRecordRepository;
import com.jxdinfo.hussar.msg.notice.dto.NoticeInfoPageDto;
import com.jxdinfo.hussar.msg.notice.dto.NoticeSendRecordDto;
import com.jxdinfo.hussar.msg.notice.mongodb.document.NoticeSendRecordDocument;
import com.jxdinfo.hussar.msg.notice.service.NoticeSendRecordService;
import com.jxdinfo.hussar.msg.notice.vo.NoticeSendRecordQueryVo;
import com.jxdinfo.hussar.msg.notice.vo.NoticeSendStatisticsVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class NoticeSendRecordMongodbServiceImpl
implements NoticeSendRecordService {
    @Autowired
    private NoticeSendRecordRepository noticeSendRecordRepository;
    @Autowired
    private MongoTemplate mongoTemplate;

    public NoticeSendRecordQueryVo findById(String id) {
        Optional entity = this.noticeSendRecordRepository.findById(id);
        return entity.map(this::entity2QueryVo).orElse(new NoticeSendRecordQueryVo());
    }

    public IPage<NoticeSendRecordDto> listPage(Page pageable, NoticeInfoPageDto noticeInfoPageDto) {
        Query query = new Query();
        Criteria criteria = new Criteria();
        if (noticeInfoPageDto.getBeginTime() != null && noticeInfoPageDto.getEndTime() != null) {
            Criteria fromTime = Criteria.where((String)"createTime").gte((Object)noticeInfoPageDto.getBeginTime());
            Criteria toTime = Criteria.where((String)"createTime").lte((Object)new Date(noticeInfoPageDto.getEndTime().getTime() / 1000L * 1000L + 999L));
            criteria.andOperator(new Criteria[]{fromTime, toTime});
        }
        if (ToolUtil.isNotEmpty((Object)noticeInfoPageDto.getAppName())) {
            criteria.and("appName").regex(Strings.format((String)"%s%s%s", (String)".*", (String)noticeInfoPageDto.getAppName().trim(), (String)".*"));
        }
        if (ToolUtil.isNotEmpty((Object)noticeInfoPageDto.getNoticeTitle())) {
            String reges = Strings.format((String)"%s%s%s", (String)"^.*", (String)noticeInfoPageDto.getNoticeTitle().trim(), (String)".*$");
            Pattern pattern = Pattern.compile(reges, 2);
            criteria.and("noticeTitle").regex(pattern);
        }
        if (noticeInfoPageDto.getStatus() != null) {
            criteria.and("status").is((Object)noticeInfoPageDto.getStatus());
        }
        if (noticeInfoPageDto.getNoticeTypeId() != null) {
            criteria.and("noticeTypeId").is((Object)noticeInfoPageDto.getNoticeTypeId());
        }
        if (HussarUtils.isNotEmpty((Object)noticeInfoPageDto.getSceneCode())) {
            criteria.and("sceneCode").regex(Strings.format((String)"%s%s%s", (String)".*", (String)noticeInfoPageDto.getSceneCode(), (String)".*"));
        }
        if (HussarUtils.isNotEmpty((Object)noticeInfoPageDto.getSceneName())) {
            criteria.and("sceneName").regex(Strings.format((String)"%s%s%s", (String)".*", (String)noticeInfoPageDto.getSceneName(), (String)".*"));
        }
        TenantCodeUtils.fillCriteriaTenantCode((Criteria)criteria);
        query.addCriteria((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"createTime")}));
        long total = this.mongoTemplate.count(query, NoticeSendRecordDocument.class);
        query.skip((pageable.getCurrent() - 1L) * pageable.getSize());
        query.limit((int)pageable.getSize());
        List list = this.mongoTemplate.find(query, NoticeSendRecordDocument.class);
        for (NoticeSendRecordDocument noticeSendRecordDocument : list) {
            if (!Objects.equals(noticeSendRecordDocument.getStatus(), SendStatusEnum.SUCCESS.getCode())) continue;
            noticeSendRecordDocument.setErrMsg("\u6210\u529f");
        }
        List pageList = list.stream().map(this::transferDto).collect(Collectors.toList());
        Page page = new Page();
        page.setCurrent(pageable.getCurrent());
        page.setSize(pageable.getSize());
        page.setTotal(total);
        page.setRecords(pageList);
        return page;
    }

    private NoticeSendRecordDto transferDto(NoticeSendRecordDocument noticeSendRecordDocument) {
        NoticeSendRecordDto dto = new NoticeSendRecordDto();
        BeanUtils.copyProperties((Object)((Object)noticeSendRecordDocument), (Object)dto);
        return dto;
    }

    public ApiResponse sendStatistics(Date beginTime, Date endTime, String channelNo) {
        Criteria criteria = new Criteria();
        if (beginTime != null && endTime != null) {
            Criteria fromTime = Criteria.where((String)"createTime").gt((Object)beginTime);
            Criteria toTime = Criteria.where((String)"createTime").lt((Object)endTime);
            criteria.andOperator(new Criteria[]{fromTime, toTime});
        }
        if (ToolUtil.isNotEmpty((Object)channelNo)) {
            criteria.and("noticeTypeId").is((Object)Long.parseLong(channelNo));
        }
        TenantCodeUtils.fillCriteriaTenantCode((Criteria)criteria);
        Aggregation agg = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{"noticeTypeId", "createDateNotHour", "status"}).count().as("count"), Aggregation.project((String[])new String[]{"noticeTypeId", "createDateNotHour", "status", "count"})});
        AggregationResults aggregate = this.mongoTemplate.aggregate(agg, NoticeSendRecordDocument.class, SendRecordAgg.class);
        List mappedResults = aggregate.getMappedResults();
        Map<String, List<SendRecordAgg>> listMap = mappedResults.parallelStream().filter(record -> HussarUtils.isNotEmpty((Object)record.getNoticeTypeId())).collect(Collectors.groupingBy(SendRecordAgg::getNoticeTypeId));
        List createDateList = mappedResults.parallelStream().map(SendRecordAgg::getCreateDateNotHour).distinct().sorted().collect(Collectors.toList());
        ArrayList result = new ArrayList();
        listMap.forEach((noticeTypeId, aggs) -> {
            NoticeSendStatisticsVo statisticsVo = new NoticeSendStatisticsVo();
            statisticsVo.setChannelNo(noticeTypeId);
            statisticsVo.setCreateDate(createDateList);
            ArrayList aggVos = new ArrayList();
            Map<String, Map<Integer, List<SendRecordAgg>>> collect = aggs.parallelStream().collect(Collectors.groupingBy(SendRecordAgg::getCreateDateNotHour, Collectors.groupingBy(SendRecordAgg::getStatus)));
            collect.forEach((createDateNotHour, aggs1) -> {
                NoticeSendStatisticsVo.NoticeSendStatisticAgg aggVo = new NoticeSendStatisticsVo.NoticeSendStatisticAgg();
                aggVo.setSendDate(createDateNotHour);
                aggs1.forEach((status, aggs2) -> {
                    if (status.equals(SendStatusEnum.SUCCESS.getCode())) {
                        aggVo.setSuccessCount(((SendRecordAgg)aggs2.get(0)).count);
                    } else if (status.equals(SendStatusEnum.FAIL.getCode())) {
                        aggVo.setFailCount(((SendRecordAgg)aggs2.get(0)).count);
                    } else if (status.equals(SendStatusEnum.SENDING.getCode())) {
                        aggVo.setWillCount(((SendRecordAgg)aggs2.get(0)).count);
                    }
                });
                aggVos.add(aggVo);
            });
            statisticsVo.setAggs(aggVos);
            result.add(statisticsVo);
        });
        return ApiResponse.success(result);
    }

    public void saveRecord(NoticeSendRecordDto noticeSendRecordDto) {
        this.noticeSendRecordRepository.save(HussarUtils.copy((Object)noticeSendRecordDto, NoticeSendRecordDocument.class));
    }

    private NoticeSendRecordQueryVo entity2QueryVo(NoticeSendRecordDocument entity) {
        NoticeSendRecordQueryVo vo = new NoticeSendRecordQueryVo();
        BeanUtils.copyProperties((Object)((Object)entity), (Object)vo);
        return vo;
    }

    public static class SendRecordAgg {
        private String createDateNotHour;
        private String createDate;
        private Date createTime;
        private Long count;
        private Integer status;
        private String noticeTypeId;

        public String getNoticeTypeId() {
            return this.noticeTypeId;
        }

        public void setNoticeTypeId(String noticeTypeId) {
            this.noticeTypeId = noticeTypeId;
        }

        public Date getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(Date createTime) {
            this.createTime = createTime;
        }

        public String getCreateDateNotHour() {
            return this.createDateNotHour;
        }

        public void setCreateDateNotHour(String createDateNotHour) {
            this.createDateNotHour = createDateNotHour;
        }

        public Long getCount() {
            return this.count;
        }

        public void setCount(Long count) {
            this.count = count;
        }

        public String getCreateDate() {
            return this.createDate;
        }

        public void setCreateDate(String createDate) {
            this.createDate = createDate;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }
    }
}

