/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.mail.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.msg.common.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.common.model.ChannelsVo;
import com.jxdinfo.hussar.msg.common.utils.Strings;
import com.jxdinfo.hussar.msg.common.utils.TenantCodeUtils;
import com.jxdinfo.hussar.msg.mail.config.mongodb.repository.MailSendRecordRepository;
import com.jxdinfo.hussar.msg.mail.dto.MailSendRecordDto;
import com.jxdinfo.hussar.msg.mail.dto.MsgMailSendRecordPageDto;
import com.jxdinfo.hussar.msg.mail.mongodb.document.MailSendRecordDocument;
import com.jxdinfo.hussar.msg.mail.service.MsgMailChannelService;
import com.jxdinfo.hussar.msg.mail.service.MsgMailSendRecordService;
import com.jxdinfo.hussar.msg.mail.vo.MailChannelSendStatisticsVo;
import com.jxdinfo.hussar.msg.mail.vo.MsgMailSendRecordQueryVo;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class MsgMailSendRecordMongodbServiceImpl
implements MsgMailSendRecordService {
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private MsgMailChannelService msgMailChannelService;
    @Autowired
    private MailSendRecordRepository mailSendRecordRepository;

    public IPage<MailSendRecordDto> listPage(Page page, MsgMailSendRecordPageDto pageDto) {
        Query query = new Query();
        Criteria criteria = new Criteria();
        Criteria reciverCriteria = null;
        Criteria channelCriteria = null;
        if (pageDto.getBeginTime() != null && pageDto.getEndTime() != null) {
            Criteria fromTime = Criteria.where((String)"createTime").gte((Object)pageDto.getBeginTime());
            Criteria toTime = Criteria.where((String)"createTime").lte((Object)new Date(pageDto.getEndTime().getTime() / 1000L * 1000L + 999L));
            criteria.andOperator(new Criteria[]{fromTime, toTime});
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getAppName())) {
            criteria.and("appName").regex(Strings.format((String)"%s%s%s", (String)".*", (String)pageDto.getAppName(), (String)".*"));
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getReciverName())) {
            reciverCriteria = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"reciverName").regex(Strings.format((String)"%s%s%s", (String)".*", (String)pageDto.getReciverName().trim(), (String)".*")), Criteria.where((String)"reciverMail").regex(Strings.format((String)"%s%s%s", (String)".*", (String)pageDto.getReciverName().trim(), (String)".*"))});
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getReciverMail())) {
            criteria.and("reciverMail").regex(Strings.format((String)"%s%s%s", (String)".*", (String)pageDto.getReciverMail(), (String)".*"));
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getMailContent())) {
            criteria.and("mailContent").regex(Strings.format((String)"%s%s%s", (String)".*", (String)pageDto.getMailContent(), (String)".*"));
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getMailSubject())) {
            criteria.and("mailSubject").regex(Strings.format((String)"%s%s%s", (String)".*", (String)pageDto.getMailSubject(), (String)".*"));
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getSceneCode())) {
            criteria.and("sceneCode").regex(Strings.format((String)"%s%s%s", (String)".*", (String)pageDto.getSceneCode(), (String)".*"));
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getSceneName())) {
            criteria.and("sceneName").regex(Strings.format((String)"%s%s%s", (String)".*", (String)pageDto.getSceneName(), (String)".*"));
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getChannelName())) {
            channelCriteria = new Criteria().orOperator(new Criteria[]{Criteria.where((String)"channelName").regex(Strings.format((String)"%s%s%s", (String)".*", (String)pageDto.getChannelName(), (String)".*")), Criteria.where((String)"channelNo").regex(Strings.format((String)"%s%s%s", (String)".*", (String)pageDto.getChannelName(), (String)".*"))});
        }
        if (pageDto.getStatus() != null) {
            criteria.and("status").is((Object)pageDto.getStatus());
        }
        if (reciverCriteria != null && channelCriteria != null) {
            criteria.andOperator(new Criteria[]{reciverCriteria, channelCriteria});
        } else if (reciverCriteria != null) {
            criteria.andOperator(new Criteria[]{reciverCriteria});
        } else if (channelCriteria != null) {
            criteria.andOperator(new Criteria[]{channelCriteria});
        }
        TenantCodeUtils.fillCriteriaTenantCode((Criteria)criteria);
        query.addCriteria((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"createTime")}));
        long total = this.mongoTemplate.count(query, MailSendRecordDocument.class);
        query.skip((page.getCurrent() - 1L) * page.getSize());
        query.limit((int)page.getSize());
        List list = this.mongoTemplate.find(query, MailSendRecordDocument.class);
        list.forEach(e -> {
            if (HussarUtils.isNotEmpty((Object)e.getReciverMail())) {
                e.setReciverMail(Arrays.stream(e.getReciverMail().split(";")).map(o -> o.replaceAll("(\\S{2})\\S*(@)(\\S*)", "$1****$2$3")).collect(Collectors.joining(";")));
            }
        });
        List pageList = list.stream().map(this::transferDto).collect(Collectors.toList());
        Page resutlPage = new Page();
        resutlPage.setCurrent(page.getCurrent());
        resutlPage.setSize(page.getSize());
        resutlPage.setTotal(total);
        resutlPage.setRecords(pageList);
        return resutlPage;
    }

    private MailSendRecordDto transferDto(MailSendRecordDocument mailSendRecordDocument) {
        MailSendRecordDto dto = new MailSendRecordDto();
        BeanUtils.copyProperties((Object)((Object)mailSendRecordDocument), (Object)dto);
        return dto;
    }

    public MailSendRecordDto findById(String id) {
        Optional entity = this.mailSendRecordRepository.findById(id);
        MailSendRecordDto dto = new MailSendRecordDto();
        if (!entity.isPresent()) {
            return null;
        }
        MailSendRecordDocument mailSendRecordDocument = (MailSendRecordDocument)((Object)entity.get());
        BeanUtils.copyProperties((Object)((Object)mailSendRecordDocument), (Object)dto);
        return dto;
    }

    public boolean saveRecord(MailSendRecordDto mailSendRecordDto) {
        if (SendStatusEnum.SUCCESS.getCode().equals(mailSendRecordDto.getStatus()) && HussarUtils.isNotEmpty((Object)mailSendRecordDto.getErrorContactInfos())) {
            mailSendRecordDto.setErrMsg("\u90e8\u5206\u53d1\u9001\u6210\u529f\uff0c\u4ee5\u4e0b\u8054\u7cfb\u4eba\u65e0\u6cd5\u53d1\u9001\uff1a" + String.join((CharSequence)"\uff1b", mailSendRecordDto.getErrorContactInfos()));
        }
        MailSendRecordDocument entity = new MailSendRecordDocument();
        BeanUtils.copyProperties((Object)mailSendRecordDto, (Object)((Object)entity));
        this.mailSendRecordRepository.save((Object)entity);
        return true;
    }

    public List<MailChannelSendStatisticsVo> sendStatistics(MsgMailSendRecordQueryVo queryDto) {
        Criteria criteria = new Criteria();
        if (queryDto.getBeginTime() != null && queryDto.getEndTime() != null) {
            Criteria fromTime = Criteria.where((String)"createTime").gt((Object)queryDto.getBeginTime());
            Criteria toTime = Criteria.where((String)"createTime").lt((Object)queryDto.getEndTime());
            criteria.andOperator(new Criteria[]{fromTime, toTime});
        }
        if (HussarUtils.isNotEmpty((Object)queryDto.getChannelNo())) {
            criteria.and("channelNo").is((Object)queryDto.getChannelNo());
        }
        TenantCodeUtils.fillCriteriaTenantCode((Criteria)criteria);
        Aggregation agg = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{"channelNo", "createDate", "status", "channelName"}).count().as("count"), Aggregation.project((String[])new String[]{"channelNo", "createDate", "status", "channelName", "count"})});
        AggregationResults aggregate = this.mongoTemplate.aggregate(agg, MailSendRecordDocument.class, SendRecordAgg.class);
        List mappedResults = aggregate.getMappedResults();
        List channelNos = mappedResults.parallelStream().map(SendRecordAgg::getChannelNo).distinct().collect(Collectors.toList());
        Map channelNoAndName = this.msgMailChannelService.getChannelNoAndName(channelNos);
        Map<String, List<SendRecordAgg>> listMap = mappedResults.parallelStream().collect(Collectors.groupingBy(SendRecordAgg::getChannelNo));
        List createDateList = mappedResults.parallelStream().map(SendRecordAgg::getCreateDate).distinct().sorted().collect(Collectors.toList());
        ArrayList<MailChannelSendStatisticsVo> result = new ArrayList<MailChannelSendStatisticsVo>();
        listMap.forEach((channelNo, aggs) -> {
            MailChannelSendStatisticsVo statisticsVo = new MailChannelSendStatisticsVo();
            statisticsVo.setChannelNo(channelNo);
            statisticsVo.setChannelName((String)channelNoAndName.get(channelNo));
            statisticsVo.setCreateDate(createDateList);
            ArrayList aggVos = new ArrayList();
            Map<String, Map<Integer, List<SendRecordAgg>>> collect = aggs.parallelStream().collect(Collectors.groupingBy(SendRecordAgg::getCreateDate, Collectors.groupingBy(SendRecordAgg::getStatus)));
            collect.forEach((createDate, aggs1) -> {
                MailChannelSendStatisticsVo.MailChannelSendStatisticAgg aggVo = new MailChannelSendStatisticsVo.MailChannelSendStatisticAgg();
                aggVo.setSendDate(createDate);
                aggs1.forEach((status, aggs2) -> {
                    if (status.equals(SendStatusEnum.SUCCESS.getCode())) {
                        aggVo.setSuccessCount(((SendRecordAgg)aggs2.get(0)).count);
                    } else if (status.equals(SendStatusEnum.FAIL.getCode())) {
                        aggVo.setFailCount(((SendRecordAgg)aggs2.get(0)).count);
                    } else if (status.equals(SendStatusEnum.SENDING.getCode())) {
                        aggVo.setWillCount(((SendRecordAgg)aggs2.get(0)).count);
                    }
                });
                aggVos.add(aggVo);
            });
            statisticsVo.setAggs(aggVos);
            result.add(statisticsVo);
        });
        return result;
    }

    public List<ChannelsVo> getAllChannels() {
        Aggregation agg = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.group((String[])new String[]{"channelNo", "channelName"}), Aggregation.project((String[])new String[]{"channelNo", "channelName"})});
        List mappedResults = this.mongoTemplate.aggregate(agg, MailSendRecordDocument.class, ChannelsVo.class).getMappedResults();
        Map channelNoAndName = this.msgMailChannelService.getChannelNoAndName(mappedResults.stream().map(ChannelsVo::getChannelNo).collect(Collectors.toList()));
        for (ChannelsVo channelsVo : mappedResults) {
            channelsVo.setChannelName((String)channelNoAndName.get(channelsVo.getChannelNo()));
        }
        return mappedResults;
    }

    public static class SendRecordAgg {
        private String channelNo;
        private String channelName;
        private String createDate;
        private Integer status;
        private Long count;

        public String getChannelNo() {
            return this.channelNo;
        }

        public String getChannelName() {
            return this.channelName;
        }

        public void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        public void setChannelNo(String channelNo) {
            this.channelNo = channelNo;
        }

        public String getCreateDate() {
            return this.createDate;
        }

        public void setCreateDate(String createDate) {
            this.createDate = createDate;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public Long getCount() {
            return this.count;
        }

        public void setCount(Long count) {
            this.count = count;
        }
    }
}

