/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.dingtalk.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.msg.common.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.common.model.ChannelsVo;
import com.jxdinfo.hussar.msg.common.utils.ContactInfoEncryptUtils;
import com.jxdinfo.hussar.msg.common.utils.Strings;
import com.jxdinfo.hussar.msg.common.utils.TenantCodeUtils;
import com.jxdinfo.hussar.msg.dingtalk.config.mongodb.repository.DingTalkSendRecordRepository;
import com.jxdinfo.hussar.msg.dingtalk.dto.DingTalkRecordDto;
import com.jxdinfo.hussar.msg.dingtalk.dto.DingTalkSendRecordDto;
import com.jxdinfo.hussar.msg.dingtalk.mongodb.document.DingTalkSendRecordDocument;
import com.jxdinfo.hussar.msg.dingtalk.service.DingTalkChannelService;
import com.jxdinfo.hussar.msg.dingtalk.service.DingTalkSendRecordService;
import com.jxdinfo.hussar.msg.dingtalk.vo.DingTalkChSendStatisticsVo;
import com.jxdinfo.hussar.msg.dingtalk.vo.DingTalkSendRecordVo;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class DingTalkSendRecordMongodbServiceImpl
implements DingTalkSendRecordService {
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private DingTalkSendRecordRepository dingTalkSendRecordRepository;
    @Autowired
    private DingTalkChannelService dingTalkChannelService;

    public IPage<DingTalkSendRecordVo> listPage(Page page, DingTalkRecordDto pageDto) {
        Query query = new Query();
        Criteria criteria = new Criteria();
        if (pageDto.getBeginTime() != null && pageDto.getEndTime() != null) {
            Criteria fromTime = Criteria.where((String)"createTime").gte((Object)pageDto.getBeginTime());
            Criteria toTime = Criteria.where((String)"createTime").lte((Object)new Date(pageDto.getEndTime().getTime() / 1000L * 1000L + 999L));
            criteria.andOperator(new Criteria[]{fromTime, toTime});
        }
        TenantCodeUtils.fillCriteriaTenantCode((Criteria)criteria);
        if (pageDto.getToUser() != null) {
            criteria.and("toUser").is((Object)pageDto.getToUser());
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getAppName())) {
            criteria.and("appName").regex(Strings.format((String)"%s%s%s", (String)".*", (String)pageDto.getAppName(), (String)".*"));
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getChannelName())) {
            criteria.orOperator(new Criteria[]{Criteria.where((String)"channelName").regex(Strings.format((String)"%s%s%s", (String)".*", (String)pageDto.getChannelName(), (String)".*")), Criteria.where((String)"channelNo").regex(Strings.format((String)"%s%s%s", (String)".*", (String)pageDto.getChannelName(), (String)".*"))});
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getSceneCode())) {
            criteria.and("sceneCode").regex(Strings.format((String)"%s%s%s", (String)".*", (String)pageDto.getSceneCode(), (String)".*"));
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getSceneName())) {
            criteria.and("sceneName").regex(Strings.format((String)"%s%s%s", (String)".*", (String)pageDto.getSceneName(), (String)".*"));
        }
        if (pageDto.getStatus() != null) {
            criteria.and("status").is((Object)pageDto.getStatus());
        }
        if (pageDto.getContent() != null) {
            String reges = Strings.format((String)"%s%s%s", (String)"^.*", (String)pageDto.getContent().trim(), (String)".*$");
            Pattern pattern = Pattern.compile(reges, 2);
            criteria.and("content").regex(pattern);
        }
        if (pageDto.getCorpName() != null) {
            criteria.and("corpName").regex(Strings.format((String)"%s%s%s", (String)".*", (String)pageDto.getCorpName(), (String)".*"));
        }
        if (pageDto.getDingAppName() != null) {
            criteria.and("dingAppName").regex(Strings.format((String)"%s%s%s", (String)".*", (String)pageDto.getDingAppName(), (String)".*"));
        }
        query.addCriteria((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"createTime")}));
        long total = this.mongoTemplate.count(query, DingTalkSendRecordDocument.class);
        query.skip((page.getCurrent() - 1L) * page.getSize());
        query.limit((int)page.getSize());
        List list = this.mongoTemplate.find(query, DingTalkSendRecordDocument.class);
        List pageList = list.stream().map(this::transferDto).collect(Collectors.toList());
        for (DingTalkSendRecordVo dingTalkSendRecordVo : pageList) {
            dingTalkSendRecordVo.setToUser(ContactInfoEncryptUtils.receiveAddressEncrypt((String)dingTalkSendRecordVo.getToUser()));
        }
        Page pages = new Page();
        pages.setCurrent(page.getCurrent());
        pages.setSize(page.getSize());
        pages.setTotal(total);
        pages.setRecords(pageList);
        return pages;
    }

    private DingTalkSendRecordVo transferDto(DingTalkSendRecordDocument dingTalkSendRecordDocument) {
        DingTalkSendRecordVo dingTalkSendRecordVo = new DingTalkSendRecordVo();
        BeanUtils.copyProperties((Object)((Object)dingTalkSendRecordDocument), (Object)dingTalkSendRecordVo);
        return dingTalkSendRecordVo;
    }

    public List<DingTalkChSendStatisticsVo> sendStatistics(DingTalkRecordDto pageDto) {
        Criteria criteria = new Criteria();
        if (pageDto.getBeginTime() != null && pageDto.getEndTime() != null) {
            Criteria fromTime = Criteria.where((String)"createTime").gt((Object)pageDto.getBeginTime());
            Criteria toTime = Criteria.where((String)"createTime").lt((Object)pageDto.getEndTime());
            criteria.andOperator(new Criteria[]{fromTime, toTime});
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getChannelNo())) {
            criteria.and("channelNo").is((Object)pageDto.getChannelNo());
        }
        TenantCodeUtils.fillCriteriaTenantCode((Criteria)criteria);
        Aggregation agg = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{"channelNo", "createDate", "status", "channelName"}).count().as("count"), Aggregation.project((String[])new String[]{"channelNo", "createDate", "status", "channelName", "count"})});
        AggregationResults aggregate = this.mongoTemplate.aggregate(agg, DingTalkSendRecordDocument.class, SendRecordAgg.class);
        List mappedResults = aggregate.getMappedResults();
        List channelNos = mappedResults.parallelStream().map(SendRecordAgg::getChannelNo).distinct().collect(Collectors.toList());
        Map channelNoAndName = this.dingTalkChannelService.getChannelNoAndName(new ArrayList(channelNos));
        Map<String, List<SendRecordAgg>> listMap = mappedResults.parallelStream().collect(Collectors.groupingBy(SendRecordAgg::getChannelNo));
        List createDateList = mappedResults.parallelStream().map(SendRecordAgg::getCreateDate).distinct().sorted().collect(Collectors.toList());
        ArrayList<DingTalkChSendStatisticsVo> result = new ArrayList<DingTalkChSendStatisticsVo>();
        listMap.forEach((channelNo, aggs) -> {
            DingTalkChSendStatisticsVo statisticsVo = new DingTalkChSendStatisticsVo();
            statisticsVo.setChannelNo(channelNo);
            statisticsVo.setChannelName((String)channelNoAndName.get(channelNo));
            statisticsVo.setCreateDate(createDateList);
            ArrayList aggVos = new ArrayList();
            Map<String, Map<Integer, List<SendRecordAgg>>> collect = aggs.parallelStream().collect(Collectors.groupingBy(SendRecordAgg::getCreateDate, Collectors.groupingBy(SendRecordAgg::getStatus)));
            collect.forEach((createTime, aggs1) -> {
                DingTalkChSendStatisticsVo.DingTalkChannelSendStatisticAgg aggVo = new DingTalkChSendStatisticsVo.DingTalkChannelSendStatisticAgg();
                aggVo.setSendDate(createTime);
                aggs1.forEach((status, aggs2) -> {
                    if (status.equals(SendStatusEnum.SUCCESS.getCode())) {
                        aggVo.setSuccessCount(((SendRecordAgg)aggs2.get(0)).count);
                    } else if (status.equals(SendStatusEnum.FAIL.getCode())) {
                        aggVo.setFailCount(((SendRecordAgg)aggs2.get(0)).count);
                    } else if (status.equals(SendStatusEnum.SENDING.getCode())) {
                        aggVo.setWillCount(((SendRecordAgg)aggs2.get(0)).count);
                    }
                });
                aggVos.add(aggVo);
            });
            statisticsVo.setAggs(aggVos);
            result.add(statisticsVo);
        });
        return result;
    }

    public DingTalkSendRecordVo findById(String id) {
        DingTalkSendRecordDocument dingTalkSendRecordDocument = this.dingTalkSendRecordRepository.findById(id).orElse(new DingTalkSendRecordDocument());
        return (DingTalkSendRecordVo)HussarUtils.copy((Object)((Object)dingTalkSendRecordDocument), DingTalkSendRecordVo.class);
    }

    public void saveRecord(DingTalkSendRecordDto dingTalkSendRecordDto) {
        if (SendStatusEnum.SUCCESS.getCode().equals(dingTalkSendRecordDto.getStatus()) && HussarUtils.isNotEmpty((Object)dingTalkSendRecordDto.getErrorContactInfos())) {
            dingTalkSendRecordDto.setErrMsg("\u90e8\u5206\u53d1\u9001\u6210\u529f\uff0c\u4ee5\u4e0b\u8054\u7cfb\u4eba\u65e0\u6cd5\u53d1\u9001\uff1a" + String.join((CharSequence)"\uff1b", dingTalkSendRecordDto.getErrorContactInfos()));
        }
        this.dingTalkSendRecordRepository.save(HussarUtils.copy((Object)dingTalkSendRecordDto, DingTalkSendRecordDocument.class));
    }

    public List<ChannelsVo> getAllChannels() {
        Aggregation agg = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.group((String[])new String[]{"channelNo", "channelName"}), Aggregation.project((String[])new String[]{"channelNo", "channelName"})});
        List mappedResults = this.mongoTemplate.aggregate(agg, DingTalkSendRecordDocument.class, ChannelsVo.class).getMappedResults();
        Map channelNoAndName = this.dingTalkChannelService.getChannelNoAndName(mappedResults.stream().map(ChannelsVo::getChannelNo).collect(Collectors.toList()));
        for (ChannelsVo channelsVo : mappedResults) {
            channelsVo.setChannelName((String)channelNoAndName.get(channelsVo.getChannelNo()));
        }
        return mappedResults;
    }

    public static class SendRecordAgg {
        private String channelNo;
        private String channelName;
        private String createDate;
        private Integer status;
        private Long count;

        public String getChannelNo() {
            return this.channelNo;
        }

        public String getChannelName() {
            return this.channelName;
        }

        public void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        public void setChannelNo(String channelNo) {
            this.channelNo = channelNo;
        }

        public String getCreateDate() {
            return this.createDate;
        }

        public void setCreateDate(String createDate) {
            this.createDate = createDate;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public Long getCount() {
            return this.count;
        }

        public void setCount(Long count) {
            this.count = count;
        }
    }
}

