/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.apppush.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.msg.apppush.config.mongodb.repository.AppPushSendRecordRepository;
import com.jxdinfo.hussar.msg.apppush.dto.AppPushSendRecordDto;
import com.jxdinfo.hussar.msg.apppush.dto.AppPushSendRecordPageDto;
import com.jxdinfo.hussar.msg.apppush.dto.AppPushSendRecordQueryDto;
import com.jxdinfo.hussar.msg.apppush.mongodb.document.AppPushSendRecordDocument;
import com.jxdinfo.hussar.msg.apppush.service.AppPushChannelService;
import com.jxdinfo.hussar.msg.apppush.service.AppPushSendRecordService;
import com.jxdinfo.hussar.msg.apppush.vo.AppPushChannelSendStatisticsVo;
import com.jxdinfo.hussar.msg.apppush.vo.AppPushSendRecordQueryVo;
import com.jxdinfo.hussar.msg.apppush.vo.AppPushSendRecordVo;
import com.jxdinfo.hussar.msg.common.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.common.model.ChannelsVo;
import com.jxdinfo.hussar.msg.common.utils.ContactInfoEncryptUtils;
import com.jxdinfo.hussar.msg.common.utils.Strings;
import com.jxdinfo.hussar.msg.common.utils.TenantCodeUtils;
import com.jxdinfo.hussar.platform.core.utils.DateUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class AppPushSendRecordMongodbServiceImpl
implements AppPushSendRecordService {
    private static final Logger logger = LoggerFactory.getLogger(AppPushSendRecordMongodbServiceImpl.class);
    @Autowired
    private AppPushChannelService msgAppChannelService;
    @Autowired
    private AppPushSendRecordRepository msgAppInfoRepository;
    @Autowired
    private MongoTemplate mongoTemplate;

    public IPage<AppPushSendRecordVo> listPage(Page pageable, AppPushSendRecordPageDto pageDto) {
        Query query = new Query();
        Criteria criteria = new Criteria();
        if (pageDto.getBeginTime() != null && pageDto.getEndTime() != null) {
            Criteria fromTime = Criteria.where((String)"createTime").gte((Object)pageDto.getBeginTime());
            Criteria toTime = Criteria.where((String)"createTime").lte((Object)new Date(pageDto.getEndTime().getTime() / 1000L * 1000L + 999L));
            criteria.andOperator(new Criteria[]{fromTime, toTime});
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getMsgAppName())) {
            criteria.and("msgAppName").regex(Strings.format((String)"%s%s%s", (String)".*", (String)pageDto.getMsgAppName(), (String)".*"));
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getChannelName())) {
            criteria.and("channelName").regex(Strings.format((String)"%s%s%s", (String)".*", (String)pageDto.getChannelName(), (String)".*"));
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getChannelNo())) {
            criteria.and("channelNo").regex(Strings.format((String)"%s%s%s", (String)".*", (String)pageDto.getChannelNo(), (String)".*"));
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getTitle())) {
            criteria.and("title").regex(Strings.format((String)"%s%s%s", (String)".*", (String)pageDto.getTitle(), (String)".*"));
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getContent())) {
            criteria.and("content").regex(Strings.format((String)"%s%s%s", (String)".*", (String)pageDto.getContent(), (String)".*"));
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getSceneCode())) {
            criteria.and("sceneCode").regex(Strings.format((String)"%s%s%s", (String)".*", (String)pageDto.getSceneCode(), (String)".*"));
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getSceneName())) {
            criteria.and("sceneName").regex(Strings.format((String)"%s%s%s", (String)".*", (String)pageDto.getSceneName(), (String)".*"));
        }
        if (pageDto.getStatus() != null) {
            criteria.and("status").is((Object)pageDto.getStatus());
        }
        TenantCodeUtils.fillCriteriaTenantCode((Criteria)criteria);
        query.addCriteria((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"createTime")}));
        long total = this.mongoTemplate.count(query, AppPushSendRecordDocument.class);
        query.skip((pageable.getCurrent() - 1L) * pageable.getSize());
        query.limit((int)pageable.getSize());
        List list = this.mongoTemplate.find(query, AppPushSendRecordDocument.class);
        List pageList = list.stream().map(this::transferDto).collect(Collectors.toList());
        for (AppPushSendRecordVo appPushSendRecordVo : pageList) {
            appPushSendRecordVo.setTokenList(ContactInfoEncryptUtils.receiveAddressEncrypt((String)appPushSendRecordVo.getTokenList()));
        }
        Page page = new Page();
        page.setCurrent(pageable.getCurrent());
        page.setSize(pageable.getSize());
        page.setTotal(total);
        page.setRecords(pageList);
        return page;
    }

    private AppPushSendRecordVo transferDto(AppPushSendRecordDocument appPushSendRecordDocument) {
        AppPushSendRecordVo vo = new AppPushSendRecordVo();
        BeanUtils.copyProperties((Object)((Object)appPushSendRecordDocument), (Object)vo);
        return vo;
    }

    public AppPushSendRecordQueryVo findById(String id) {
        Optional entity = this.msgAppInfoRepository.findById(id);
        return entity.map(this::entity2QueryVo).orElse(null);
    }

    public List<ChannelsVo> getAllChannels() {
        Aggregation agg = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.group((String[])new String[]{"channelNo", "channelName"}), Aggregation.project((String[])new String[]{"channelNo", "channelName"})});
        List mappedResults = this.mongoTemplate.aggregate(agg, AppPushSendRecordDocument.class, ChannelsVo.class).getMappedResults();
        Map channelNoAndName = this.msgAppChannelService.getChannelNoAndName(mappedResults.stream().map(ChannelsVo::getChannelNo).collect(Collectors.toList()));
        for (ChannelsVo channelsVo : mappedResults) {
            channelsVo.setChannelName((String)channelNoAndName.get(channelsVo.getChannelNo()));
        }
        return mappedResults;
    }

    public List<AppPushChannelSendStatisticsVo> sendStatistics(AppPushSendRecordQueryDto queryDto) {
        Criteria criteria = new Criteria();
        if (queryDto.getBeginTime() != null && queryDto.getEndTime() != null) {
            Criteria fromTime = Criteria.where((String)"createTime").gt((Object)queryDto.getBeginTime());
            Criteria toTime = Criteria.where((String)"createTime").lt((Object)queryDto.getEndTime());
            criteria.andOperator(new Criteria[]{fromTime, toTime});
        }
        if (HussarUtils.isNotEmpty((Object)queryDto.getChannelNo())) {
            criteria.and("channelNo").is((Object)queryDto.getChannelNo());
        }
        TenantCodeUtils.fillCriteriaTenantCode((Criteria)criteria);
        Aggregation agg = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{"channelNo", "createTime", "status", "channelName"}).count().as("count"), Aggregation.project((String[])new String[]{"channelNo", "createTime", "status", "channelName", "count"})});
        AggregationResults aggregate = this.mongoTemplate.aggregate(agg, AppPushSendRecordDocument.class, SendRecordAgg.class);
        List mappedResults = aggregate.getMappedResults();
        List channelNos = mappedResults.parallelStream().map(SendRecordAgg::getChannelNo).distinct().collect(Collectors.toList());
        Map channelNoAndName = this.msgAppChannelService.getChannelNoAndName(channelNos);
        Map<String, List<SendRecordAgg>> listMap = mappedResults.parallelStream().collect(Collectors.groupingBy(SendRecordAgg::getChannelNo));
        LinkedList<String> createDateList = new LinkedList<String>();
        List dates = mappedResults.parallelStream().map(SendRecordAgg::getCreateTime).distinct().sorted().collect(Collectors.toList());
        for (Date date : dates) {
            createDateList.add(DateUtil.format((Date)date, (String)"yyyy-MM-dd"));
        }
        ArrayList<AppPushChannelSendStatisticsVo> result = new ArrayList<AppPushChannelSendStatisticsVo>();
        listMap.forEach((channelNo, aggs) -> {
            for (SendRecordAgg sendRecordAgg : aggs) {
                sendRecordAgg.setCreateDate(DateUtil.format((Date)sendRecordAgg.getCreateTime(), (String)"yyyy-MM-dd"));
            }
            AppPushChannelSendStatisticsVo statisticsVo = new AppPushChannelSendStatisticsVo();
            statisticsVo.setChannelNo(channelNo);
            statisticsVo.setChannelName((String)channelNoAndName.get(channelNo));
            statisticsVo.setCreateDate(createDateList.stream().distinct().collect(Collectors.toList()));
            aggs.parallelStream().collect(Collectors.groupingBy(SendRecordAgg::getChannelNo));
            ArrayList aggVos = new ArrayList();
            Map<String, Map<Integer, List<SendRecordAgg>>> collect = aggs.parallelStream().collect(Collectors.groupingBy(SendRecordAgg::getCreateDate, Collectors.groupingBy(SendRecordAgg::getStatus)));
            collect.forEach((createDate, aggs1) -> {
                AppPushChannelSendStatisticsVo.AppPushChannelSendStatisticAgg aggVo = new AppPushChannelSendStatisticsVo.AppPushChannelSendStatisticAgg();
                aggVo.setSendDate(createDate);
                aggs1.forEach((status, aggs2) -> {
                    Long num = Long.parseLong("0");
                    for (SendRecordAgg sendRecordAgg : aggs2) {
                        num = num + sendRecordAgg.getCount();
                    }
                    if (status.equals(SendStatusEnum.SUCCESS.getCode())) {
                        aggVo.setSuccessCount(num);
                    } else if (status.equals(SendStatusEnum.FAIL.getCode())) {
                        aggVo.setFailCount(num);
                    } else if (status.equals(SendStatusEnum.SENDING.getCode())) {
                        aggVo.setWillCount(num);
                    }
                });
                aggVos.add(aggVo);
            });
            statisticsVo.setAggs(aggVos);
            result.add(statisticsVo);
        });
        return result;
    }

    public void saveRecord(AppPushSendRecordDto appPushSendRecordDto) {
        if (SendStatusEnum.SUCCESS.getCode().equals(appPushSendRecordDto.getStatus()) && HussarUtils.isNotEmpty((Object)appPushSendRecordDto.getErrorContactInfos())) {
            appPushSendRecordDto.setErrMsg("\u90e8\u5206\u53d1\u9001\u6210\u529f\uff0c\u4ee5\u4e0b\u8054\u7cfb\u4eba\u65e0\u6cd5\u53d1\u9001\uff1a" + String.join((CharSequence)"\uff1b", appPushSendRecordDto.getErrorContactInfos()));
        }
        this.msgAppInfoRepository.save(HussarUtils.copy((Object)appPushSendRecordDto, AppPushSendRecordDocument.class));
    }

    private AppPushSendRecordQueryVo entity2QueryVo(AppPushSendRecordDocument entity) {
        AppPushSendRecordQueryVo vo = new AppPushSendRecordQueryVo();
        BeanUtils.copyProperties((Object)((Object)entity), (Object)vo);
        return vo;
    }

    public static class SendRecordAgg {
        private String channelNo;
        private String channelName;
        private String createDate;
        private Date createTime;
        private Integer status;
        private Long count;

        public Date getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(Date createTime) {
            this.createTime = createTime;
        }

        public String getChannelNo() {
            return this.channelNo;
        }

        public void setChannelNo(String channelNo) {
            this.channelNo = channelNo;
        }

        public String getCreateDate() {
            return this.createDate;
        }

        public void setCreateDate(String createDate) {
            this.createDate = createDate;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public Long getCount() {
            return this.count;
        }

        public void setCount(Long count) {
            this.count = count;
        }

        public String getChannelName() {
            return this.channelName;
        }

        public void setChannelName(String channelName) {
            this.channelName = channelName;
        }
    }
}

