/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.appim.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.msg.appim.config.mongodb.repository.AppImSendRecordRepository;
import com.jxdinfo.hussar.msg.appim.dto.AppImChannelSendStatisticsVo;
import com.jxdinfo.hussar.msg.appim.dto.AppImSendRecordDto;
import com.jxdinfo.hussar.msg.appim.dto.AppImSendRecordQueryDto;
import com.jxdinfo.hussar.msg.appim.mongodb.document.AppImSendRecordDocument;
import com.jxdinfo.hussar.msg.appim.service.AppImChannelService;
import com.jxdinfo.hussar.msg.appim.service.AppImSendRecordService;
import com.jxdinfo.hussar.msg.appim.vo.AppImSendRecordVo;
import com.jxdinfo.hussar.msg.common.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.common.model.ChannelsVo;
import com.jxdinfo.hussar.msg.common.utils.ContactInfoEncryptUtils;
import com.jxdinfo.hussar.msg.common.utils.Strings;
import com.jxdinfo.hussar.msg.common.utils.TenantCodeUtils;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class AppImSendRecordMongodbServiceImpl
implements AppImSendRecordService {
    @Autowired(required=false)
    private MongoTemplate mongoTemplate;
    @Autowired(required=false)
    private AppImSendRecordRepository appImSendRecordRepository;
    @Autowired
    private AppImChannelService appImChannelService;

    public IPage<AppImSendRecordVo> listPage(Page<AppImSendRecordVo> pageable, AppImSendRecordQueryDto queryDto) {
        Query query = new Query();
        Criteria criteria = new Criteria();
        if (queryDto.getBeginTime() != null && queryDto.getEndTime() != null) {
            Criteria fromTime = Criteria.where((String)"createTime").gte((Object)queryDto.getBeginTime());
            Criteria toTime = Criteria.where((String)"createTime").lte((Object)new Date(queryDto.getEndTime().getTime() / 1000L * 1000L + 999L));
            criteria.andOperator(new Criteria[]{fromTime, toTime});
        }
        if (HussarUtils.isNotEmpty((Object)queryDto.getAppName())) {
            criteria.and("appName").regex(Strings.format((String)"%s%s%s", (String)".*", (String)queryDto.getAppName(), (String)".*"));
        }
        if (HussarUtils.isNotEmpty((Object)queryDto.getChannelName())) {
            criteria.orOperator(new Criteria[]{Criteria.where((String)"channelName").regex(Strings.format((String)"%s%s%s", (String)".*", (String)queryDto.getChannelName().trim(), (String)".*")), Criteria.where((String)"channelNo").regex(Strings.format((String)"%s%s%s", (String)".*", (String)queryDto.getChannelName().trim(), (String)".*"))});
        }
        if (HussarUtils.isNotEmpty((Object)queryDto.getChannelNo())) {
            criteria.and("channelNo").regex(Strings.format((String)"%s%s%s", (String)".*", (String)queryDto.getChannelNo(), (String)".*"));
        }
        if (HussarUtils.isNotEmpty((Object)queryDto.getSceneCode())) {
            criteria.and("sceneCode").regex(Strings.format((String)"%s%s%s", (String)".*", (String)queryDto.getSceneCode(), (String)".*"));
        }
        if (HussarUtils.isNotEmpty((Object)queryDto.getSceneName())) {
            criteria.and("sceneName").regex(Strings.format((String)"%s%s%s", (String)".*", (String)queryDto.getSceneName(), (String)".*"));
        }
        if (queryDto.getStatus() != null) {
            criteria.and("status").is((Object)queryDto.getStatus());
        }
        if (queryDto.getType() != null) {
            criteria.and("type").is((Object)queryDto.getType());
        }
        TenantCodeUtils.fillCriteriaTenantCode((Criteria)criteria);
        query.addCriteria((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"createTime")}));
        long total = this.mongoTemplate.count(query, AppImSendRecordDocument.class);
        query.skip((pageable.getCurrent() - 1L) * pageable.getSize());
        query.limit((int)pageable.getSize());
        List list = this.mongoTemplate.find(query, AppImSendRecordDocument.class);
        List pageList = list.stream().map(this::transferDto).collect(Collectors.toList());
        for (AppImSendRecordVo appImSendRecordVo : pageList) {
            appImSendRecordVo.setUserIds(ContactInfoEncryptUtils.receiveAddressEncrypt((String)appImSendRecordVo.getUserIds()));
        }
        Page page = new Page();
        page.setCurrent(pageable.getCurrent());
        page.setSize(pageable.getSize());
        page.setTotal(total);
        page.setRecords(pageList);
        return page;
    }

    public AppImSendRecordDto findById(String id) {
        Optional entity = this.appImSendRecordRepository.findById(id);
        if (!entity.isPresent()) {
            return null;
        }
        AppImSendRecordDocument appImSendRecordDocument = (AppImSendRecordDocument)((Object)entity.get());
        AppImSendRecordDto appImSendRecordDto = new AppImSendRecordDto();
        BeanUtils.copyProperties((Object)((Object)appImSendRecordDocument), (Object)appImSendRecordDto);
        return appImSendRecordDto;
    }

    public List<ChannelsVo> getAllChannels() {
        Aggregation agg = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.group((String[])new String[]{"channelNo", "channelName"}), Aggregation.project((String[])new String[]{"channelNo", "channelName"})});
        List mappedResults = this.mongoTemplate.aggregate(agg, AppImSendRecordDocument.class, ChannelsVo.class).getMappedResults();
        Map channelNoAndName = this.appImChannelService.getChannelNoAndName(mappedResults.stream().map(ChannelsVo::getChannelNo).collect(Collectors.toList()));
        for (ChannelsVo channelsVo : mappedResults) {
            channelsVo.setChannelName((String)channelNoAndName.get(channelsVo.getChannelNo()));
        }
        return mappedResults;
    }

    public List<AppImChannelSendStatisticsVo> sendStatistics(AppImSendRecordQueryDto queryDto) {
        Criteria criteria = new Criteria();
        if (queryDto.getBeginTime() != null && queryDto.getEndTime() != null) {
            Criteria fromTime = Criteria.where((String)"createTime").gt((Object)queryDto.getBeginTime());
            Criteria toTime = Criteria.where((String)"createTime").lt((Object)queryDto.getEndTime());
            criteria.andOperator(new Criteria[]{fromTime, toTime});
        }
        if (HussarUtils.isNotEmpty((Object)queryDto.getChannelNo())) {
            criteria.and("channelNo").is((Object)queryDto.getChannelNo());
        }
        TenantCodeUtils.fillCriteriaTenantCode((Criteria)criteria);
        Aggregation agg = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{"channelNo", "createDate", "status", "channelName"}).count().as("count"), Aggregation.project((String[])new String[]{"channelNo", "createDate", "status", "channelName", "count"})});
        AggregationResults aggregate = this.mongoTemplate.aggregate(agg, AppImSendRecordDocument.class, SendRecordAgg.class);
        List mappedResults = aggregate.getMappedResults();
        List channelNos = mappedResults.parallelStream().map(SendRecordAgg::getChannelNo).distinct().collect(Collectors.toList());
        Map channelNoAndName = this.appImChannelService.getChannelNoAndName(channelNos);
        Map<String, List<SendRecordAgg>> listMap = mappedResults.parallelStream().collect(Collectors.groupingBy(SendRecordAgg::getChannelNo));
        List createDateList = mappedResults.parallelStream().map(SendRecordAgg::getCreateDate).distinct().sorted().collect(Collectors.toList());
        ArrayList<AppImChannelSendStatisticsVo> result = new ArrayList<AppImChannelSendStatisticsVo>();
        listMap.forEach((channelNo, aggs) -> {
            AppImChannelSendStatisticsVo statisticsVo = new AppImChannelSendStatisticsVo();
            statisticsVo.setChannelNo(channelNo);
            statisticsVo.setChannelName((String)channelNoAndName.get(channelNo));
            statisticsVo.setCreateDate(createDateList);
            ArrayList aggVos = new ArrayList();
            Map<String, Map<Integer, List<SendRecordAgg>>> collect = aggs.parallelStream().collect(Collectors.groupingBy(SendRecordAgg::getCreateDate, Collectors.groupingBy(SendRecordAgg::getStatus)));
            collect.forEach((createDate, aggs1) -> {
                AppImChannelSendStatisticsVo.AppImChannelSendStatisticAgg aggVo = new AppImChannelSendStatisticsVo.AppImChannelSendStatisticAgg();
                aggVo.setSendDate(createDate);
                aggs1.forEach((status, aggs2) -> {
                    if (status.equals(SendStatusEnum.SUCCESS.getCode())) {
                        aggVo.setSuccessCount(((SendRecordAgg)aggs2.get(0)).count);
                    } else if (status.equals(SendStatusEnum.FAIL.getCode())) {
                        aggVo.setFailCount(((SendRecordAgg)aggs2.get(0)).count);
                    } else if (status.equals(SendStatusEnum.SENDING.getCode())) {
                        aggVo.setWillCount(((SendRecordAgg)aggs2.get(0)).count);
                    }
                });
                aggVos.add(aggVo);
            });
            statisticsVo.setAggs(aggVos);
            result.add(statisticsVo);
        });
        return result;
    }

    public boolean saveRecord(AppImSendRecordDto appImSendRecordDto) {
        if (SendStatusEnum.SUCCESS.getCode().equals(appImSendRecordDto.getStatus()) && HussarUtils.isNotEmpty((Object)appImSendRecordDto.getErrorContactInfos())) {
            appImSendRecordDto.setErrMsg("\u90e8\u5206\u53d1\u9001\u6210\u529f\uff0c\u4ee5\u4e0b\u8054\u7cfb\u4eba\u65e0\u6cd5\u53d1\u9001\uff1a" + String.join((CharSequence)"\uff1b", appImSendRecordDto.getErrorContactInfos()));
        }
        AppImSendRecordDocument appImSendRecordDocument = new AppImSendRecordDocument();
        HussarUtils.copy((Object)appImSendRecordDto, (Object)((Object)appImSendRecordDocument));
        return HussarUtils.isNotEmpty((Object)this.appImSendRecordRepository.save((Object)appImSendRecordDocument));
    }

    private AppImSendRecordVo transferDto(AppImSendRecordDocument appImSendRecordDocument) {
        AppImSendRecordVo appImSendRecordVo = new AppImSendRecordVo();
        BeanUtils.copyProperties((Object)((Object)appImSendRecordDocument), (Object)appImSendRecordVo);
        return appImSendRecordVo;
    }

    public static class SendRecordAgg {
        private String channelNo;
        private String channelName;
        private String createDate;
        private Integer status;
        private Long count;

        public String getChannelName() {
            return this.channelName;
        }

        public void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        public String getChannelNo() {
            return this.channelNo;
        }

        public void setChannelNo(String channelNo) {
            this.channelNo = channelNo;
        }

        public String getCreateDate() {
            return this.createDate;
        }

        public void setCreateDate(String createDate) {
            this.createDate = createDate;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public Long getCount() {
            return this.count;
        }

        public void setCount(Long count) {
            this.count = count;
        }
    }
}

