/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.sms.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.msg.common.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.common.model.ChannelsVo;
import com.jxdinfo.hussar.msg.common.utils.Strings;
import com.jxdinfo.hussar.msg.common.utils.TenantCodeUtils;
import com.jxdinfo.hussar.msg.sms.config.mongodb.repository.MsgSmsSendRecordRepository;
import com.jxdinfo.hussar.msg.sms.dto.SmsSendRecordDto;
import com.jxdinfo.hussar.msg.sms.dto.SmsSendRecordPageDto;
import com.jxdinfo.hussar.msg.sms.dto.SmsSendRecordQueryDto;
import com.jxdinfo.hussar.msg.sms.dto.SmsSendRecordStatisticsVo;
import com.jxdinfo.hussar.msg.sms.mongodb.document.MsgSmsSendRecordDocument;
import com.jxdinfo.hussar.msg.sms.service.SmsChannelService;
import com.jxdinfo.hussar.msg.sms.service.SmsSendRecordService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class SmsSendRecordMongodbServiceImpl
implements SmsSendRecordService {
    private static final Logger logger = LoggerFactory.getLogger(SmsSendRecordMongodbServiceImpl.class);
    @Autowired
    private MsgSmsSendRecordRepository msgSmsSendRecordRepository;
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private SmsChannelService smsChannelService;

    public Page<SmsSendRecordDto> listPage(Page pageable, SmsSendRecordPageDto pageDto) {
        Query query = new Query();
        Criteria criteria = new Criteria();
        if (pageDto.getBeginTime() != null && pageDto.getEndTime() != null) {
            Criteria fromTime = Criteria.where((String)"createTime").gte((Object)pageDto.getBeginTime());
            Criteria toTime = Criteria.where((String)"createTime").lte((Object)new Date(pageDto.getEndTime().getTime() / 1000L * 1000L + 999L));
            criteria.andOperator(new Criteria[]{fromTime, toTime});
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getAppName())) {
            criteria.and("appName").regex(Strings.format((String)"%s%s%s", (String)".*", (String)pageDto.getAppName(), (String)".*"));
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getPhoneNumber())) {
            criteria.and("phoneNumber").regex(Strings.format((String)"%s%s%s", (String)".*", (String)pageDto.getPhoneNumber(), (String)".*"));
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getChannelNo())) {
            criteria.and("channelNo").regex(Strings.format((String)"%s%s%s", (String)".*", (String)pageDto.getChannelNo(), (String)".*"));
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getChannelName())) {
            criteria.and("channelName").regex(Strings.format((String)"%s%s%s", (String)".*", (String)pageDto.getChannelName(), (String)".*"));
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getSignNo())) {
            criteria.and("signNo").regex(Strings.format((String)"%s%s%s", (String)".*", (String)pageDto.getSignNo(), (String)".*"));
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getSignName())) {
            criteria.and("signName").regex(Strings.format((String)"%s%s%s", (String)".*", (String)pageDto.getSignName(), (String)".*"));
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getTemplateNo())) {
            criteria.and("templateNo").regex(Strings.format((String)"%s%s%s", (String)".*", (String)pageDto.getTemplateNo(), (String)".*"));
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getTemplateName())) {
            criteria.and("templateName").regex(Strings.format((String)"%s%s%s", (String)".*", (String)pageDto.getTemplateName(), (String)".*"));
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getSceneCode())) {
            criteria.and("sceneCode").regex(Strings.format((String)"%s%s%s", (String)".*", (String)pageDto.getSceneCode(), (String)".*"));
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getSceneName())) {
            criteria.and("sceneName").regex(Strings.format((String)"%s%s%s", (String)".*", (String)pageDto.getSceneName(), (String)".*"));
        }
        if (pageDto.getStatus() != null) {
            criteria.and("status").is((Object)pageDto.getStatus());
        }
        if (pageDto.getContent() != null) {
            String reges = Strings.format((String)"%s%s%s", (String)"^.*", (String)pageDto.getContent().trim(), (String)".*$");
            Pattern pattern = Pattern.compile(reges, 2);
            criteria.and("content").regex(pattern);
        }
        TenantCodeUtils.fillCriteriaTenantCode((Criteria)criteria);
        query.addCriteria((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"createTime")}));
        long total = this.mongoTemplate.count(query, MsgSmsSendRecordDocument.class);
        query.skip((pageable.getCurrent() - 1L) * pageable.getSize());
        query.limit((int)pageable.getSize());
        List list = this.mongoTemplate.find(query, MsgSmsSendRecordDocument.class);
        list.forEach(e -> {
            if (HussarUtils.isNotEmpty((Object)e.getPhoneNumber())) {
                if (e.getPhoneNumber().length() == 11) {
                    e.setPhoneNumber(e.getPhoneNumber().replaceAll("(\\d{3})\\d{4}(\\d{4})", "$1****$2"));
                } else {
                    e.setPhoneNumber(e.getPhoneNumber().replaceAll("(\\d{3})(-?)\\d*(\\d{4})", "$1$2****$3"));
                }
            }
        });
        List pageList = list.stream().map(this::transferDto).collect(Collectors.toList());
        Page page = new Page();
        page.setCurrent(pageable.getCurrent());
        page.setSize(pageable.getSize());
        page.setTotal(total);
        page.setRecords(pageList);
        return page;
    }

    private SmsSendRecordDto transferDto(MsgSmsSendRecordDocument msgSmsSendRecordDocument) {
        SmsSendRecordDto dto = new SmsSendRecordDto();
        BeanUtils.copyProperties((Object)((Object)msgSmsSendRecordDocument), (Object)dto);
        return dto;
    }

    public SmsSendRecordDto findById(String id) {
        Optional entity = this.msgSmsSendRecordRepository.findById(id);
        return entity.map(this::entity2RecordDto).orElse(null);
    }

    public List<ChannelsVo> getAllChannels() {
        Aggregation agg = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.group((String[])new String[]{"channelNo", "channelName"}), Aggregation.project((String[])new String[]{"channelNo", "channelName"})});
        List mappedResults = this.mongoTemplate.aggregate(agg, MsgSmsSendRecordDocument.class, ChannelsVo.class).getMappedResults();
        Map channelNoAndName = this.smsChannelService.getChannelNoAndName(mappedResults.stream().map(ChannelsVo::getChannelNo).collect(Collectors.toList()));
        for (ChannelsVo channelsVo : mappedResults) {
            channelsVo.setChannelName((String)channelNoAndName.get(channelsVo.getChannelNo()));
        }
        return mappedResults;
    }

    public List<SmsSendRecordStatisticsVo> sendStatistics(SmsSendRecordQueryDto queryDto) {
        Criteria criteria = new Criteria();
        if (queryDto.getBeginTime() != null && queryDto.getEndTime() != null) {
            Criteria fromTime = Criteria.where((String)"createTime").gt((Object)queryDto.getBeginTime());
            Criteria toTime = Criteria.where((String)"createTime").lt((Object)queryDto.getEndTime());
            criteria.andOperator(new Criteria[]{fromTime, toTime});
        }
        if (HussarUtils.isNotEmpty((Object)queryDto.getChannelNo())) {
            criteria.and("channelNo").is((Object)queryDto.getChannelNo());
        }
        TenantCodeUtils.fillCriteriaTenantCode((Criteria)criteria);
        Aggregation agg = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{"channelNo", "createDate", "status", "channelName"}).count().as("count"), Aggregation.project((String[])new String[]{"channelNo", "createDate", "status", "channelName", "count"})});
        AggregationResults aggregate = this.mongoTemplate.aggregate(agg, MsgSmsSendRecordDocument.class, SendRecordAgg.class);
        List mappedResults = aggregate.getMappedResults();
        List channelNos = mappedResults.parallelStream().map(SendRecordAgg::getChannelNo).distinct().collect(Collectors.toList());
        Map channelNoAndName = this.smsChannelService.getChannelNoAndName(channelNos);
        Map<String, List<SendRecordAgg>> listMap = mappedResults.parallelStream().collect(Collectors.groupingBy(SendRecordAgg::getChannelNo));
        List createDateList = mappedResults.parallelStream().map(SendRecordAgg::getCreateDate).distinct().sorted().collect(Collectors.toList());
        ArrayList<SmsSendRecordStatisticsVo> result = new ArrayList<SmsSendRecordStatisticsVo>();
        listMap.forEach((channelNo, aggs) -> {
            SmsSendRecordStatisticsVo statisticsVo = new SmsSendRecordStatisticsVo();
            statisticsVo.setChannelNo(channelNo);
            statisticsVo.setChannelName((String)channelNoAndName.get(channelNo));
            statisticsVo.setCreateDate(createDateList);
            ArrayList aggVos = new ArrayList();
            Map<String, Map<Integer, List<SendRecordAgg>>> collect = aggs.parallelStream().collect(Collectors.groupingBy(SendRecordAgg::getCreateDate, Collectors.groupingBy(SendRecordAgg::getStatus)));
            collect.forEach((createDate, aggs1) -> {
                SmsSendRecordStatisticsVo.SmsChannelSendStatisticAgg aggVo = new SmsSendRecordStatisticsVo.SmsChannelSendStatisticAgg();
                aggVo.setSendDate(createDate);
                aggs1.forEach((status, aggs2) -> {
                    if (status.equals(SendStatusEnum.SUCCESS.getCode())) {
                        aggVo.setSuccessCount(((SendRecordAgg)aggs2.get(0)).count);
                    } else if (status.equals(SendStatusEnum.FAIL.getCode())) {
                        aggVo.setFailCount(((SendRecordAgg)aggs2.get(0)).count);
                    } else if (status.equals(SendStatusEnum.SENDING.getCode())) {
                        aggVo.setWillCount(((SendRecordAgg)aggs2.get(0)).count);
                    }
                });
                aggVos.add(aggVo);
            });
            statisticsVo.setAggs(aggVos);
            result.add(statisticsVo);
        });
        return result;
    }

    private SmsSendRecordDto entity2RecordDto(MsgSmsSendRecordDocument entity) {
        SmsSendRecordDto vo = new SmsSendRecordDto();
        if (entity != null) {
            BeanUtils.copyProperties((Object)((Object)entity), (Object)vo);
        }
        return vo;
    }

    public void save(SmsSendRecordDto recordDto) {
        if (SendStatusEnum.SUCCESS.getCode().equals(recordDto.getStatus()) && HussarUtils.isNotEmpty((Object)recordDto.getErrorContactInfos())) {
            recordDto.setErrMsg("\u90e8\u5206\u53d1\u9001\u6210\u529f\uff0c\u4ee5\u4e0b\u8054\u7cfb\u4eba\u65e0\u6cd5\u53d1\u9001\uff1a" + String.join((CharSequence)"\uff1b", recordDto.getErrorContactInfos()));
        }
        MsgSmsSendRecordDocument record = new MsgSmsSendRecordDocument();
        BeanUtils.copyProperties((Object)recordDto, (Object)((Object)record));
        this.msgSmsSendRecordRepository.save((Object)record);
    }

    public static class SendRecordAgg {
        private String channelNo;
        private String createDate;
        private String channelName;
        private Integer status;
        private Long count;

        public String getChannelNo() {
            return this.channelNo;
        }

        public void setChannelNo(String channelNo) {
            this.channelNo = channelNo;
        }

        public String getCreateDate() {
            return this.createDate;
        }

        public void setCreateDate(String createDate) {
            this.createDate = createDate;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public Long getCount() {
            return this.count;
        }

        public void setCount(Long count) {
            this.count = count;
        }

        public String getChannelName() {
            return this.channelName;
        }

        public void setChannelName(String channelName) {
            this.channelName = channelName;
        }
    }
}

