/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.station.impl;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.msg.common.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.station.document.MsgStationSendRecordDocument;
import com.jxdinfo.hussar.msg.station.dto.StationSendRecordDto;
import com.jxdinfo.hussar.msg.station.repository.MsgStationSendRecordRepository;
import com.jxdinfo.hussar.msg.station.service.IMsgStationTypeService;
import com.jxdinfo.hussar.msg.station.service.ISendClientMessage;
import com.jxdinfo.hussar.msg.station.service.IStationSendRecordService;
import com.jxdinfo.hussar.msg.station.vo.StationNoReadMsgVo;
import com.jxdinfo.hussar.platform.core.utils.ExceptionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IdUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.msg.station.impl.StationSendRecordMongodbServiceImpl")
public class StationSendRecordMongodbServiceImpl
implements IStationSendRecordService {
    private static final Logger LOGGER = LoggerFactory.getLogger(StationSendRecordMongodbServiceImpl.class);
    @Autowired
    private MsgStationSendRecordRepository msgStationSendRecordRepository;
    @Autowired(required=false)
    private ISendClientMessage sendClientMessage;
    @Resource
    private IMsgStationTypeService msgStationTypeService;

    private Map<String, String> getStationTypeMap() {
        return this.msgStationTypeService.getStationTypeMap();
    }

    public void save(StationSendRecordDto recordDto) {
        Long userSendId = recordDto.getUserSendId();
        String msgTitle = recordDto.getMsgTitle();
        String msgContent = recordDto.getMsgContent();
        String stationType = recordDto.getStationType();
        String msgWebUrl = recordDto.getMsgWebUrl();
        String msgMobileUrl = recordDto.getMsgMobileUrl();
        List receiverUserIds = recordDto.getReceiverUserIds();
        String tenantCode = recordDto.getTenantCode();
        String inputParams = recordDto.getInputParams();
        Integer status = recordDto.getStatus();
        HussarContextHolder.setTenant((String)"1", (String)tenantCode);
        String templateNo = recordDto.getTemplateNo();
        String templateName = recordDto.getTemplateName();
        String appId = recordDto.getAppId();
        String appName = recordDto.getAppName();
        String appSecret = recordDto.getAppSecret();
        String sceneName = recordDto.getSceneName();
        String sceneCode = recordDto.getSceneCode();
        String errMsg = recordDto.getErrMsg();
        HashSet reveiverIds = new HashSet();
        if (HussarUtils.isNotEmpty((Object)receiverUserIds)) {
            reveiverIds.addAll(receiverUserIds);
        }
        Date current = new Date();
        if (HussarUtils.isNotEmpty(reveiverIds)) {
            ArrayList<MsgStationSendRecordDocument> list = new ArrayList<MsgStationSendRecordDocument>();
            MsgStationSendRecordDocument document = null;
            Map<String, String> StationTypeMap = this.getStationTypeMap();
            for (Long uid : reveiverIds) {
                document = new MsgStationSendRecordDocument();
                document.setId(IdUtil.getSnowflakeNextId() + "");
                document.setAppId(appId);
                document.setAppName(appName);
                document.setAppSecret(appSecret);
                document.setTemplateName(templateName);
                document.setTemplateNo(templateNo);
                document.setSceneCode(sceneCode);
                document.setSceneName(sceneName);
                document.setMsgTitle(StringUtils.isNotBlank((CharSequence)msgTitle) ? msgTitle : msgContent);
                document.setStationType(stationType);
                document.setMsgWebUrl(msgWebUrl);
                document.setMsgMobileUrl(msgMobileUrl);
                document.setMsgStatus(SendStatusEnum.SUCCESS.getCode());
                document.setReadFlag("0");
                document.setUserSendId(userSendId);
                document.setUserReceiverId(uid);
                document.setSendTime(current);
                document.setTenantCode(StringUtils.isNotBlank((CharSequence)tenantCode) ? tenantCode : "0");
                document.setInputParams(inputParams);
                if (status != null && status.equals(SendStatusEnum.FAIL.getCode())) {
                    document.setMsgStatus(status);
                } else {
                    document.setMsgStatus(SendStatusEnum.SUCCESS.getCode());
                }
                document.setErrMsg(errMsg);
                if (this.sendClientMessage != null) {
                    StationNoReadMsgVo vo = new StationNoReadMsgVo();
                    vo.setSendTime(current);
                    vo.setMsgTitle(document.getMsgTitle());
                    vo.setStationRecordId(document.getId() + "");
                    vo.setStationType(stationType);
                    vo.setMsgWebUrl(document.getMsgWebUrl());
                    vo.setMsgMobileUrl(document.getMsgMobileUrl());
                    String showTitle = "\u3010" + StationTypeMap.get(vo.getStationType()) + "\u3011" + vo.getMsgTitle();
                    vo.setShowTitle(showTitle);
                    vo.setUserSendId(userSendId);
                    vo.setUserReceiverId(uid);
                    this.sendClientMessage.sendMessageOne(uid, JSON.toJSONString((Object)vo));
                }
                list.add(document);
            }
            try {
                this.msgStationSendRecordRepository.saveAll(list);
            }
            catch (Exception e) {
                LOGGER.error("\u6279\u91cf\u4fdd\u5b58\u7ad9\u5185\u4fe1\u8bb0\u5f55\u5931\u8d25", (Throwable)e);
                for (MsgStationSendRecordDocument temp : list) {
                    temp.setMsgStatus(SendStatusEnum.FAIL.getCode());
                    temp.setErrMsg(ExceptionUtil.getMessage((Throwable)e));
                }
                this.msgStationSendRecordRepository.saveAll(list);
            }
        } else {
            MsgStationSendRecordDocument record = new MsgStationSendRecordDocument();
            record.setMsgStatus(SendStatusEnum.FAIL.getCode());
            record.setErrMsg("\u65e0\u63a5\u6536\u4eba");
            record.setAppId(appId);
            record.setAppName(appName);
            record.setAppSecret(appSecret);
            record.setTemplateName(templateName);
            record.setTemplateNo(templateNo);
            record.setSceneCode(sceneCode);
            record.setSceneName(sceneName);
            record.setMsgTitle(StringUtils.isNotBlank((CharSequence)msgTitle) ? msgTitle : msgContent);
            record.setStationType(stationType);
            record.setMsgWebUrl(msgWebUrl);
            record.setMsgMobileUrl(msgMobileUrl);
            record.setMsgStatus(SendStatusEnum.SUCCESS.getCode());
            record.setReadFlag("0");
            record.setUserSendId(userSendId);
            record.setSendTime(current);
            record.setInputParams(inputParams);
            this.msgStationSendRecordRepository.save(record);
        }
    }
}

