/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.station.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.msg.common.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.station.document.MsgStationSendRecordDocument;
import com.jxdinfo.hussar.msg.station.dto.QueryStationHistoryMsgDto;
import com.jxdinfo.hussar.msg.station.service.IMsgStationActionService;
import com.jxdinfo.hussar.msg.station.service.IMsgStationTypeService;
import com.jxdinfo.hussar.msg.station.util.FormatUtil;
import com.jxdinfo.hussar.msg.station.vo.StationHistoryMsgVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.msg.station.impl.msgStationMongoActionServiceImpl")
public class MsgStationMongoActionServiceImpl
implements IMsgStationActionService {
    @Autowired(required=false)
    private MongoTemplate mongoTemplate;
    @Resource
    private IMsgStationTypeService msgStationTypeService;

    private Map<String, String> getStationTypeMap() {
        return this.msgStationTypeService.getStationTypeMap();
    }

    public ApiResponse<Page<StationHistoryMsgVo>> searchHistoryMsg(QueryStationHistoryMsgDto queryStationHistoryMsgDto) {
        long size = queryStationHistoryMsgDto.getSize();
        long current = queryStationHistoryMsgDto.getCurrent();
        Long userReceiverId = queryStationHistoryMsgDto.getUserReceiverId();
        String msgTitle = queryStationHistoryMsgDto.getMsgTitle();
        String tenantCode = queryStationHistoryMsgDto.getTenantCode();
        String stationType = queryStationHistoryMsgDto.getStationType();
        String readFlag = queryStationHistoryMsgDto.getReadFlag();
        Date sendTimeStart = queryStationHistoryMsgDto.getSendTimeStart();
        Date sendTimeEnd = queryStationHistoryMsgDto.getSendTimeEnd();
        Integer msgStatus = queryStationHistoryMsgDto.getMsgStatus();
        String appName = queryStationHistoryMsgDto.getAppName();
        String sceneName = queryStationHistoryMsgDto.getSceneName();
        Query query = new Query();
        Criteria criteria = new Criteria();
        if (StringUtils.isNotBlank((CharSequence)msgTitle)) {
            criteria.and("msgTitle").regex(FormatUtil.format((String)"%s%s%s", (String)".*", (String)msgTitle.trim(), (String)".*"));
        }
        if (StringUtils.isNotBlank((CharSequence)stationType)) {
            criteria.and("stationType").is((Object)stationType);
        }
        if (userReceiverId != null) {
            criteria.and("userReceiverId").is((Object)userReceiverId);
        }
        if (StringUtils.isNotBlank((CharSequence)tenantCode)) {
            criteria.and("tenantCode").is((Object)tenantCode);
        } else {
            criteria.and("tenantCode").is((Object)"0");
        }
        if (StringUtils.isNotBlank((CharSequence)readFlag)) {
            criteria.and("readFlag").is((Object)readFlag);
        }
        if (sendTimeStart != null && sendTimeEnd == null) {
            criteria.and("sendTime").gte((Object)sendTimeStart);
        }
        if (sendTimeStart == null && sendTimeEnd != null) {
            criteria.and("sendTime").lte((Object)sendTimeEnd);
        }
        if (sendTimeStart != null && sendTimeEnd != null) {
            criteria.and("sendTime").gte((Object)sendTimeStart).lte((Object)sendTimeEnd);
        }
        if (msgStatus != null) {
            criteria.and("msgStatus").is((Object)msgStatus);
        }
        if (StringUtils.isNotBlank((CharSequence)appName)) {
            criteria.and("appName").regex(FormatUtil.format((String)"%s%s%s", (String)".*", (String)msgTitle.trim(), (String)".*"));
        }
        if (StringUtils.isNotBlank((CharSequence)sceneName)) {
            criteria.and("sceneName").regex(FormatUtil.format((String)"%s%s%s", (String)".*", (String)msgTitle.trim(), (String)".*"));
        }
        query.addCriteria((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"sendTime")}));
        long total = this.mongoTemplate.count(query, MsgStationSendRecordDocument.class);
        query.skip((current - 1L) * size);
        query.limit((int)size);
        List list = this.mongoTemplate.find(query, MsgStationSendRecordDocument.class);
        ArrayList<StationHistoryMsgVo> data = new ArrayList<StationHistoryMsgVo>();
        if (HussarUtils.isNotEmpty((Object)list)) {
            SendStatusEnum[] values = SendStatusEnum.values();
            HashMap<Integer, String> mapStauts = new HashMap<Integer, String>();
            for (SendStatusEnum se : values) {
                mapStauts.put(se.getCode(), se.getName());
            }
            StationHistoryMsgVo vo = null;
            Map<String, String> StationTypeMap = this.getStationTypeMap();
            for (MsgStationSendRecordDocument document : list) {
                vo = new StationHistoryMsgVo();
                vo.setStationRecordId(document.getId());
                vo.setMsgMobileUrl(document.getMsgMobileUrl());
                vo.setMsgWebUrl(document.getMsgWebUrl());
                vo.setMsgTitle(document.getMsgTitle());
                vo.setStationType(stationType);
                vo.setSendTime(document.getSendTime());
                vo.setReadFlag(document.getReadFlag());
                String msgTitleTemp = vo.getMsgTitle();
                vo.setStationTypeLabel(StationTypeMap.get(vo.getStationType()));
                String showTitle = "\u3010" + vo.getStationTypeLabel() + "\u3011" + msgTitleTemp;
                vo.setShowTitle(showTitle);
                vo.setMsgStatusLabel((String)mapStauts.get(vo.getMsgStatus()));
                vo.setErrMsg(document.getErrMsg());
                data.add(vo);
            }
        }
        Page page = new Page();
        page.setCurrent(current);
        page.setSize(size);
        page.setTotal(total);
        page.setRecords(data);
        return ApiResponse.success((Object)page);
    }

    public ApiResponse<String> deleteMsg(String id) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").is((Object)id)});
        Query query = new Query((CriteriaDefinition)criteria);
        this.mongoTemplate.remove(query, MsgStationSendRecordDocument.class);
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    public ApiResponse<String> deleteMsgs(List<String> ids) {
        Criteria criteria = new Criteria();
        criteria.andOperator(new Criteria[]{Criteria.where((String)"id").in(ids)});
        Query query = new Query((CriteriaDefinition)criteria);
        this.mongoTemplate.remove(query, MsgStationSendRecordDocument.class);
        return ApiResponse.success((String)"\u6279\u91cf\u5220\u9664\u6210\u529f\uff01");
    }

    public ApiResponse<StationHistoryMsgVo> getMsg(String id) {
        MsgStationSendRecordDocument doc = (MsgStationSendRecordDocument)this.mongoTemplate.findById((Object)id, MsgStationSendRecordDocument.class);
        StationHistoryMsgVo vo = new StationHistoryMsgVo();
        if (doc != null) {
            vo.setStationRecordId(doc.getId());
            vo.setMsgTitle(doc.getMsgTitle());
            vo.setMsgTitle(doc.getMsgTitle());
            vo.setStationType(doc.getStationType());
            vo.setSendTime(doc.getSendTime());
            vo.setStationTypeLabel(this.msgStationTypeService.getStationLabel(vo.getStationType()));
            vo.setMsgStatus(doc.getMsgStatus());
            vo.setShowTitle("\u3010" + vo.getStationTypeLabel() + "\u3011" + vo.getMsgTitle());
            vo.setMsgMobileUrl(doc.getMsgMobileUrl());
            vo.setMsgWebUrl(doc.getMsgWebUrl());
            vo.setAppId(doc.getAppId());
            vo.setAppName(doc.getAppName());
            vo.setAppSecret(doc.getAppSecret());
            vo.setTemplateNo(doc.getTemplateNo());
            vo.setTemplateName(doc.getTemplateName());
            vo.setSceneCode(doc.getSceneCode());
            vo.setSceneName(doc.getSceneName());
        }
        return ApiResponse.success((Object)vo);
    }
}

