/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.cp.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.msg.common.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.common.model.ChannelsVo;
import com.jxdinfo.hussar.msg.common.utils.ContactInfoEncryptUtils;
import com.jxdinfo.hussar.msg.common.utils.Strings;
import com.jxdinfo.hussar.msg.common.utils.TenantCodeUtils;
import com.jxdinfo.hussar.msg.cp.config.mongodb.repository.MsgCpSendRecordRepository;
import com.jxdinfo.hussar.msg.cp.dto.CpSendRecordDto;
import com.jxdinfo.hussar.msg.cp.dto.CpSendRecordPageDto;
import com.jxdinfo.hussar.msg.cp.mongodb.document.MsgCpSendRecordDocument;
import com.jxdinfo.hussar.msg.cp.service.CpChannelService;
import com.jxdinfo.hussar.msg.cp.service.CpSendRecordService;
import com.jxdinfo.hussar.msg.cp.vo.CpChannelSendStatisticsVo;
import com.jxdinfo.hussar.msg.cp.vo.MsgCpSendRecordVo;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service
public class CpSendRecordMongodbServiceImpl
implements CpSendRecordService {
    @Autowired
    private MongoTemplate mongoTemplate;
    @Autowired
    private MsgCpSendRecordRepository msgCpSendRecordRepository;
    @Autowired
    private CpChannelService cpChannelService;

    public IPage<MsgCpSendRecordVo> listPage(Page pageable, CpSendRecordPageDto pageDto) {
        Query query = new Query();
        Criteria criteria = new Criteria();
        if (pageDto.getBeginTime() != null && pageDto.getEndTime() != null) {
            Criteria fromTime = Criteria.where((String)"createTime").gt((Object)pageDto.getBeginTime());
            Criteria toTime = Criteria.where((String)"createTime").lt((Object)pageDto.getEndTime());
            criteria.andOperator(new Criteria[]{fromTime, toTime});
        }
        if (pageDto.getToUser() != null) {
            criteria.and("toUser").is((Object)pageDto.getToUser());
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getAppName())) {
            criteria.and("appName").regex(Strings.format((String)"%s%s%s", (String)".*", (String)pageDto.getAppName(), (String)".*"));
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getChannelName())) {
            criteria.orOperator(new Criteria[]{Criteria.where((String)"channelName").regex(Strings.format((String)"%s%s%s", (String)".*", (String)pageDto.getChannelName(), (String)".*")), Criteria.where((String)"channelNo").regex(Strings.format((String)"%s%s%s", (String)".*", (String)pageDto.getChannelName(), (String)".*"))});
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getSceneCode())) {
            criteria.and("sceneCode").regex(Strings.format((String)"%s%s%s", (String)".*", (String)pageDto.getSceneCode(), (String)".*"));
        }
        if (HussarUtils.isNotEmpty((Object)pageDto.getSceneName())) {
            criteria.and("sceneName").regex(Strings.format((String)"%s%s%s", (String)".*", (String)pageDto.getSceneName(), (String)".*"));
        }
        if (pageDto.getStatus() != null) {
            criteria.and("status").is((Object)pageDto.getStatus());
        }
        if (pageDto.getContent() != null) {
            String reges = Strings.format((String)"%s%s%s", (String)"^.*", (String)pageDto.getContent().trim(), (String)".*$");
            Pattern pattern = Pattern.compile(reges, 2);
            criteria.and("content").regex(pattern);
        }
        if (pageDto.getCorpName() != null) {
            criteria.and("corpName").regex(Strings.format((String)"%s%s%s", (String)".*", (String)pageDto.getCorpName(), (String)".*"));
        }
        if (pageDto.getAgentName() != null) {
            criteria.and("agentName").regex(Strings.format((String)"%s%s%s", (String)".*", (String)pageDto.getAgentName(), (String)".*"));
        }
        TenantCodeUtils.fillCriteriaTenantCode((Criteria)criteria);
        query.addCriteria((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"createTime")}));
        long total = this.mongoTemplate.count(query, MsgCpSendRecordDocument.class);
        query.skip((pageable.getCurrent() - 1L) * pageable.getSize());
        query.limit((int)pageable.getSize());
        List list = this.mongoTemplate.find(query, MsgCpSendRecordDocument.class);
        List pageList = list.stream().map(this::transferDto).collect(Collectors.toList());
        for (MsgCpSendRecordVo msgCpSendRecordVo : pageList) {
            msgCpSendRecordVo.setToUser(ContactInfoEncryptUtils.receiveAddressEncrypt((String)msgCpSendRecordVo.getToUser()));
        }
        Page page = new Page();
        page.setCurrent(pageable.getCurrent());
        page.setSize(pageable.getSize());
        page.setTotal(total);
        page.setRecords(pageList);
        return page;
    }

    private MsgCpSendRecordVo transferDto(MsgCpSendRecordDocument msgCpSendRecordDocument) {
        MsgCpSendRecordVo msgCpSendRecordVo = new MsgCpSendRecordVo();
        BeanUtils.copyProperties((Object)((Object)msgCpSendRecordDocument), (Object)msgCpSendRecordVo);
        return msgCpSendRecordVo;
    }

    public CpSendRecordDto findById(String id) {
        Optional entity = this.msgCpSendRecordRepository.findById(id);
        MsgCpSendRecordDocument msgCpSendRecordDocument = entity.orElse(null);
        CpSendRecordDto cpSendRecordDto = new CpSendRecordDto();
        BeanUtils.copyProperties((Object)((Object)msgCpSendRecordDocument), (Object)cpSendRecordDto);
        return cpSendRecordDto;
    }

    public List<CpChannelSendStatisticsVo> sendStatistics(CpSendRecordPageDto pageDto) {
        Criteria criteria = new Criteria();
        if (pageDto.getBeginTime() != null && pageDto.getEndTime() != null) {
            Criteria fromTime = Criteria.where((String)"createTime").gt((Object)pageDto.getBeginTime());
            Criteria toTime = Criteria.where((String)"createTime").lt((Object)pageDto.getEndTime());
            criteria.andOperator(new Criteria[]{fromTime, toTime});
        }
        TenantCodeUtils.fillCriteriaTenantCode((Criteria)criteria);
        if (HussarUtils.isNotEmpty((Object)pageDto.getChannelNo())) {
            criteria.and("channelNo").is((Object)pageDto.getChannelNo());
        }
        Aggregation agg = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)criteria), Aggregation.group((String[])new String[]{"channelNo", "createDate", "status", "channelName"}).count().as("count"), Aggregation.project((String[])new String[]{"channelNo", "createDate", "status", "channelName", "count"})});
        AggregationResults aggregate = this.mongoTemplate.aggregate(agg, MsgCpSendRecordDocument.class, SendRecordAgg.class);
        List mappedResults = aggregate.getMappedResults();
        List channelNos = mappedResults.parallelStream().map(SendRecordAgg::getChannelNo).distinct().collect(Collectors.toList());
        Map channelNoAndName = this.cpChannelService.getChannelNoAndName(channelNos);
        Map<String, List<SendRecordAgg>> listMap = mappedResults.parallelStream().collect(Collectors.groupingBy(SendRecordAgg::getChannelNo));
        List createDateList = mappedResults.parallelStream().map(SendRecordAgg::getCreateDate).distinct().sorted().collect(Collectors.toList());
        ArrayList<CpChannelSendStatisticsVo> result = new ArrayList<CpChannelSendStatisticsVo>();
        listMap.forEach((channelNo, aggs) -> {
            CpChannelSendStatisticsVo statisticsVo = new CpChannelSendStatisticsVo();
            statisticsVo.setChannelNo(channelNo);
            statisticsVo.setChannelName((String)channelNoAndName.get(channelNo));
            statisticsVo.setCreateDate(createDateList);
            ArrayList aggVos = new ArrayList();
            Map<String, Map<Integer, List<SendRecordAgg>>> collect = aggs.parallelStream().collect(Collectors.groupingBy(SendRecordAgg::getCreateDate, Collectors.groupingBy(SendRecordAgg::getStatus)));
            collect.forEach((createTime, aggs1) -> {
                CpChannelSendStatisticsVo.CpChannelSendStatisticAgg aggVo = new CpChannelSendStatisticsVo.CpChannelSendStatisticAgg();
                aggVo.setSendDate(createTime);
                aggs1.forEach((status, aggs2) -> {
                    if (status.equals(SendStatusEnum.SUCCESS.getCode())) {
                        aggVo.setSuccessCount(((SendRecordAgg)aggs2.get(0)).count);
                    } else if (status.equals(SendStatusEnum.FAIL.getCode())) {
                        aggVo.setFailCount(((SendRecordAgg)aggs2.get(0)).count);
                    } else if (status.equals(SendStatusEnum.SENDING.getCode())) {
                        aggVo.setWillCount(((SendRecordAgg)aggs2.get(0)).count);
                    }
                });
                aggVos.add(aggVo);
            });
            statisticsVo.setAggs(aggVos);
            result.add(statisticsVo);
        });
        return result;
    }

    public List<ChannelsVo> getAllChannels() {
        Aggregation agg = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.group((String[])new String[]{"channelNo", "channelName"}), Aggregation.project((String[])new String[]{"channelNo", "channelName"})});
        List mappedResults = this.mongoTemplate.aggregate(agg, MsgCpSendRecordDocument.class, ChannelsVo.class).getMappedResults();
        Map channelNoAndName = this.cpChannelService.getChannelNoAndName(mappedResults.stream().map(ChannelsVo::getChannelNo).collect(Collectors.toList()));
        for (ChannelsVo channelsVo : mappedResults) {
            channelsVo.setChannelName((String)channelNoAndName.get(channelsVo.getChannelNo()));
        }
        return mappedResults;
    }

    public void saveRecord(CpSendRecordDto cpSendRecordDto) {
        if (SendStatusEnum.SUCCESS.getCode().equals(cpSendRecordDto.getStatus()) && HussarUtils.isNotEmpty((Object)cpSendRecordDto.getErrorContactInfos())) {
            cpSendRecordDto.setErrMsg("\u90e8\u5206\u53d1\u9001\u6210\u529f\uff0c\u4ee5\u4e0b\u8054\u7cfb\u4eba\u65e0\u6cd5\u53d1\u9001\uff1a" + String.join((CharSequence)"\uff1b", cpSendRecordDto.getErrorContactInfos()));
        }
        this.msgCpSendRecordRepository.save(HussarUtils.copy((Object)cpSendRecordDto, MsgCpSendRecordDocument.class));
    }

    public static class SendRecordAgg {
        private String channelNo;
        private String channelName;
        private String createDate;
        private Integer status;
        private Long count;

        public String getChannelNo() {
            return this.channelNo;
        }

        public String getChannelName() {
            return this.channelName;
        }

        public void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        public void setChannelNo(String channelNo) {
            this.channelNo = channelNo;
        }

        public String getCreateDate() {
            return this.createDate;
        }

        public void setCreateDate(String createDate) {
            this.createDate = createDate;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public Long getCount() {
            return this.count;
        }

        public void setCount(Long count) {
            this.count = count;
        }
    }
}

