/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.send.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.msg.common.model.ChannelsVo;
import com.jxdinfo.hussar.msg.common.vo.MsgSendRecordCountVo;
import com.jxdinfo.hussar.msg.factory.MsgSendExecutorFactory;
import com.jxdinfo.hussar.msg.send.dto.MsgSendRecordQueryDto;
import com.jxdinfo.hussar.msg.send.dto.MsgSendStatisticsVo;
import com.jxdinfo.hussar.msg.send.model.MsgSendRecord;
import com.jxdinfo.hussar.msg.send.service.MsgSendExecutor;
import com.jxdinfo.hussar.msg.send.service.MsgSendRecordDaoService;
import com.jxdinfo.hussar.msg.send.service.MsgSendRecordService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class BDMsgSendRecordServiceImpl
implements MsgSendRecordService {
    @Autowired
    private MsgSendRecordDaoService msgSendRecordDaoService;

    public void saveRecord(MsgSendRecord sendRecord) {
        this.msgSendRecordDaoService.save(sendRecord);
    }

    public Page<MsgSendRecord> listPage(Page<MsgSendRecord> page, MsgSendRecordQueryDto queryDto) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(MsgSendRecord::getSendType, (Object)queryDto.getSendType());
        if (HussarUtils.isNotEmpty((Object)queryDto.getBusinessId())) {
            wrapper.eq(MsgSendRecord::getBusinessId, (Object)queryDto.getBusinessId());
        }
        if (HussarUtils.isNotEmpty((Object)queryDto.getTitle())) {
            wrapper.like(MsgSendRecord::getTitle, (Object)this.escapeLike(queryDto.getTitle()));
        }
        if (HussarUtils.isNotEmpty((Object)queryDto.getContent())) {
            wrapper.like(MsgSendRecord::getContent, (Object)this.escapeLike(queryDto.getContent()));
        }
        if (HussarUtils.isNotEmpty((Object)queryDto.getStatus())) {
            wrapper.eq(MsgSendRecord::getStatus, (Object)queryDto.getStatus());
        }
        if (HussarUtils.isNotEmpty((Object)queryDto.getAppName())) {
            wrapper.like(MsgSendRecord::getAppName, (Object)this.escapeLike(queryDto.getAppName()));
        }
        if (HussarUtils.isNotEmpty((Object)queryDto.getSceneName())) {
            wrapper.like(MsgSendRecord::getSceneName, (Object)this.escapeLike(queryDto.getSceneName()));
        }
        if (HussarUtils.isNotEmpty((Object)queryDto.getChannelNo())) {
            wrapper.eq(MsgSendRecord::getChannelNo, (Object)queryDto.getChannelNo());
        }
        if (HussarUtils.isNotEmpty((Object)queryDto.getChannelName())) {
            wrapper.like(MsgSendRecord::getChannelName, (Object)this.escapeLike(queryDto.getChannelName()));
        }
        if (HussarUtils.isNotEmpty((Object)queryDto.getTemplateName())) {
            wrapper.like(MsgSendRecord::getTemplateName, (Object)this.escapeLike(queryDto.getTemplateName()));
        }
        if (HussarUtils.isNotEmpty((Object)queryDto.getBeginTime()) && HussarUtils.isNotEmpty((Object)queryDto.getEndTime())) {
            wrapper.between(MsgSendRecord::getCreateTime, (Object)queryDto.getBeginTime(), (Object)queryDto.getEndTime());
        }
        wrapper.orderByDesc(MsgSendRecord::getCreateTime);
        this.msgSendRecordDaoService.page((IPage)page, (Wrapper)wrapper);
        return page;
    }

    public List<MsgSendStatisticsVo> sendStatistics(MsgSendRecordQueryDto queryDto) {
        List<MsgSendRecordCountVo> msgSendRecordCountVos = this.msgSendRecordDaoService.listSendRecordStatusCount(queryDto.getSendType(), queryDto.getBeginTime(), queryDto.getEndTime(), queryDto.getChannelNo());
        ArrayList<MsgSendStatisticsVo> sendStatisticsVos = new ArrayList<MsgSendStatisticsVo>();
        if (HussarUtils.isNotEmpty(msgSendRecordCountVos)) {
            Map<String, String> channelNoAndName = this.getChannelNoAndName(queryDto.getSendType());
            channelNoAndName.put("00000000", "\u65e0\u901a\u9053\u6d88\u606f");
            for (MsgSendRecordCountVo vo : msgSendRecordCountVos) {
                if (!HussarUtils.isEmpty((Object)vo.getChannelNo())) continue;
                vo.setChannelNo("00000000");
            }
            Map<String, List<MsgSendRecordCountVo>> channelNoKeyMap = msgSendRecordCountVos.parallelStream().collect(Collectors.groupingBy(MsgSendRecordCountVo::getChannelNo));
            List<String> createDateList = msgSendRecordCountVos.parallelStream().map(MsgSendRecordCountVo::getCreateDate).distinct().sorted().collect(Collectors.toList());
            for (Map.Entry<String, List<MsgSendRecordCountVo>> channelNoKey : channelNoKeyMap.entrySet()) {
                MsgSendStatisticsVo sendStatisticsVo = this.getSendRecordStatisticsVo(channelNoKey, createDateList, channelNoAndName);
                sendStatisticsVos.add(sendStatisticsVo);
            }
        }
        return sendStatisticsVos;
    }

    private Map<String, String> getChannelNoAndName(String sendType) {
        MsgSendExecutor msgSendExecutor = MsgSendExecutorFactory.getSendExecutor((String)sendType);
        List allChannels = msgSendExecutor.getAllChannels();
        if (allChannels == null) {
            return new HashMap<String, String>();
        }
        Map<String, String> map = allChannels.stream().collect(Collectors.toMap(ChannelsVo::getChannelNo, ChannelsVo::getChannelName));
        return map;
    }

    private MsgSendStatisticsVo getSendRecordStatisticsVo(Map.Entry<String, List<MsgSendRecordCountVo>> channelNoKey, List<String> createDateList, Map<String, String> channelNoAndName) {
        MsgSendStatisticsVo sendStatisticsVo = new MsgSendStatisticsVo();
        String channelNo = channelNoKey.getKey();
        List<MsgSendRecordCountVo> msgSendRecordCountVoList = channelNoKey.getValue();
        sendStatisticsVo.setChannelNo(channelNo);
        sendStatisticsVo.setChannelName(channelNoAndName.get(channelNo));
        sendStatisticsVo.setCreateDate(createDateList);
        List<MsgSendStatisticsVo.MsgUnifiedChannelSendStatisticAgg> sendStatisticAggList = this.getChannelSendStatisticAggs(msgSendRecordCountVoList);
        sendStatisticsVo.setAggs(sendStatisticAggList);
        return sendStatisticsVo;
    }

    private List<MsgSendStatisticsVo.MsgUnifiedChannelSendStatisticAgg> getChannelSendStatisticAggs(List<MsgSendRecordCountVo> msgSendRecordCountVoList) {
        ArrayList<MsgSendStatisticsVo.MsgUnifiedChannelSendStatisticAgg> sendStatisticAggList = new ArrayList<MsgSendStatisticsVo.MsgUnifiedChannelSendStatisticAgg>();
        for (MsgSendRecordCountVo msgSendRecordCountVo : msgSendRecordCountVoList) {
            MsgSendStatisticsVo.MsgUnifiedChannelSendStatisticAgg sendStatisticAgg = new MsgSendStatisticsVo.MsgUnifiedChannelSendStatisticAgg();
            sendStatisticAgg.setSendDate(msgSendRecordCountVo.getCreateDate());
            sendStatisticAgg.setSuccessCount(msgSendRecordCountVo.getSuccessCount());
            sendStatisticAgg.setFailCount(msgSendRecordCountVo.getFailCount());
            sendStatisticAgg.setWillCount(msgSendRecordCountVo.getWillCount());
            sendStatisticAggList.add(sendStatisticAgg);
        }
        return sendStatisticAggList;
    }

    private String escapeLike(String str) {
        if (str == null) {
            return null;
        }
        return str.replace("\\", "\\\\").replace("%", "\\%").replace("_", "\\_");
    }
}

