/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.station.service.impl;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.msg.common.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.station.dao.MsgStationSendRecordMapper;
import com.jxdinfo.hussar.msg.station.dto.StationSendRecordDto;
import com.jxdinfo.hussar.msg.station.model.MsgStationSendRecord;
import com.jxdinfo.hussar.msg.station.service.IMsgStationTypeService;
import com.jxdinfo.hussar.msg.station.service.ISendClientMessage;
import com.jxdinfo.hussar.msg.station.service.IStationSendRecordService;
import com.jxdinfo.hussar.msg.station.service.MsgStationSendRecordDbService;
import com.jxdinfo.hussar.msg.station.vo.StationNoReadMsgVo;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.ExceptionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.IdUtil;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.msg.Station.service.impl.StationSendRecordServiceImpl")
@HussarTokenDs
public class StationSendRecordServiceImpl
extends HussarServiceImpl<MsgStationSendRecordMapper, MsgStationSendRecord>
implements MsgStationSendRecordDbService,
IStationSendRecordService {
    private static final Logger LOGGER = LoggerFactory.getLogger(StationSendRecordServiceImpl.class);
    @Autowired(required=false)
    private ISendClientMessage sendClientMessage;
    @Resource
    private IMsgStationTypeService msgStationTypeService;

    private Map<String, String> getStationTypeMap() {
        return this.msgStationTypeService.getStationTypeMap();
    }

    public void save(StationSendRecordDto recordDto) {
        Long userSendId = recordDto.getUserSendId();
        String msgTitle = recordDto.getMsgTitle();
        String msgContent = recordDto.getMsgContent();
        String stationType = recordDto.getStationType();
        String msgWebUrl = recordDto.getMsgWebUrl();
        String msgMobileUrl = recordDto.getMsgMobileUrl();
        List receiverUserIds = recordDto.getReceiverUserIds();
        String tenantCode = recordDto.getTenantCode();
        String inputParams = recordDto.getInputParams();
        HussarContextHolder.setTenant((String)"1", (String)tenantCode);
        String templateNo = recordDto.getTemplateNo();
        String templateName = recordDto.getTemplateName();
        String appId = recordDto.getAppId();
        String appName = recordDto.getAppName();
        String appSecret = recordDto.getAppSecret();
        String sceneName = recordDto.getSceneName();
        String sceneCode = recordDto.getSceneCode();
        Integer status = recordDto.getStatus();
        String errMsg = recordDto.getErrMsg();
        HashSet reveiverIds = new HashSet();
        if (HussarUtils.isNotEmpty((Object)receiverUserIds)) {
            reveiverIds.addAll(receiverUserIds);
        }
        Map<String, String> StationTypeMap = this.getStationTypeMap();
        msgContent = "\u3010" + StationTypeMap.get(stationType) + "\u3011" + msgContent;
        ArrayList<MsgStationSendRecord> list = new ArrayList<MsgStationSendRecord>();
        Date current = new Date();
        if (HussarUtils.isNotEmpty(reveiverIds)) {
            MsgStationSendRecord record = null;
            for (Long uid : reveiverIds) {
                record = new MsgStationSendRecord();
                record.setAppId(appId);
                record.setAppName(appName);
                record.setAppSecret(appSecret);
                record.setTemplateName(templateName);
                record.setTemplateNo(templateNo);
                record.setSceneCode(sceneCode);
                record.setSceneName(sceneName);
                record.setId(Long.valueOf(IdUtil.getSnowflakeNextId()));
                record.setMsgTitle(msgTitle);
                record.setMsgContent(msgContent);
                record.setStationType(stationType);
                record.setMsgWebUrl(msgWebUrl);
                record.setMsgMobileUrl(msgMobileUrl);
                record.setMsgStatus(SendStatusEnum.SUCCESS.getCode());
                record.setReadFlag("0");
                record.setUserSendId(userSendId);
                record.setUserReceiverId(uid);
                record.setSendTime(current);
                record.setInputParams(inputParams);
                if (status != null && status.equals(SendStatusEnum.FAIL.getCode())) {
                    record.setMsgStatus(status);
                } else {
                    record.setMsgStatus(SendStatusEnum.SUCCESS.getCode());
                }
                record.setErrMsg(errMsg);
                if (this.sendClientMessage != null && record.getMsgStatus().equals(SendStatusEnum.SUCCESS.getCode())) {
                    StationNoReadMsgVo vo = new StationNoReadMsgVo();
                    vo.setSendTime(current);
                    vo.setMsgTitle(record.getMsgTitle());
                    vo.setStationRecordId(record.getId() + "");
                    vo.setStationType(stationType);
                    vo.setMsgWebUrl(record.getMsgWebUrl());
                    vo.setMsgMobileUrl(record.getMsgMobileUrl());
                    vo.setMsgContent(msgContent);
                    vo.setUserSendId(userSendId);
                    vo.setUserReceiverId(uid);
                    vo.setOpenWay(recordDto.getOpenWay());
                    this.sendClientMessage.sendMessageOne(uid, JSON.toJSONString((Object)vo));
                }
                list.add(record);
            }
            try {
                this.saveBatch(list);
            }
            catch (Exception e) {
                LOGGER.error("\u6279\u91cf\u4fdd\u5b58\u7ad9\u5185\u4fe1\u8bb0\u5f55\u5931\u8d25", (Throwable)e);
                for (MsgStationSendRecord temp : list) {
                    temp.setMsgStatus(SendStatusEnum.FAIL.getCode());
                    temp.setErrMsg(ExceptionUtil.getMessage((Throwable)e));
                }
                this.saveBatch(list);
            }
        } else {
            MsgStationSendRecord record = new MsgStationSendRecord();
            record.setMsgStatus(SendStatusEnum.FAIL.getCode());
            record.setErrMsg("\u65e0\u63a5\u6536\u4eba");
            record.setAppId(appId);
            record.setAppName(appName);
            record.setAppSecret(appSecret);
            record.setTemplateName(templateName);
            record.setTemplateNo(templateNo);
            record.setSceneCode(sceneCode);
            record.setSceneName(sceneName);
            record.setId(Long.valueOf(IdUtil.getSnowflakeNextId()));
            record.setMsgTitle(msgTitle);
            record.setMsgContent(msgContent);
            record.setStationType(stationType);
            record.setMsgWebUrl(msgWebUrl);
            record.setMsgMobileUrl(msgMobileUrl);
            record.setMsgStatus(SendStatusEnum.SUCCESS.getCode());
            record.setReadFlag("0");
            record.setUserSendId(userSendId);
            record.setSendTime(current);
            record.setInputParams(inputParams);
            this.save((BaseEntity)record);
        }
    }
}

