/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.station.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.msg.common.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.station.dao.MsgStationSendRecordMapper;
import com.jxdinfo.hussar.msg.station.dto.QueryStationHistoryMsgDto;
import com.jxdinfo.hussar.msg.station.model.MsgStationSendRecord;
import com.jxdinfo.hussar.msg.station.service.IMsgStationActionService;
import com.jxdinfo.hussar.msg.station.service.IMsgStationTypeService;
import com.jxdinfo.hussar.msg.station.vo.StationHistoryMsgVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.tenant.common.util.HussarContextHolder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HussarTokenDs
@Service(value="com.jxdinfo.hussar.msg.Station.service.impl.msgStationDbActionServiceImpl")
public class MsgStationDbActionServiceImpl
implements IMsgStationActionService {
    @Resource
    private MsgStationSendRecordMapper msgStationSendRecordMapper;
    @Autowired
    private IMsgStationTypeService msgStationTypeService;

    public ApiResponse<Page<StationHistoryMsgVo>> searchHistoryMsg(QueryStationHistoryMsgDto queryStationHistoryMsgDto) {
        long size = queryStationHistoryMsgDto.getSize();
        long current = queryStationHistoryMsgDto.getCurrent();
        Long userReceiverId = queryStationHistoryMsgDto.getUserReceiverId();
        String msgTitle = queryStationHistoryMsgDto.getMsgTitle();
        String tenantCode = queryStationHistoryMsgDto.getTenantCode();
        String stationType = queryStationHistoryMsgDto.getStationType();
        String readFlag = queryStationHistoryMsgDto.getReadFlag();
        Date sendTimeStart = queryStationHistoryMsgDto.getSendTimeStart();
        Date sendTimeEnd = queryStationHistoryMsgDto.getSendTimeEnd();
        Integer msgStatus = queryStationHistoryMsgDto.getMsgStatus();
        String appName = queryStationHistoryMsgDto.getAppName();
        String sceneName = queryStationHistoryMsgDto.getSceneName();
        HussarContextHolder.setTenant((String)"1", (String)tenantCode);
        Page page = new Page(current, size);
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)msgTitle)) {
            queryParams.put("msgTitle", SqlQueryUtil.transferSpecialChar((String)msgTitle));
        }
        if (StringUtils.isNotBlank((CharSequence)stationType)) {
            queryParams.put("stationType", stationType);
        }
        if (msgStatus != null) {
            queryParams.put("msgStatus", msgStatus);
        }
        if (StringUtils.isNotBlank((CharSequence)appName)) {
            queryParams.put("appName", SqlQueryUtil.transferSpecialChar((String)appName));
        }
        if (StringUtils.isNotBlank((CharSequence)sceneName)) {
            queryParams.put("sceneName", SqlQueryUtil.transferSpecialChar((String)sceneName));
        }
        if (userReceiverId != null) {
            queryParams.put("userReceiverId", userReceiverId);
        }
        if (StringUtils.isNotBlank((CharSequence)readFlag)) {
            queryParams.put("readFlag", readFlag);
        }
        if (sendTimeStart != null) {
            queryParams.put("sendTimeStart", sendTimeStart);
        }
        if (sendTimeEnd != null) {
            queryParams.put("sendTimeEnd", sendTimeEnd);
        }
        queryParams.put("escapeSymbol", SqlQueryUtil.ESCAPE_SYMBOL);
        SendStatusEnum[] values = SendStatusEnum.values();
        HashMap<Integer, String> mapStauts = new HashMap<Integer, String>();
        for (SendStatusEnum se : values) {
            mapStauts.put(se.getCode(), se.getName());
        }
        Page<StationHistoryMsgVo> stationHistoryMsgVoPage = this.msgStationSendRecordMapper.searchHistoryMsg((Page<StationHistoryMsgVo>)page, queryParams);
        List records = stationHistoryMsgVoPage.getRecords();
        if (HussarUtils.isNotEmpty((Object)records)) {
            Map<String, String> StationTypeMap = this.getStationTypeMap();
            for (StationHistoryMsgVo vo : records) {
                String stationTypeTemp = vo.getStationType();
                String msgTitleTemp = vo.getMsgTitle();
                vo.setMsgContent(vo.getMsgContent());
                vo.setMsgStatusLabel((String)mapStauts.get(vo.getMsgStatus()));
                vo.setStationTypeLabel(StationTypeMap.get(vo.getStationType()));
            }
        }
        return ApiResponse.success(stationHistoryMsgVoPage);
    }

    private Map<String, String> getStationTypeMap() {
        return this.msgStationTypeService.getStationTypeMap();
    }

    public ApiResponse<String> deleteMsg(String id) {
        this.msgStationSendRecordMapper.deleteById(Long.valueOf(Long.parseLong(id)));
        return ApiResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    public ApiResponse<String> deleteMsgs(List<String> ids) {
        if (HussarUtils.isNotEmpty(ids)) {
            ArrayList<Long> idsLong = new ArrayList<Long>();
            for (String s : ids) {
                idsLong.add(Long.parseLong(s));
            }
            this.msgStationSendRecordMapper.deleteMsgs(idsLong);
        }
        return ApiResponse.success((String)"\u6279\u91cf\u5220\u9664\u6210\u529f\uff01");
    }

    public ApiResponse<StationHistoryMsgVo> getMsg(String id) {
        MsgStationSendRecord record = (MsgStationSendRecord)this.msgStationSendRecordMapper.selectById(Long.valueOf(Long.parseLong(id)));
        StationHistoryMsgVo vo = new StationHistoryMsgVo();
        if (record != null) {
            vo.setStationRecordId(record.getId() + "");
            vo.setMsgTitle(record.getMsgTitle());
            vo.setStationType(record.getStationType());
            vo.setSendTime(record.getSendTime());
            vo.setStationTypeLabel(this.msgStationTypeService.getStationLabel(vo.getStationType()));
            vo.setMsgStatus(record.getMsgStatus());
            vo.setMsgContent(record.getMsgContent());
            vo.setMsgMobileUrl(record.getMsgMobileUrl());
            vo.setMsgWebUrl(record.getMsgWebUrl());
            vo.setAppId(record.getAppId());
            vo.setAppName(record.getAppName());
            vo.setAppSecret(record.getAppSecret());
            vo.setTemplateNo(record.getTemplateNo());
            vo.setTemplateName(record.getTemplateName());
            vo.setSceneCode(record.getSceneCode());
            vo.setSceneName(record.getSceneName());
        }
        return ApiResponse.success((Object)vo);
    }
}

