/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.dingtalk.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.msg.common.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.common.model.ChannelsVo;
import com.jxdinfo.hussar.msg.common.utils.ContactInfoEncryptUtils;
import com.jxdinfo.hussar.msg.common.vo.MsgSendRecordCountVo;
import com.jxdinfo.hussar.msg.dingtalk.dao.MsgDingTalkSendRecordMapper;
import com.jxdinfo.hussar.msg.dingtalk.dto.DingTalkRecordDto;
import com.jxdinfo.hussar.msg.dingtalk.dto.DingTalkSendRecordDto;
import com.jxdinfo.hussar.msg.dingtalk.model.MsgDingTalkSendRecord;
import com.jxdinfo.hussar.msg.dingtalk.service.DingTalkChannelService;
import com.jxdinfo.hussar.msg.dingtalk.service.DingTalkSendRecordService;
import com.jxdinfo.hussar.msg.dingtalk.service.MsgDingTalkSendRecordDbService;
import com.jxdinfo.hussar.msg.dingtalk.vo.DingTalkChSendStatisticsVo;
import com.jxdinfo.hussar.msg.dingtalk.vo.DingTalkSendRecordVo;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class MsgDingTalkSendRecordDbServiceImpl
extends HussarServiceImpl<MsgDingTalkSendRecordMapper, MsgDingTalkSendRecord>
implements MsgDingTalkSendRecordDbService,
DingTalkSendRecordService {
    @Autowired
    private MsgDingTalkSendRecordMapper msgDingTalkSendRecordMapper;
    @Autowired
    private DingTalkChannelService dingTalkChannelService;

    public IPage<DingTalkSendRecordVo> listPage(Page page, DingTalkRecordDto pageDto) {
        pageDto.setAppName(SqlQueryUtil.transferSpecialChar((String)pageDto.getAppName()));
        pageDto.setChannelName(SqlQueryUtil.transferSpecialChar((String)pageDto.getChannelName()));
        pageDto.setSceneName(SqlQueryUtil.transferSpecialChar((String)pageDto.getSceneName()));
        pageDto.setCorpName(SqlQueryUtil.transferSpecialChar((String)pageDto.getCorpName()));
        pageDto.setDingAppName(SqlQueryUtil.transferSpecialChar((String)pageDto.getDingAppName()));
        Page sendRecordVoPage = new Page(page.getCurrent(), page.getSize());
        List<DingTalkSendRecordVo> msgDingTalkSendRecordVos = this.msgDingTalkSendRecordMapper.listPage((Page<DingTalkSendRecordVo>)sendRecordVoPage, pageDto);
        for (DingTalkSendRecordVo dingTalkSendRecordVo : msgDingTalkSendRecordVos) {
            dingTalkSendRecordVo.setToUser(ContactInfoEncryptUtils.receiveAddressEncrypt((String)dingTalkSendRecordVo.getToUser()));
        }
        sendRecordVoPage.setRecords(msgDingTalkSendRecordVos);
        return sendRecordVoPage;
    }

    public List<DingTalkChSendStatisticsVo> sendStatistics(DingTalkRecordDto pageDto) {
        List<MsgSendRecordCountVo> msgSendRecordCountVos = this.msgDingTalkSendRecordMapper.listSendRecordStatusCount(pageDto.getBeginTime(), pageDto.getEndTime(), pageDto.getChannelNo());
        ArrayList<DingTalkChSendStatisticsVo> sendStatisticsVos = new ArrayList<DingTalkChSendStatisticsVo>();
        if (HussarUtils.isNotEmpty(msgSendRecordCountVos)) {
            List channelNos = msgSendRecordCountVos.parallelStream().map(MsgSendRecordCountVo::getChannelNo).distinct().collect(Collectors.toList());
            Map channelNoAndName = this.dingTalkChannelService.getChannelNoAndName(channelNos);
            Map<String, List<MsgSendRecordCountVo>> channelNoKeyMap = msgSendRecordCountVos.parallelStream().collect(Collectors.groupingBy(MsgSendRecordCountVo::getChannelNo));
            List<String> createDateList = msgSendRecordCountVos.parallelStream().map(MsgSendRecordCountVo::getCreateDate).distinct().sorted().collect(Collectors.toList());
            for (Map.Entry<String, List<MsgSendRecordCountVo>> channelNoKey : channelNoKeyMap.entrySet()) {
                DingTalkChSendStatisticsVo sendStatisticsVo = MsgDingTalkSendRecordDbServiceImpl.getDingTalkChSendStatisticsVo(channelNoKey, createDateList, channelNoAndName);
                sendStatisticsVos.add(sendStatisticsVo);
            }
        }
        return sendStatisticsVos;
    }

    public DingTalkSendRecordVo findById(String id) {
        MsgDingTalkSendRecord msgDingTalkSendRecord = (MsgDingTalkSendRecord)super.getOne((Wrapper)new LambdaQueryWrapper().eq(MsgDingTalkSendRecord::getId, (Object)Long.valueOf(id)));
        return (DingTalkSendRecordVo)HussarUtils.copy((Object)msgDingTalkSendRecord, DingTalkSendRecordVo.class);
    }

    public void saveRecord(DingTalkSendRecordDto dingTalkSendRecordDto) {
        if (SendStatusEnum.SUCCESS.getCode().equals(dingTalkSendRecordDto.getStatus()) && HussarUtils.isNotEmpty((Object)dingTalkSendRecordDto.getErrorContactInfos())) {
            dingTalkSendRecordDto.setErrMsg("\u90e8\u5206\u53d1\u9001\u6210\u529f\uff0c\u4ee5\u4e0b\u8054\u7cfb\u4eba\u65e0\u6cd5\u53d1\u9001\uff1a" + String.join((CharSequence)"\uff1b", dingTalkSendRecordDto.getErrorContactInfos()));
        }
        super.save((BaseEntity)HussarUtils.copy((Object)dingTalkSendRecordDto, MsgDingTalkSendRecord.class));
    }

    public List<ChannelsVo> getAllChannels() {
        List<ChannelsVo> channelsVos = this.msgDingTalkSendRecordMapper.listChannels();
        Map channelNoAndName = this.dingTalkChannelService.getChannelNoAndName(channelsVos.stream().map(ChannelsVo::getChannelNo).collect(Collectors.toList()));
        for (ChannelsVo channelsVo : channelsVos) {
            channelsVo.setChannelName((String)channelNoAndName.get(channelsVo.getChannelNo()));
        }
        return channelsVos;
    }

    private static DingTalkChSendStatisticsVo getDingTalkChSendStatisticsVo(Map.Entry<String, List<MsgSendRecordCountVo>> channelNoKey, List<String> createDateList, Map<String, String> channelNoAndName) {
        DingTalkChSendStatisticsVo sendStatisticsVo = new DingTalkChSendStatisticsVo();
        String channelNo = channelNoKey.getKey();
        List<MsgSendRecordCountVo> msgSendRecordCountVoList = channelNoKey.getValue();
        sendStatisticsVo.setChannelNo(channelNo);
        sendStatisticsVo.setChannelName(channelNoAndName.get(channelNo));
        sendStatisticsVo.setCreateDate(createDateList);
        List<DingTalkChSendStatisticsVo.DingTalkChannelSendStatisticAgg> sendStatisticAggList = MsgDingTalkSendRecordDbServiceImpl.getDingTalkChannelSendStatisticAggs(msgSendRecordCountVoList);
        sendStatisticsVo.setAggs(sendStatisticAggList);
        return sendStatisticsVo;
    }

    private static List<DingTalkChSendStatisticsVo.DingTalkChannelSendStatisticAgg> getDingTalkChannelSendStatisticAggs(List<MsgSendRecordCountVo> msgSendRecordCountVoList) {
        ArrayList<DingTalkChSendStatisticsVo.DingTalkChannelSendStatisticAgg> sendStatisticAggList = new ArrayList<DingTalkChSendStatisticsVo.DingTalkChannelSendStatisticAgg>();
        for (MsgSendRecordCountVo msgSendRecordCountVo : msgSendRecordCountVoList) {
            DingTalkChSendStatisticsVo.DingTalkChannelSendStatisticAgg sendStatisticAgg = new DingTalkChSendStatisticsVo.DingTalkChannelSendStatisticAgg();
            sendStatisticAgg.setSendDate(msgSendRecordCountVo.getCreateDate());
            sendStatisticAgg.setSuccessCount(msgSendRecordCountVo.getSuccessCount());
            sendStatisticAgg.setFailCount(msgSendRecordCountVo.getFailCount());
            sendStatisticAgg.setWillCount(msgSendRecordCountVo.getWillCount());
            sendStatisticAggList.add(sendStatisticAgg);
        }
        return sendStatisticAggList;
    }
}

