/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.notice.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.msg.common.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.common.vo.MsgSendRecordCountVo;
import com.jxdinfo.hussar.msg.notice.dao.MsgNoticeSendRecordMapper;
import com.jxdinfo.hussar.msg.notice.dto.NoticeInfoPageDto;
import com.jxdinfo.hussar.msg.notice.dto.NoticeSendRecordDto;
import com.jxdinfo.hussar.msg.notice.model.MsgNoticeSendRecord;
import com.jxdinfo.hussar.msg.notice.service.MsgNoticeSendRecordDbService;
import com.jxdinfo.hussar.msg.notice.service.NoticeSendRecordService;
import com.jxdinfo.hussar.msg.notice.vo.NoticeSendRecordQueryVo;
import com.jxdinfo.hussar.msg.notice.vo.NoticeSendStatisticsVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class MsgNoticeSendRecordDbServiceImpl
extends HussarServiceImpl<MsgNoticeSendRecordMapper, MsgNoticeSendRecord>
implements MsgNoticeSendRecordDbService,
NoticeSendRecordService {
    @Autowired
    private MsgNoticeSendRecordMapper msgNoticeSendRecordMapper;

    public NoticeSendRecordQueryVo findById(String id) {
        MsgNoticeSendRecord msgNoticeSendRecord = (MsgNoticeSendRecord)super.getOne((Wrapper)new LambdaQueryWrapper().eq(MsgNoticeSendRecord::getId, (Object)Long.valueOf(id)));
        return (NoticeSendRecordQueryVo)HussarUtils.copy((Object)msgNoticeSendRecord, NoticeSendRecordQueryVo.class);
    }

    public IPage<NoticeSendRecordDto> listPage(Page page, NoticeInfoPageDto noticeInfoPageDto) {
        noticeInfoPageDto.setAppName(SqlQueryUtil.transferSpecialChar((String)noticeInfoPageDto.getAppName()));
        noticeInfoPageDto.setNoticeTitle(SqlQueryUtil.transferSpecialChar((String)noticeInfoPageDto.getNoticeTitle()));
        Page sendRecordDtoPage = new Page(page.getCurrent(), page.getSize());
        List<NoticeSendRecordDto> noticeSendRecordDtos = this.msgNoticeSendRecordMapper.listPage((Page<NoticeSendRecordDto>)sendRecordDtoPage, noticeInfoPageDto);
        for (NoticeSendRecordDto noticeSendRecordDto : noticeSendRecordDtos) {
            if (!HussarUtils.equals((Object)noticeSendRecordDto.getStatus(), (Object)SendStatusEnum.SUCCESS.getCode())) continue;
            noticeSendRecordDto.setErrMsg("\u6210\u529f");
        }
        sendRecordDtoPage.setRecords(noticeSendRecordDtos);
        return sendRecordDtoPage;
    }

    public ApiResponse sendStatistics(Date beginTime, Date endTime, String channelNo) {
        List<MsgSendRecordCountVo> msgSendRecordCountVos = this.msgNoticeSendRecordMapper.listSendRecordStatusCount(beginTime, endTime, Optional.ofNullable(channelNo).map(Long::valueOf).orElse(null));
        ArrayList<NoticeSendStatisticsVo> sendStatisticsVos = new ArrayList<NoticeSendStatisticsVo>();
        if (HussarUtils.isNotEmpty(msgSendRecordCountVos)) {
            Map<String, List<MsgSendRecordCountVo>> channelNoKeyMap = msgSendRecordCountVos.parallelStream().filter(record -> HussarUtils.isNotEmpty((Object)record.getChannelNo())).collect(Collectors.groupingBy(MsgSendRecordCountVo::getChannelNo));
            List<String> createDateList = msgSendRecordCountVos.parallelStream().map(MsgSendRecordCountVo::getCreateDate).distinct().sorted().collect(Collectors.toList());
            for (Map.Entry<String, List<MsgSendRecordCountVo>> channelNoKey : channelNoKeyMap.entrySet()) {
                NoticeSendStatisticsVo sendStatisticsVo = MsgNoticeSendRecordDbServiceImpl.getNoticeSendStatisticsVo(channelNoKey, createDateList);
                sendStatisticsVos.add(sendStatisticsVo);
            }
        }
        return ApiResponse.success(sendStatisticsVos);
    }

    public void saveRecord(NoticeSendRecordDto noticeSendRecordDto) {
        super.save((BaseEntity)HussarUtils.copy((Object)noticeSendRecordDto, MsgNoticeSendRecord.class));
    }

    private static NoticeSendStatisticsVo getNoticeSendStatisticsVo(Map.Entry<String, List<MsgSendRecordCountVo>> channelNoKey, List<String> createDateList) {
        NoticeSendStatisticsVo sendStatisticsVo = new NoticeSendStatisticsVo();
        List<MsgSendRecordCountVo> msgSendRecordCountVoList = channelNoKey.getValue();
        sendStatisticsVo.setChannelNo(channelNoKey.getKey());
        sendStatisticsVo.setCreateDate(createDateList);
        ArrayList<NoticeSendStatisticsVo.NoticeSendStatisticAgg> sendStatisticAggList = new ArrayList<NoticeSendStatisticsVo.NoticeSendStatisticAgg>();
        for (MsgSendRecordCountVo msgSendRecordCountVo : msgSendRecordCountVoList) {
            NoticeSendStatisticsVo.NoticeSendStatisticAgg sendStatisticAgg = new NoticeSendStatisticsVo.NoticeSendStatisticAgg();
            sendStatisticAgg.setSendDate(msgSendRecordCountVo.getCreateDate());
            sendStatisticAgg.setSuccessCount(msgSendRecordCountVo.getSuccessCount());
            sendStatisticAgg.setFailCount(msgSendRecordCountVo.getFailCount());
            sendStatisticAgg.setWillCount(msgSendRecordCountVo.getWillCount());
            sendStatisticAggList.add(sendStatisticAgg);
        }
        sendStatisticsVo.setAggs(sendStatisticAggList);
        return sendStatisticsVo;
    }
}

