/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.appim.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.msg.appim.dao.MsgAppImSendRecordMapper;
import com.jxdinfo.hussar.msg.appim.dto.AppImChannelSendStatisticsVo;
import com.jxdinfo.hussar.msg.appim.dto.AppImSendRecordDto;
import com.jxdinfo.hussar.msg.appim.dto.AppImSendRecordQueryDto;
import com.jxdinfo.hussar.msg.appim.model.MsgAppImSendRecord;
import com.jxdinfo.hussar.msg.appim.service.AppImChannelService;
import com.jxdinfo.hussar.msg.appim.service.AppImSendRecordService;
import com.jxdinfo.hussar.msg.appim.service.MsgAppImSendRecordDbService;
import com.jxdinfo.hussar.msg.appim.vo.AppImSendRecordVo;
import com.jxdinfo.hussar.msg.common.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.common.model.ChannelsVo;
import com.jxdinfo.hussar.msg.common.utils.ContactInfoEncryptUtils;
import com.jxdinfo.hussar.msg.common.vo.MsgSendRecordCountVo;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class MsgAppImSendRecordDbServiceImpl
extends HussarServiceImpl<MsgAppImSendRecordMapper, MsgAppImSendRecord>
implements MsgAppImSendRecordDbService,
AppImSendRecordService {
    @Autowired
    private MsgAppImSendRecordMapper msgAppImSendRecordMapper;
    @Autowired
    private AppImChannelService appImChannelService;

    public IPage<AppImSendRecordVo> listPage(Page<AppImSendRecordVo> page, AppImSendRecordQueryDto queryDto) {
        queryDto.setAppName(SqlQueryUtil.transferSpecialChar((String)queryDto.getAppName()));
        queryDto.setChannelName(SqlQueryUtil.transferSpecialChar((String)queryDto.getChannelName()));
        queryDto.setSceneName(SqlQueryUtil.transferSpecialChar((String)queryDto.getSceneName()));
        List<AppImSendRecordVo> appImSendRecordVos = this.msgAppImSendRecordMapper.listPage(page, queryDto);
        for (AppImSendRecordVo appImSendRecordVo : appImSendRecordVos) {
            appImSendRecordVo.setUserIds(ContactInfoEncryptUtils.receiveAddressEncrypt((String)appImSendRecordVo.getUserIds()));
        }
        page.setRecords(appImSendRecordVos);
        return page;
    }

    public List<ChannelsVo> getAllChannels() {
        List<ChannelsVo> channelsVos = this.msgAppImSendRecordMapper.listChannels();
        Map channelNoAndName = this.appImChannelService.getChannelNoAndName(channelsVos.stream().map(ChannelsVo::getChannelNo).collect(Collectors.toList()));
        for (ChannelsVo channelsVo : channelsVos) {
            channelsVo.setChannelName((String)channelNoAndName.get(channelsVo.getChannelNo()));
        }
        return channelsVos;
    }

    public List<AppImChannelSendStatisticsVo> sendStatistics(AppImSendRecordQueryDto queryDto) {
        List<MsgSendRecordCountVo> msgSendRecordCountVos = this.msgAppImSendRecordMapper.listSendRecordStatusCount(queryDto.getBeginTime(), queryDto.getEndTime(), queryDto.getChannelNo());
        ArrayList<AppImChannelSendStatisticsVo> sendStatisticsVos = new ArrayList<AppImChannelSendStatisticsVo>();
        if (HussarUtils.isNotEmpty(msgSendRecordCountVos)) {
            List channelNos = msgSendRecordCountVos.parallelStream().map(MsgSendRecordCountVo::getChannelNo).distinct().collect(Collectors.toList());
            Map channelNoAndName = this.appImChannelService.getChannelNoAndName(channelNos);
            Map<String, List<MsgSendRecordCountVo>> channelNoKeyMap = msgSendRecordCountVos.parallelStream().collect(Collectors.groupingBy(MsgSendRecordCountVo::getChannelNo));
            List<String> createDateList = msgSendRecordCountVos.parallelStream().map(MsgSendRecordCountVo::getCreateDate).distinct().sorted().collect(Collectors.toList());
            for (Map.Entry<String, List<MsgSendRecordCountVo>> channelNoKey : channelNoKeyMap.entrySet()) {
                AppImChannelSendStatisticsVo sendStatisticsVo = MsgAppImSendRecordDbServiceImpl.getAppImChannelSendStatisticsVo(channelNoKey, createDateList, channelNoAndName);
                sendStatisticsVos.add(sendStatisticsVo);
            }
        }
        return sendStatisticsVos;
    }

    public boolean saveRecord(AppImSendRecordDto appImSendRecordDto) {
        if (SendStatusEnum.SUCCESS.getCode().equals(appImSendRecordDto.getStatus()) && HussarUtils.isNotEmpty((Object)appImSendRecordDto.getErrorContactInfos())) {
            appImSendRecordDto.setErrMsg("\u90e8\u5206\u53d1\u9001\u6210\u529f\uff0c\u4ee5\u4e0b\u8054\u7cfb\u4eba\u65e0\u6cd5\u53d1\u9001\uff1a" + String.join((CharSequence)"\uff1b", appImSendRecordDto.getErrorContactInfos()));
        }
        MsgAppImSendRecord msgAppImSendRecord = (MsgAppImSendRecord)HussarUtils.copy((Object)appImSendRecordDto, MsgAppImSendRecord.class);
        msgAppImSendRecord.setSendType(appImSendRecordDto.getType());
        return super.save((BaseEntity)msgAppImSendRecord);
    }

    public AppImSendRecordDto findById(String id) {
        MsgAppImSendRecord msgAppImSendRecord = (MsgAppImSendRecord)super.getOne((Wrapper)new LambdaQueryWrapper().eq(MsgAppImSendRecord::getId, (Object)Long.valueOf(id)));
        AppImSendRecordDto appImSendRecordDto = (AppImSendRecordDto)HussarUtils.copy((Object)msgAppImSendRecord, AppImSendRecordDto.class);
        appImSendRecordDto.setType(msgAppImSendRecord.getSendType());
        return appImSendRecordDto;
    }

    private static AppImChannelSendStatisticsVo getAppImChannelSendStatisticsVo(Map.Entry<String, List<MsgSendRecordCountVo>> channelNoKey, List<String> createDateList, Map<String, String> channelNoAndName) {
        AppImChannelSendStatisticsVo sendStatisticsVo = new AppImChannelSendStatisticsVo();
        String channelNo = channelNoKey.getKey();
        List<MsgSendRecordCountVo> msgSendRecordCountVoList = channelNoKey.getValue();
        sendStatisticsVo.setChannelNo(channelNo);
        sendStatisticsVo.setChannelName(channelNoAndName.get(channelNo));
        sendStatisticsVo.setCreateDate(createDateList);
        List<AppImChannelSendStatisticsVo.AppImChannelSendStatisticAgg> sendStatisticAggList = MsgAppImSendRecordDbServiceImpl.getAppImChannelSendStatisticAggs(msgSendRecordCountVoList);
        sendStatisticsVo.setAggs(sendStatisticAggList);
        return sendStatisticsVo;
    }

    private static List<AppImChannelSendStatisticsVo.AppImChannelSendStatisticAgg> getAppImChannelSendStatisticAggs(List<MsgSendRecordCountVo> msgSendRecordCountVoList) {
        ArrayList<AppImChannelSendStatisticsVo.AppImChannelSendStatisticAgg> sendStatisticAggList = new ArrayList<AppImChannelSendStatisticsVo.AppImChannelSendStatisticAgg>();
        for (MsgSendRecordCountVo msgSendRecordCountVo : msgSendRecordCountVoList) {
            AppImChannelSendStatisticsVo.AppImChannelSendStatisticAgg sendStatisticAgg = new AppImChannelSendStatisticsVo.AppImChannelSendStatisticAgg();
            sendStatisticAgg.setSendDate(msgSendRecordCountVo.getCreateDate());
            sendStatisticAgg.setSuccessCount(msgSendRecordCountVo.getSuccessCount());
            sendStatisticAgg.setFailCount(msgSendRecordCountVo.getFailCount());
            sendStatisticAgg.setWillCount(msgSendRecordCountVo.getWillCount());
            sendStatisticAggList.add(sendStatisticAgg);
        }
        return sendStatisticAggList;
    }
}

