/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.sms.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.msg.common.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.common.model.ChannelsVo;
import com.jxdinfo.hussar.msg.common.vo.MsgSendRecordCountVo;
import com.jxdinfo.hussar.msg.sms.dao.MsgSmsSendRecordMapper;
import com.jxdinfo.hussar.msg.sms.dto.SmsSendRecordDto;
import com.jxdinfo.hussar.msg.sms.dto.SmsSendRecordPageDto;
import com.jxdinfo.hussar.msg.sms.dto.SmsSendRecordQueryDto;
import com.jxdinfo.hussar.msg.sms.dto.SmsSendRecordStatisticsVo;
import com.jxdinfo.hussar.msg.sms.model.MsgSmsSendRecord;
import com.jxdinfo.hussar.msg.sms.service.MsgSmsSendRecordDbService;
import com.jxdinfo.hussar.msg.sms.service.SmsChannelService;
import com.jxdinfo.hussar.msg.sms.service.SmsSendRecordService;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class MsgSmsSendRecordDbServiceImpl
extends HussarServiceImpl<MsgSmsSendRecordMapper, MsgSmsSendRecord>
implements MsgSmsSendRecordDbService,
SmsSendRecordService {
    @Autowired
    private MsgSmsSendRecordMapper msgSmsSendRecordMapper;
    @Autowired
    private SmsChannelService smsChannelService;

    public IPage<SmsSendRecordDto> listPage(Page page, SmsSendRecordPageDto pageDto) {
        pageDto.setAppName(SqlQueryUtil.transferSpecialChar((String)pageDto.getAppName()));
        pageDto.setChannelName(SqlQueryUtil.transferSpecialChar((String)pageDto.getChannelName()));
        pageDto.setSceneName(SqlQueryUtil.transferSpecialChar((String)pageDto.getSceneName()));
        pageDto.setPhoneNumber(SqlQueryUtil.transferSpecialChar((String)pageDto.getPhoneNumber()));
        Page sendRecordDtoPage = new Page(page.getCurrent(), page.getSize());
        List<SmsSendRecordDto> smsSendRecordDtos = this.msgSmsSendRecordMapper.listPage((Page<SmsSendRecordDto>)sendRecordDtoPage, pageDto);
        for (SmsSendRecordDto smsSendRecordDto : smsSendRecordDtos) {
            String phoneNumber = smsSendRecordDto.getPhoneNumber();
            if (!HussarUtils.isNotEmpty((Object)phoneNumber)) continue;
            if (phoneNumber.length() == 11) {
                smsSendRecordDto.setPhoneNumber(phoneNumber.replaceAll("(\\d{3})\\d{4}(\\d{4})", "$1****$2"));
                continue;
            }
            smsSendRecordDto.setPhoneNumber(phoneNumber.replaceAll("(\\d{3})(-?)\\d*(\\d{4})", "$1$2****$3"));
        }
        sendRecordDtoPage.setRecords(smsSendRecordDtos);
        return sendRecordDtoPage;
    }

    public SmsSendRecordDto findById(String id) {
        MsgSmsSendRecord msgSmsSendRecord = (MsgSmsSendRecord)super.getOne((Wrapper)new LambdaQueryWrapper().eq(MsgSmsSendRecord::getId, (Object)Long.valueOf(id)));
        return (SmsSendRecordDto)HussarUtils.copy((Object)msgSmsSendRecord, SmsSendRecordDto.class);
    }

    public List<ChannelsVo> getAllChannels() {
        List<ChannelsVo> channelsVos = this.msgSmsSendRecordMapper.listChannels();
        Map channelNoAndName = this.smsChannelService.getChannelNoAndName(channelsVos.stream().map(ChannelsVo::getChannelNo).collect(Collectors.toList()));
        for (ChannelsVo channelsVo : channelsVos) {
            channelsVo.setChannelName((String)channelNoAndName.get(channelsVo.getChannelNo()));
        }
        return channelsVos;
    }

    public List<SmsSendRecordStatisticsVo> sendStatistics(SmsSendRecordQueryDto queryDto) {
        List<MsgSendRecordCountVo> msgSendRecordCountVos = this.msgSmsSendRecordMapper.listSendRecordStatusCount(queryDto.getBeginTime(), queryDto.getEndTime(), queryDto.getChannelNo());
        ArrayList<SmsSendRecordStatisticsVo> sendStatisticsVos = new ArrayList<SmsSendRecordStatisticsVo>();
        if (HussarUtils.isNotEmpty(msgSendRecordCountVos)) {
            List channelNos = msgSendRecordCountVos.parallelStream().map(MsgSendRecordCountVo::getChannelNo).distinct().collect(Collectors.toList());
            Map channelNoAndName = this.smsChannelService.getChannelNoAndName(channelNos);
            Map<String, List<MsgSendRecordCountVo>> channelNoKeyMap = msgSendRecordCountVos.parallelStream().collect(Collectors.groupingBy(MsgSendRecordCountVo::getChannelNo));
            List<String> createDateList = msgSendRecordCountVos.parallelStream().map(MsgSendRecordCountVo::getCreateDate).distinct().sorted().collect(Collectors.toList());
            for (Map.Entry<String, List<MsgSendRecordCountVo>> channelNoKey : channelNoKeyMap.entrySet()) {
                SmsSendRecordStatisticsVo sendStatisticsVo = MsgSmsSendRecordDbServiceImpl.getSmsSendRecordStatisticsVo(channelNoKey, createDateList, channelNoAndName);
                sendStatisticsVos.add(sendStatisticsVo);
            }
        }
        return sendStatisticsVos;
    }

    public void save(SmsSendRecordDto recordDto) {
        if (SendStatusEnum.SUCCESS.getCode().equals(recordDto.getStatus()) && HussarUtils.isNotEmpty((Object)recordDto.getErrorContactInfos())) {
            recordDto.setErrMsg("\u90e8\u5206\u53d1\u9001\u6210\u529f\uff0c\u4ee5\u4e0b\u8054\u7cfb\u4eba\u65e0\u6cd5\u53d1\u9001\uff1a" + String.join((CharSequence)"\uff1b", recordDto.getErrorContactInfos()));
        }
        super.save((BaseEntity)HussarUtils.copy((Object)recordDto, MsgSmsSendRecord.class));
    }

    private static SmsSendRecordStatisticsVo getSmsSendRecordStatisticsVo(Map.Entry<String, List<MsgSendRecordCountVo>> channelNoKey, List<String> createDateList, Map<String, String> channelNoAndName) {
        SmsSendRecordStatisticsVo sendStatisticsVo = new SmsSendRecordStatisticsVo();
        String channelNo = channelNoKey.getKey();
        List<MsgSendRecordCountVo> msgSendRecordCountVoList = channelNoKey.getValue();
        sendStatisticsVo.setChannelNo(channelNo);
        sendStatisticsVo.setChannelName(channelNoAndName.get(channelNo));
        sendStatisticsVo.setCreateDate(createDateList);
        List<SmsSendRecordStatisticsVo.SmsChannelSendStatisticAgg> sendStatisticAggList = MsgSmsSendRecordDbServiceImpl.getSmsChannelSendStatisticAggs(msgSendRecordCountVoList);
        sendStatisticsVo.setAggs(sendStatisticAggList);
        return sendStatisticsVo;
    }

    private static List<SmsSendRecordStatisticsVo.SmsChannelSendStatisticAgg> getSmsChannelSendStatisticAggs(List<MsgSendRecordCountVo> msgSendRecordCountVoList) {
        ArrayList<SmsSendRecordStatisticsVo.SmsChannelSendStatisticAgg> sendStatisticAggList = new ArrayList<SmsSendRecordStatisticsVo.SmsChannelSendStatisticAgg>();
        for (MsgSendRecordCountVo msgSendRecordCountVo : msgSendRecordCountVoList) {
            SmsSendRecordStatisticsVo.SmsChannelSendStatisticAgg sendStatisticAgg = new SmsSendRecordStatisticsVo.SmsChannelSendStatisticAgg();
            sendStatisticAgg.setSendDate(msgSendRecordCountVo.getCreateDate());
            sendStatisticAgg.setSuccessCount(msgSendRecordCountVo.getSuccessCount());
            sendStatisticAgg.setFailCount(msgSendRecordCountVo.getFailCount());
            sendStatisticAgg.setWillCount(msgSendRecordCountVo.getWillCount());
            sendStatisticAggList.add(sendStatisticAgg);
        }
        return sendStatisticAggList;
    }
}

