/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.msg.mp.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.utils.SqlQueryUtil;
import com.jxdinfo.hussar.msg.common.enums.SendStatusEnum;
import com.jxdinfo.hussar.msg.common.model.ChannelsVo;
import com.jxdinfo.hussar.msg.common.utils.ContactInfoEncryptUtils;
import com.jxdinfo.hussar.msg.common.vo.MsgSendRecordCountVo;
import com.jxdinfo.hussar.msg.mp.dao.MsgMpSendRecordMapper;
import com.jxdinfo.hussar.msg.mp.dto.MpChannelSendStatisticsVo;
import com.jxdinfo.hussar.msg.mp.dto.MpSendRecordDto;
import com.jxdinfo.hussar.msg.mp.dto.MpSendRecordPageDto;
import com.jxdinfo.hussar.msg.mp.dto.MpSendRecordQueryVo;
import com.jxdinfo.hussar.msg.mp.model.MsgMpSendRecord;
import com.jxdinfo.hussar.msg.mp.service.MpChannelService;
import com.jxdinfo.hussar.msg.mp.service.MpSendRecordService;
import com.jxdinfo.hussar.msg.mp.service.MsgMpSendRecordDbService;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.datasource.annotations.HussarTokenDs;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@HussarTokenDs
public class MsgMpSendRecordDbServiceImpl
extends HussarServiceImpl<MsgMpSendRecordMapper, MsgMpSendRecord>
implements MsgMpSendRecordDbService,
MpSendRecordService {
    @Autowired
    private MsgMpSendRecordMapper msgMpSendRecordMapper;
    @Autowired
    private MpChannelService mpChannelService;

    public IPage<MpSendRecordQueryVo> listPage(Page page, MpSendRecordPageDto pageDto) {
        pageDto.setAppName(SqlQueryUtil.transferSpecialChar((String)pageDto.getAppName()));
        pageDto.setChannelName(SqlQueryUtil.transferSpecialChar((String)pageDto.getChannelName()));
        pageDto.setSceneName(SqlQueryUtil.transferSpecialChar((String)pageDto.getSceneName()));
        pageDto.setTemplateName(SqlQueryUtil.transferSpecialChar((String)pageDto.getTemplateName()));
        Page sendRecordVoPage = new Page(page.getCurrent(), page.getSize());
        List<MpSendRecordQueryVo> mpSendRecordVos = this.msgMpSendRecordMapper.listPage((Page<MpSendRecordQueryVo>)sendRecordVoPage, pageDto);
        for (MpSendRecordQueryVo mpSendRecordQueryVo : mpSendRecordVos) {
            mpSendRecordQueryVo.setToUser(ContactInfoEncryptUtils.receiveAddressEncrypt((String)mpSendRecordQueryVo.getToUser()));
        }
        sendRecordVoPage.setRecords(mpSendRecordVos);
        return sendRecordVoPage;
    }

    public MpSendRecordQueryVo findById(String id) {
        MsgMpSendRecord msgMpSendRecord = (MsgMpSendRecord)super.getOne((Wrapper)new LambdaQueryWrapper().eq(MsgMpSendRecord::getId, (Object)Long.valueOf(id)));
        return (MpSendRecordQueryVo)HussarUtils.copy((Object)msgMpSendRecord, MpSendRecordQueryVo.class);
    }

    public List<ChannelsVo> getAllChannels() {
        List<ChannelsVo> channelsVos = this.msgMpSendRecordMapper.listChannels();
        Map channelNoAndName = this.mpChannelService.getChannelNoAndName(channelsVos.stream().map(ChannelsVo::getChannelNo).collect(Collectors.toList()));
        for (ChannelsVo channelsVo : channelsVos) {
            channelsVo.setChannelName((String)channelNoAndName.get(channelsVo.getChannelNo()));
        }
        return channelsVos;
    }

    public List<MpChannelSendStatisticsVo> sendStatistics(MpSendRecordPageDto pageDto) {
        List<MsgSendRecordCountVo> msgSendRecordCountVos = this.msgMpSendRecordMapper.listSendRecordStatusCount(pageDto.getBeginTime(), pageDto.getEndTime(), pageDto.getChannelNo());
        ArrayList<MpChannelSendStatisticsVo> sendStatisticsVos = new ArrayList<MpChannelSendStatisticsVo>();
        if (HussarUtils.isNotEmpty(msgSendRecordCountVos)) {
            List channelNos = msgSendRecordCountVos.parallelStream().map(MsgSendRecordCountVo::getChannelNo).distinct().collect(Collectors.toList());
            Map channelNoAndName = this.mpChannelService.getChannelNoAndName(channelNos);
            Map<String, List<MsgSendRecordCountVo>> channelNoKeyMap = msgSendRecordCountVos.parallelStream().collect(Collectors.groupingBy(MsgSendRecordCountVo::getChannelNo));
            List<String> createDateList = msgSendRecordCountVos.parallelStream().map(MsgSendRecordCountVo::getCreateDate).distinct().sorted().collect(Collectors.toList());
            for (Map.Entry<String, List<MsgSendRecordCountVo>> channelNoKey : channelNoKeyMap.entrySet()) {
                MpChannelSendStatisticsVo sendStatisticsVo = MsgMpSendRecordDbServiceImpl.getMpChannelSendStatisticsVo(channelNoKey, createDateList, channelNoAndName);
                sendStatisticsVos.add(sendStatisticsVo);
            }
        }
        return sendStatisticsVos;
    }

    public void saveRecord(MpSendRecordDto mpSendRecordDto) {
        if (SendStatusEnum.SUCCESS.getCode().equals(mpSendRecordDto.getStatus()) && HussarUtils.isNotEmpty((Object)mpSendRecordDto.getErrorContactInfos())) {
            mpSendRecordDto.setErrMsg("\u90e8\u5206\u53d1\u9001\u6210\u529f\uff0c\u4ee5\u4e0b\u8054\u7cfb\u4eba\u65e0\u6cd5\u53d1\u9001\uff1a" + String.join((CharSequence)"\uff1b", mpSendRecordDto.getErrorContactInfos()));
        }
        super.save((BaseEntity)HussarUtils.copy((Object)mpSendRecordDto, MsgMpSendRecord.class));
    }

    private static MpChannelSendStatisticsVo getMpChannelSendStatisticsVo(Map.Entry<String, List<MsgSendRecordCountVo>> channelNoKey, List<String> createDateList, Map<String, String> channelNoAndName) {
        MpChannelSendStatisticsVo sendStatisticsVo = new MpChannelSendStatisticsVo();
        String channelNo = channelNoKey.getKey();
        List<MsgSendRecordCountVo> msgSendRecordCountVoList = channelNoKey.getValue();
        sendStatisticsVo.setChannelNo(channelNo);
        sendStatisticsVo.setChannelName(channelNoAndName.get(channelNo));
        sendStatisticsVo.setCreateDate(createDateList);
        List<MpChannelSendStatisticsVo.MpChannelSendStatisticAgg> sendStatisticAggList = MsgMpSendRecordDbServiceImpl.getMpChannelSendStatisticAggs(msgSendRecordCountVoList);
        sendStatisticsVo.setAggs(sendStatisticAggList);
        return sendStatisticsVo;
    }

    private static List<MpChannelSendStatisticsVo.MpChannelSendStatisticAgg> getMpChannelSendStatisticAggs(List<MsgSendRecordCountVo> msgSendRecordCountVoList) {
        ArrayList<MpChannelSendStatisticsVo.MpChannelSendStatisticAgg> sendStatisticAggList = new ArrayList<MpChannelSendStatisticsVo.MpChannelSendStatisticAgg>();
        for (MsgSendRecordCountVo msgSendRecordCountVo : msgSendRecordCountVoList) {
            MpChannelSendStatisticsVo.MpChannelSendStatisticAgg sendStatisticAgg = new MpChannelSendStatisticsVo.MpChannelSendStatisticAgg();
            sendStatisticAgg.setSendDate(msgSendRecordCountVo.getCreateDate());
            sendStatisticAgg.setSuccessCount(msgSendRecordCountVo.getSuccessCount());
            sendStatisticAgg.setFailCount(msgSendRecordCountVo.getFailCount());
            sendStatisticAgg.setWillCount(msgSendRecordCountVo.getWillCount());
            sendStatisticAggList.add(sendStatisticAgg);
        }
        return sendStatisticAggList;
    }
}

